/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.KCore$;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`LocalTriangleCount()`\n  *  : Returns the number of triangles.\n  *\n  * The triangle count algorithm counts the number of triangles\n  * (triplet of nodes which all pairwise share a link) that each\n  * vertex is a member of, from which additionally the global graph\n  * triangle count and clustering coefficient can be realised.\n  *\n  * The algorithm is similar to that of GraphX and fairly straightforward:\n  * 1. Each vertex compiles a list of neighbours with ID strictly greater than its own,\n  * and sends this list to all neighbours as an array.\n  * 2. Each vertex, starting from a triangle count of zero, looks at the lists of ID\n  * sets it has received, computes the intersection size of each list with its own list\n  * of neighbours, and adds this to the count.\n  * 3. The total triangle count of the graph is calculated as the sum of the triangle\n  * counts of each vertex, divided by 3 (since each triangle is counted for each of the\n  * 3 vertices involved).\n  * 4. The clustering coefficient for each node is calculated as the triangle count for\n  * that node divided by the number of possible triangles for that node. The average\n  * clustering coefficient is the average of these over all the vertices.\n  *\n  * ## States\n  *\n  *  {s}`triangleCount: Long`\n  *    : Number of triangles a vertex is part of\n  *\n  * ## Returns\n  *\n  *  | vertex name       | number of triangles      |\n  *  | ----------------- | ------------------------ |\n  *  | {s}`name: String` | {s}`triangleCount: Long` |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
@ScalaSignature(bytes="\u0006\u0005u3A!\u0003\u0006\u0001+!)!\u0004\u0001C\u00017!)a\u0004\u0001C!?\u001d)qH\u0003E\u0001\u0001\u001a)\u0011B\u0003E\u0001\u0003\")!\u0004\u0002C\u0001!\")a\u0004\u0002C\u00017!)a\u0004\u0002C\u0001#\"9Q\u000bBA\u0001\n\u00131&A\u0005'pG\u0006dGK]5b]\u001edWmQ8v]RT!a\u0003\u0007\u0002\u000b5|G/\u001b4\u000b\u00055q\u0011aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003\u001fA\t!\"\u00197h_JLG\u000f[7t\u0015\t\t\"#\u0001\u0005sCBDGo\u001c:z\u0015\u0005\u0019\u0012aA2p[\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\r\u0013\tIBB\u0001\u0005O_\u0012,G*[:u\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t!\"A\u0003baBd\u0017\u0010\u0006\u0002!GA\u0011\u0011e\f\b\u0003E\rb\u0001\u0001C\u0003%\u0005\u0001\u0007Q%A\u0003he\u0006\u0004\b\u000e\u0005\u0002'[5\tqE\u0003\u0002)S\u0005IqM]1qQZLWm\u001e\u0006\u0003U-\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003YA\t1!\u00199j\u0013\tqsE\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&\u0011\u0001'\f\u0002\u0006\u000fJ\f\u0007\u000f\u001b\u0015\u0005\u0001IbT\b\u0005\u00024u5\tAG\u0003\u00026m\u0005A1oY1mC\u0012|7M\u0003\u00028q\u00059A/Y6fu>,'BA\u001d\u0013\u0003\u00199\u0017\u000e\u001e5vE&\u00111\b\u000e\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\na(AG+_)R#\u0002\t\u0011+Am\u001cX\u0010\u0019'pG\u0006dGK]5b]\u001edWmQ8v]RD\u0013\u0006\u0019\u0006!A)\u0002\u0003E\u000f\u0011SKR,(O\\:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!iJL\u0017M\\4mKNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t+iK\u0002\"(/[1oO2,\u0007eY8v]R\u0004\u0013\r\\4pe&$\b.\u001c\u0011d_VtGo\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011ue&\fgn\u001a7fg*\u0001\u0003E\u000b\u0011)iJL\u0007\u000f\\3uA=4\u0007E\\8eKN\u0004s\u000f[5dQ\u0002\nG\u000e\u001c\u0011qC&\u0014x/[:fAMD\u0017M]3!C\u0002b\u0017N\\6*AQD\u0017\r\u001e\u0011fC\u000eD'\u0002\t\u0011+AY,'\u000f^3yA%\u001c\b%\u0019\u0011nK6\u0014WM\u001d\u0011pM2\u0002cM]8nA]D\u0017n\u00195!C\u0012$\u0017\u000e^5p]\u0006dG.\u001f\u0011uQ\u0016\u0004s\r\\8cC2\u0004sM]1qQ*\u0001\u0003E\u000b\u0011ue&\fgn\u001a7fA\r|WO\u001c;!C:$\u0007e\u00197vgR,'/\u001b8hA\r|WM\u001a4jG&,g\u000e\u001e\u0011dC:\u0004#-\u001a\u0011sK\u0006d\u0017n]3e])\u0001\u0003E\u000b\u0006!A)\u0002C\u000b[3!C2<wN]5uQ6\u0004\u0013n\u001d\u0011tS6LG.\u0019:!i>\u0004C\u000f[1uA=4\u0007e\u0012:ba\"D\u0006%\u00198eA\u0019\f\u0017N\u001d7zAM$(/Y5hQR4wN]<be\u0012T$\u0002\t\u0011+AEr\u0003%R1dQ\u00022XM\u001d;fq\u0002\u001aw.\u001c9jY\u0016\u001c\b%\u0019\u0011mSN$\be\u001c4!]\u0016Lw\r\u001b2pkJ\u001c\be^5uQ\u0002JE\tI:ue&\u001cG\u000f\\=!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011jiN\u0004sn\u001e8-\u0015\u0001\u0002#\u0006I1oI\u0002\u001aXM\u001c3tAQD\u0017n\u001d\u0011mSN$\b\u0005^8!C2d\u0007E\\3jO\"\u0014w.\u001e:tA\u0005\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0018\u000bA\u0001R\u0003E\r\u0018!\u000b\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010\f\u0011ti\u0006\u0014H/\u001b8hA\u0019\u0014x.\u001c\u0011bAQ\u0014\u0018.\u00198hY\u0016\u00043m\\;oi\u0002zg\r\t>fe>d\u0003\u0005\\8pWN\u0004\u0013\r\u001e\u0011uQ\u0016\u0004C.[:ug\u0002zg\rI%E\u0015\u0001\u0002#\u0006I:fiN\u0004\u0013\u000e\u001e\u0011iCN\u0004#/Z2fSZ,G\r\f\u0011d_6\u0004X\u000f^3tAQDW\rI5oi\u0016\u00148/Z2uS>t\u0007e]5{K\u0002zg\rI3bG\"\u0004C.[:uA]LG\u000f\u001b\u0011jiN\u0004sn\u001e8!Y&\u001cHO\u0003\u0011!U\u0001zg\r\t8fS\u001eD'm\\;sg2\u0002\u0013M\u001c3!C\u0012$7\u000f\t;iSN\u0004Co\u001c\u0011uQ\u0016\u00043m\\;oi:R\u0001\u0005\t\u0016!g9\u0002C\u000b[3!i>$\u0018\r\u001c\u0011ue&\fgn\u001a7fA\r|WO\u001c;!_\u001a\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011jg\u0002\u001a\u0017\r\\2vY\u0006$X\r\u001a\u0011bg\u0002\"\b.\u001a\u0011tk6\u0004sN\u001a\u0011uQ\u0016\u0004CO]5b]\u001edWM\u0003\u0011!U\u0001\u001aw.\u001e8ug\u0002zg\rI3bG\"\u0004c/\u001a:uKbd\u0003\u0005Z5wS\u0012,G\r\t2zAM\u0002\u0003f]5oG\u0016\u0004S-Y2iAQ\u0014\u0018.\u00198hY\u0016\u0004\u0013n\u001d\u0011d_VtG/\u001a3!M>\u0014\b%Z1dQ\u0002zg\r\t;iK*\u0001\u0003E\u000b\u00114AY,'\u000f^5dKN\u0004\u0013N\u001c<pYZ,G-\u000b\u0018\u000bA\u0001R\u0003\u0005\u000e\u0018!)\",\u0007e\u00197vgR,'/\u001b8hA\r|WM\u001a4jG&,g\u000e\u001e\u0011g_J\u0004S-Y2iA9|G-\u001a\u0011jg\u0002\u001a\u0017\r\\2vY\u0006$X\r\u001a\u0011bg\u0002\"\b.\u001a\u0011ue&\fgn\u001a7fA\r|WO\u001c;!M>\u0014(\u0002\t\u0011+AQD\u0017\r\u001e\u0011o_\u0012,\u0007\u0005Z5wS\u0012,G\r\t2zAQDW\r\t8v[\n,'\u000fI8gAA|7o]5cY\u0016\u0004CO]5b]\u001edWm\u001d\u0011g_J\u0004C\u000f[1uA9|G-\u001a\u0018!)\",\u0007%\u0019<fe\u0006<WM\u0003\u0011!U\u0001\u001aG.^:uKJLgn\u001a\u0011d_\u00164g-[2jK:$\b%[:!i\",\u0007%\u0019<fe\u0006<W\rI8gAQDWm]3!_Z,'\u000fI1mY\u0002\"\b.\u001a\u0011wKJ$\u0018nY3t])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u0019;sS\u0006tw\r\\3D_VtGO\u000f\u0011M_:<\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!\u001dVl'-\u001a:!_\u001a\u0004CO]5b]\u001edWm\u001d\u0011bAY,'\u000f^3yA%\u001c\b\u0005]1si\u0002zgM\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!m\u0016\u0014H/\u001a=!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005 \u0011ok6\u0014WM\u001d\u0011pM\u0002\"(/[1oO2,7\u000f\t\u0011!A\u0001\u0002CP\u0003\u0011!U\u0001\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.AqT\u0001\u0005\t\u0016!Aq\u00043p]?a]\u0006lWM\u000f\u0011TiJLgn\u001a1!y\u0002Z8/ 1ue&\fgn\u001a7f\u0007>,h\u000e\u001e\u001e!\u0019>tw\r\u0019\u0011}\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0007\rY>o_R,WP\u0003\u0011!U\u0001\u0002S\tZ4fg\u0002BWM]3!CJ,\u0007\u0005\u001e:fCR,G\rI1tAUtG-\u001b:fGR,G\r\f\u0011t_\u0002Jg\r\t;iK\u0002*h\u000eZ3sYfLgn\u001a\u0011oKR<xN]6!SN\u0004C-\u001b:fGR,G\r\t5fe\u0016d#\u0002\t\u0011+A\u001drW-[4iE>,(o]\u0014!e\u00164WM]:!i>\u0004C\u000f[3!k:LwN\u001c\u0011pM\u0002Jg.\f8fS\u001eD'm\\;sg\u0002\ng\u000e\u001a\u0011pkRlc.Z5hQ\n|WO]:/\u0015\u0001\u0002#\u0006\t1a\u0015\u0001\u0002#fL\u0001\u0013\u0019>\u001c\u0017\r\u001c+sS\u0006tw\r\\3D_VtG\u000f\u0005\u0002\u001e\tM\u0019AA\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g!\tIe*D\u0001K\u0015\tYE*\u0001\u0002j_*\tQ*\u0001\u0003kCZ\f\u0017BA(K\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005\u0001EC\u0001*U!\t\u0019vF\u0004\u0002#)\")Ae\u0002a\u0001K\u0005aqO]5uKJ+\u0007\u000f\\1dKR\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[\u0019\u0006!A.\u00198h\u0013\ta\u0016L\u0001\u0004PE*,7\r\u001e")
public class LocalTriangleCount
extends NodeList {
    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return KCore$.MODULE$.apply(2, KCore$.MODULE$.apply$default$2()).apply(graph).clearMessages().step((Function1 & Serializable)v -> {
            LocalTriangleCount.$anonfun$apply$1(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalTriangleCount.$anonfun$apply$2(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalTriangleCount.$anonfun$apply$4(v);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(Vertex v) {
        block0: {
            ((EntityVisitor)((Object)v)).setState("triangleCount", BoxesRunTime.boxToInteger((int)0));
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            v.messageAllNeighbours(v.ID(), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            scala.collection.immutable.Set neighbours = v.messageQueue().toSet();
            ((EntityVisitor)((Object)v)).setState("effNeighbours", neighbours);
            neighbours.foreach((Function1 & Serializable)nb -> {
                v.messageVertex(nb, neighbours, SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$apply$5(IntRef tri$1, scala.collection.immutable.Set neighbours$2, scala.collection.immutable.Set nbs) {
        tri$1.elem += nbs.intersect((Set)neighbours$2).size();
    }

    public static final /* synthetic */ void $anonfun$apply$4(Vertex v) {
        if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) >= 2) {
            scala.collection.immutable.Set neighbours = (scala.collection.immutable.Set)((EntityVisitor)((Object)v)).getState("effNeighbours", ((EntityVisitor)((Object)v)).getState$default$2());
            Seq queue = v.messageQueue();
            IntRef tri = IntRef.create((int)0);
            queue.foreach((Function1 & Serializable)nbs -> {
                LocalTriangleCount.$anonfun$apply$5(tri, neighbours, nbs);
                return BoxedUnit.UNIT;
            });
            ((EntityVisitor)((Object)v)).setState("triangleCount", BoxesRunTime.boxToInteger((int)(tri.elem / 2)));
        }
        ((EntityVisitor)((Object)v)).clearState("effectiveDegree");
        ((EntityVisitor)((Object)v)).clearState("effNeighbours");
    }

    public LocalTriangleCount() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"triangleCount"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

