/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.GlobalClusteringCoefficient$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`GlobalClusteringCoefficient()`\n  *  : Returns the two graph-wide clustering coefficients.\n  *\n  *  The first of these is the average clustering\n  *  coefficient, the mean of all node local clustering coefficients. The second of these is the transitivity\n  *  which is 3 times the number of triangles divided by the number of wedges, representing the probability that\n  *  a randomly chosen wedge is closed as a triangle.\n  *\n  * ## Returns\n  *\n  *  | average clustering       | transitivity               |\n  *  | ------------------------ | -------------------------- |\n  *  | {s}`avgCluster: Double`  | {s}`transitivity: Double`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
@ScalaSignature(bytes="\u0006\u0005e;QAB\u0004\t\u0002I1Q\u0001F\u0004\t\u0002UAQAJ\u0001\u0005\u0002\u001dBQ\u0001K\u0001\u0005B%BQaN\u0001\u0005BaBq\u0001Q\u0001\u0002\u0002\u0013%\u0011)A\u000eHY>\u0014\u0017\r\\\"mkN$XM]5oO\u000e{WM\u001a4jG&,g\u000e\u001e\u0006\u0003\u0011%\tQ!\\8uS\u001aT!AC\u0006\u0002\u000f\u001d,g.\u001a:jG*\u0011A\"D\u0001\u000bC2<wN]5uQ6\u001c(B\u0001\b\u0010\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005M\tQ\"A\u0004\u00037\u001dcwNY1m\u00072,8\u000f^3sS:<7i\\3gM&\u001c\u0017.\u001a8u'\r\ta\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013!C1mO>\u0014\u0018\u000e\u001e5n\u0015\t\t#%\u0001\u0005b]\u0006d\u0017p]5t\u0015\t\u0019S\"A\u0002ba&L!!\n\u0010\u0003\u000f\u001d+g.\u001a:jG\u00061A(\u001b8jiz\"\u0012AE\u0001\u0006CB\u0004H.\u001f\u000b\u0003U5\u0002\"aK\u001b\u000f\u00051jC\u0002\u0001\u0005\u0006]\r\u0001\raL\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0003aMj\u0011!\r\u0006\u0003e\u0001\n\u0011b\u001a:ba\"4\u0018.Z<\n\u0005Q\n$\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\t14GA\u0003He\u0006\u0004\b.\u0001\u0006uC\n,H.\u0019:jg\u0016$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0005q\u0002\u0013!\u0002;bE2,\u0017B\u0001 <\u0005\u0015!\u0016M\u00197f\u0011\u0015qC\u00011\u00010\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005\u0011\u0005CA\"I\u001b\u0005!%BA#G\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0012\u0002\u0007\u001f\nTWm\u0019;)\t\u0005YUK\u0016\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000b\u0001b]2bY\u0006$wn\u0019\u0006\u0003!F\u000bq\u0001^1lKj|WM\u0003\u0002S\u001f\u00051q-\u001b;ik\nL!\u0001V'\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013aV\u0001\u0007\u000e>R#F\u0003\u0011!U\u0001Z8/ 1HY>\u0014\u0017\r\\\"mkN$XM]5oO\u000e{WM\u001a4jG&,g\u000e\u001e\u0015*A*\u0001\u0003E\u000b\u0011!u\u0001\u0012V\r^;s]N\u0004C\u000f[3!i^|\u0007e\u001a:ba\"ls/\u001b3fA\rdWo\u001d;fe&tw\rI2pK\u001a4\u0017nY5f]R\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011!)\",\u0007EZ5sgR\u0004sN\u001a\u0011uQ\u0016\u001cX\rI5tAQDW\rI1wKJ\fw-\u001a\u0011dYV\u001cH/\u001a:j]\u001eT\u0001\u0005\t\u0016!A\r|WM\u001a4jG&,g\u000e\u001e\u0017!i\",\u0007%\\3b]\u0002zg\rI1mY\u0002rw\u000eZ3!Y>\u001c\u0017\r\u001c\u0011dYV\u001cH/\u001a:j]\u001e\u00043m\\3gM&\u001c\u0017.\u001a8ug:\u0002C\u000b[3!g\u0016\u001cwN\u001c3!_\u001a\u0004C\u000f[3tK\u0002J7\u000f\t;iK\u0002\"(/\u00198tSRLg/\u001b;z\u0015\u0001\u0002#\u0006\t\u0011xQ&\u001c\u0007\u000eI5tAM\u0002C/[7fg\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002\"(/[1oO2,7\u000f\t3jm&$W\r\u001a\u0011cs\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002:X\rZ4fg2\u0002#/\u001a9sKN,g\u000e^5oO\u0002\"\b.\u001a\u0011qe>\u0014\u0017MY5mSRL\b\u0005\u001e5bi*\u0001\u0003E\u000b\u0011!C\u0002\u0012\u0018M\u001c3p[2L\be\u00195pg\u0016t\u0007e^3eO\u0016\u0004\u0013n\u001d\u0011dY>\u001cX\r\u001a\u0011bg\u0002\n\u0007\u0005\u001e:jC:<G.\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003EU3ukJt7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!y\u0002\ng/\u001a:bO\u0016\u00043\r\\;ti\u0016\u0014\u0018N\\4!A\u0001\u0002\u0003\u0005\t\u0011}AQ\u0014\u0018M\\:ji&4\u0018\u000e^=!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!y*\u0001\u0003E\u000b\u0011!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1bm\u001e\u001cE.^:uKJT\u0004\u0005R8vE2,\u0007\r\t\u0011}Am\u001cX\u0010\u0019;sC:\u001c\u0018\u000e^5wSRL(\b\t#pk\ndW\r\u0019\u0011!y*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\r\u00191|]>$X- \u0006!A)\u0002\u0003%\u00123hKN\u0004\u0003.\u001a:fA\u0005\u0014X\r\t;sK\u0006$X\r\u001a\u0011bg\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0017!g>\u0004\u0013N\u001a\u0011uQ\u0016\u0004SO\u001c3fe2L\u0018N\\4!]\u0016$xo\u001c:lA%\u001c\b\u0005Z5sK\u000e$X\r\u001a\u0011iKJ,GF\u0003\u0011!U\u0001:c.Z5hQ\n|WO]:(AI,g-\u001a:tAQ|\u0007\u0005\u001e5fAUt\u0017n\u001c8!_\u001a\u0004\u0013N\\\u0017oK&<\u0007NY8veN\u0004\u0013M\u001c3!_V$XF\\3jO\"\u0014w.\u001e:t])\u0001\u0003E\u000b\u0011aA*\u0001\u0003EK\u0018)\t\u0001YUK\u0016")
public final class GlobalClusteringCoefficient {
    public static Table tabularise(GraphPerspective graph) {
        return GlobalClusteringCoefficient$.MODULE$.tabularise(graph);
    }

    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return GlobalClusteringCoefficient$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return GlobalClusteringCoefficient$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GlobalClusteringCoefficient$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return GlobalClusteringCoefficient$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return GlobalClusteringCoefficient$.MODULE$.name();
    }

    public static Logger logger() {
        return GlobalClusteringCoefficient$.MODULE$.logger();
    }
}

