/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`Degree()`\n  *  : return in-degree, out-degree, and degree of nodes\n  *\n  * The degree of a node in an undirected networks counts the number of neighbours that\n  * node has. In directed networks, the in-degree of a note counts the number of incoming edges and the\n  * out-degree the number of outgoing edges.\n  *\n  * ## States\n  *\n  *  {s}`inDegree: Int`\n  *    : The in-degree of the node\n  *\n  *  {s}`outDegree: Int`\n  *    : The out-degree of the node\n  *\n  *  {s}`degree: Int`\n  *    : The undirected degree (i.e. the overall number of neighbours)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | in-degree          | out-degree          | degree           |\n  *  | ----------------- | ------------------ | ------------------- | ---------------- |\n  *  | {s}`name: String` | {s}`inDegree: Int` | {s}`outDegree: Int` | {s}`degree: Int` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.centrality.WeightedDegree)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005a3A\u0001C\u0005\u0001)!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C!=\u001d)a(\u0003E\u0001\u007f\u0019)\u0001\"\u0003E\u0001\u0001\")\u0011\u0004\u0002C\u0001\u001f\")Q\u0004\u0002C\u00015!9\u0001\u000bBA\u0001\n\u0013\t&A\u0002#fOJ,WM\u0003\u0002\u000b\u0017\u0005Q1-\u001a8ue\u0006d\u0017\u000e^=\u000b\u00051i\u0011aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003\u001d=\t!\"\u00197h_JLG\u000f[7t\u0015\t\u0001\u0012#\u0001\u0005sCBDGo\u001c:z\u0015\u0005\u0011\u0012aA2p[\u000e\u00011C\u0001\u0001\u0016!\t1r#D\u0001\f\u0013\tA2B\u0001\u0005O_\u0012,G*[:u\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t\u0011\"A\u0003baBd\u0017\u0010\u0006\u0002 EA\u0011\u0001E\f\b\u0003C\tb\u0001\u0001C\u0003$\u0005\u0001\u0007A%A\u0003he\u0006\u0004\b\u000e\u0005\u0002&Y5\taE\u0003\u0002(Q\u0005IqM]1qQZLWm\u001e\u0006\u0003S)\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003W=\t1!\u00199j\u0013\ticE\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&\u0011q\u0006\f\u0002\u0006\u000fJ\f\u0007\u000f\u001b\u0015\u0005\u0001EZD\b\u0005\u00023s5\t1G\u0003\u00025k\u0005A1oY1mC\u0012|7M\u0003\u00027o\u00059A/Y6fu>,'B\u0001\u001d\u0012\u0003\u00199\u0017\u000e\u001e5vE&\u0011!h\r\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\nQ(AD9_)R#\u0002\t\u0011+Am\u001cX\u0010\u0019#fOJ,W\rK\u0015a\u0015\u0001\u0002#\u0006\t\u0011;AI,G/\u001e:oA%tW\u0006Z3he\u0016,G\u0006I8vi6\"Wm\u001a:fK2\u0002\u0013M\u001c3!I\u0016<'/Z3!_\u001a\u0004cn\u001c3fg*\u0001\u0003E\u000b\u0006!A)\u0002C\u000b[3!I\u0016<'/Z3!_\u001a\u0004\u0013\r\t8pI\u0016\u0004\u0013N\u001c\u0011b]\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0011oKR<xN]6tA\r|WO\u001c;tAQDW\r\t8v[\n,'\u000fI8gA9,\u0017n\u001a5c_V\u00148\u000f\t;iCRT\u0001\u0005\t\u0016!]>$W\r\t5bg:\u0002\u0013J\u001c\u0011eSJ,7\r^3eA9,Go^8sWNd\u0003\u0005\u001e5fA%tW\u0006Z3he\u0016,\u0007e\u001c4!C\u0002rw\u000e^3!G>,h\u000e^:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!S:\u001cw.\\5oO\u0002*GmZ3tA\u0005tG\r\t;iK*\u0001\u0003E\u000b\u0011pkRlC-Z4sK\u0016\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004s.\u001e;h_&tw\rI3eO\u0016\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u001aF/\u0019;fg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A&tG)Z4sK\u0016T\u0004%\u00138uA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005\u00165fA%tW\u0006Z3he\u0016,\u0007e\u001c4!i\",\u0007E\\8eK*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A>,H\u000fR3he\u0016,'\bI%oi\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t+iK\u0002zW\u000f^\u0017eK\u001e\u0014X-\u001a\u0011pM\u0002\"\b.\u001a\u0011o_\u0012,'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004G-Z4sK\u0016T\u0004%\u00138uA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005\u00165fAUtG-\u001b:fGR,G\r\t3fOJ,W\r\t\u0015j]\u0015t\u0003\u0005\u001e5fA=4XM]1mY\u0002rW/\u001c2fe\u0002zg\r\t8fS\u001eD'm\\;sg&R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!%\u0016$XO\u001d8t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002C\u0010\t<feR,\u0007\u0010\t8b[\u0016\u0004\u0003\u0005\t\u0011!A\u0001b\b%\u001b8.I\u0016<'/Z3!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001b\be\\;u[\u0011,wM]3fA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u0010\t3fOJ,W\r\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AqT\u0001\u0005\t\u0016!Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\b-\u001b8EK\u001e\u0014X-\u001a\u001e!\u0013:$\b\r\t?!wNl\bm\\;u\t\u0016<'/Z3;A%sG\u000f\u0019\u0011}Am\u001cX\u0010\u00193fOJ,WM\u000f\u0011J]R\u0004\u0007\u0005 \u0006!A)R\u0001\u0005\t\u0016!A\u0002\u00047p]3fC2\u001cx. \u0006!A)\u00023,\u0018\u0015d_6t#/\u00199ii>\u0014\u0018PL1mO>\u0014\u0018\u000e\u001e5ng::WM\\3sS\u000et3-\u001a8ue\u0006d\u0017\u000e^=//\u0016Lw\r\u001b;fI\u0012+wM]3fS)\u0001\u0003E\u000b\u0011aA\u0002T\u0001\u0005\t\u00160\u0003\u0019!Um\u001a:fKB\u0011A\u0004B\n\u0004\t\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g\r\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006\u0011\u0011n\u001c\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tq\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001@\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005\u0011\u0006CA*W\u001b\u0005!&BA+L\u0003\u0011a\u0017M\\4\n\u0005]#&AB(cU\u0016\u001cG\u000f")
public class Degree
extends NodeList {
    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Degree.$anonfun$apply$1(vertex);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("inDegree", BoxesRunTime.boxToInteger((int)vertex.inDegree()));
        ((EntityVisitor)((Object)vertex)).setState("outDegree", BoxesRunTime.boxToInteger((int)vertex.outDegree()));
        ((EntityVisitor)((Object)vertex)).setState("degree", BoxesRunTime.boxToInteger((int)vertex.degree()));
    }

    public Degree() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inDegree", "outDegree", "degree"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

