
# time period of train and test, on each house
TT_time = {
    1: {
        'train': {
            'start_time': '2013-09-01',
            'end_time': '2015-02-28'
        }, 
        'test': {
            'start_time': '2015-03-01',
            'end_time': '2015-03-31'
        }, 
    },
    2: {
        'train': {
            'start_time': '2013-08-01',
            'end_time': '2014-12-31'
        }, 
        'test': {
            'start_time': '2015-01-01',
            'end_time': '2015-01-31'
        }, 
    },
    3: {
        'train': {
            'start_time': '2013-08-01',
            'end_time': '2014-11-30'
        }, 
        'test': {
            'start_time': '2014-12-01',
            'end_time': '2014-12-31'
        }, 
    },
    4: {
        'train': {
            'start_time': '2013-08-01',
            'end_time': '2014-12-31'
        }, 
        'test': {
            'start_time': '2015-01-01',
            'end_time': '2015-01-31'
        }, 
    },
    5: {
        'train': {
            'start_time': '2014-01-01',
            'end_time': '2015-09-30'
        }, 
        'test': {
            'start_time': '2013-12-01',
            'end_time': '2013-12-31'
        }, 
    },
    6: {
        'train': {
            'start_time': '2014-02-01',
            'end_time': '2015-09-30'
        }, 
        'test': {
            'start_time': '2014-01-01',
            'end_time': '2014-01-31'
        }, 
    },
    7: {
        'train': {
            'start_time': '2013-12-01',
            'end_time': '2015-11-30'
        }, 
        'test': {
            'start_time': '2013-11-01',
            'end_time': '2013-11-30'
        }, 
    },
    8: {
        'train': {
            'start_time': '2013-08-01',
            'end_time': '2014-10-31'
        }, 
        'test': {
            'start_time': '2014-11-01',
            'end_time': '2014-11-30'
        }, 
    },
    9: {
        'train': {
            'start_time': '2014-06-01',
            'end_time': '2015-11-30'
        }, 
        'test': {
            'start_time': '2014-05-01',
            'end_time': '2014-05-31'
        }, 
    },
    10: {
        'train': {
            'start_time': '2014-05-01',
            'end_time': '2015-11-30'
        }, 
        'test': {
            'start_time': '2014-04-01',
            'end_time': '2014-04-30'
        }, 
    },
    11: {
        'train': {
            'start_time': '2014-11-01',
            'end_time': '2015-11-30'
        }, 
        'test': {
            'start_time': '2014-10-01',
            'end_time': '2014-10-31'
        }, 
    },
    12: {
        'train': {
            'start_time': '2014-01-01',
            'end_time': '2014-11-30'
        }, 
        'test': {
            'start_time': '2014-12-01',
            'end_time': '2014-12-31'
        }, 
    },
    13: {
        'train': {
            'start_time': '2014-06-01',
            'end_time': '2015-11-30'
        }, 
        'test': {
            'start_time': '2014-05-01',
            'end_time': '2014-05-31'
        }, 
    },
    14: {
        'train': {
            'start_time': '2014-09-01',
            'end_time': '2015-11-30'
        }, 
        'test': {
            'start_time': '2014-08-01',
            'end_time': '2014-08-31'
        }, 
    },
    15: {
        'train': {
            'start_time': '2014-06-01',
            'end_time': '2015-11-30'
        }, 
        'test': {
            'start_time': '2014-05-01',
            'end_time': '2014-05-31'
        }, 
    },
    16: {
        'train': {
            'start_time': '2014-02-01',
            'end_time': '2014-11-30'
        }, 
        'test': {
            'start_time': '2014-12-01',
            'end_time': '2014-12-31'
        }, 
    },
    17: {
        'train': {
            'start_time': '2014-07-01',
            'end_time': '2015-06-30'
        }, 
        'test': {
            'start_time': '2014-06-01',
            'end_time': '2014-06-30'
        }, 
    },
    18: {
        'train': {
            'start_time': '2014-01-01',
            'end_time': '2014-11-30'
        }, 
        'test': {
            'start_time': '2014-12-01',
            'end_time': '2014-12-31'
        }, 
    },
    19: {
        'train': {
            'start_time': '2014-02-01',
            'end_time': '2014-12-31'
        }, 
        'test': {
            'start_time': '2015-01-01',
            'end_time': '2015-01-31'
        }, 
    },
    20: {
        'train': {
            'start_time': '2014-05-01',
            'end_time': '2015-09-30'
        }, 
        'test': {
            'start_time': '2014-04-01',
            'end_time': '2014-04-30'
        }, 
    },
}


app8H = {
    'fridge': [1, 11, 17, 19, 4, 7, 8],
    'freezer': [1, 1, 10, 13, 16, 17, 19, 3, 4, 6, 7, 7, 8],
    'washer dryer': [1, 8, 9, 17],
    'washing machine': [1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20],
    'dish washer': [1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15, 17, 19, 20],
    'computer': [1, 5, 6, 6, 8, 11, 12, 14, 15, 16, 17, 19],
    'television': [1, 2, 3, 4, 5, 6, 7, 8, 9, 10,12, 13, 14, 15, 16, 16, 17, 18, 19, 20],
    'electric space heater': [1, 15, 15, 9],
    'food processor': [10, 10, 20],
    'toaster': [10, 12, 14, 18, 2, 3, 5, 6, 7, 8],
    'fridge freezer': [10, 11, 12, 14, 15, 15, 16, 17, 18, 2, 20, 3, 4, 5, 9],
    'microwave': [10, 11, 12, 13, 13, 14, 16, 17, 18, 19, 2, 3, 4, 5, 6, 8, 9],
    'kettle': [11, 12, 13, 16, 18, 19, 2, 3, 4, 5, 6, 7, 8, 9],
    'broadband router': [11, 13],
    'audio system': [11, 14, 18, 2, 9],
    'unknown': [12, 12, 12, 13, 20],
    'tumble dryer': [14, 16, 19, 20, 3, 4, 5, 7],
    'dehumidifier': [15],
    'breadmaker': [18],
    'games console': [18],
    'fan': [2],
    'appliance': [20],
    'pond pump': [20]
}

app9H = {
    'fridge':{
        1:(0, ),
        4:(0, ),
        7:(0, ),
        8:(0, ),
        11:(0, ),
        17:(0, ),
        19:(0, ),
    },
    'freezer':{
        1:(1, 2, ),
        3:(2, ),
        4:(1, ),
        6:(0, ),
        7:(1, 2, ),
        8:(1, ),
        10:(2, ),
        13:(1, ),
        16:(0, ),
        17:(1, ),
        19:(1, ),
    },
    'washer dryer':{
        8:(2, ),
        1:(3, ),
        17:(3, ),
        9:(1, ),
    },
    'washing machine':{
        1:(4, ),
        2:(1, ),
        3:(5, ),
        4:(4, 5, ),
        5:(2, ),
        6:(1, ),
        7:(4, ),
        8:(3, ),
        9:(2, ),
        10:(4, ),
        11:(2, ),
        13:(2, ),
        14:(2, ),
        15:(4, ),
        16:(3, ),
        17:(4, ),
        18:(1, ),
        19:(3, ),
        20:(2, ),
    },
    'dish washer':{
        1:(5, ),
        2:(2, ),
        3:(4, ),
        5:(3, ),
        6:(2, ),
        7:(5, ),
        9:(3, ),
        10:(5, ),
        11:(3, ),
        13:(3, ),
        14:(3, ),
        15:(5, ),
        17:(5, ),
        19:(4, ),
        20:(3, ),
    },
    'computer':{
        1:(6, ),
        5:(4, ),
        6:(3, 8, ),
        8:(5, ),
        11:(4, ),
        12:(3, ),
        14:(4, ),
        15:(6, ),
        16:(4, ),
        17:(6, ),
        19:(5, ),
    },
    'television':{
        1:(7, ),
        2:(3, ),
        3:(6, ),
        4:(6, ),
        5:(5, ),
        6:(4, ),
        7:(6, ),
        8:(6, ),
        9:(4, ),
        10:(6, ),
        # 12:(7, ),
        13:(0, ),
        14:(5, ),
        15:(7, ),
        16:(5, 8, ),
        17:(7, ),
        18:(2, ),
        19:(6, ),
        20:(5, ),
    },
    'electric space heater':{
        1:(8, ),
        9:(8, ),
        15:(2, 3, ),
    },
    'food processor':{
        10:(0, 8, ),
        20:(4, ),
    },
    'toaster':{
        2:(5, ),
        3:(0, ),
        5:(8, ),
        6:(7, ),
        7:(7, ),
        8:(4, ),
        10:(1, ),
        # 12:(6, ),     # no data involved
        14:(8, ),
        18:(5, ),
    },
    'fridge freezer':{
        2:(0, ),
        3:(1, ),
        4:(2, ),
        5:(0, ),
        9:(0, ),
        10:(3, ),
        11:(1, ),
        12:(0, ),
        14:(0, ),
        15:(0, 1, ),
        16:(1, ),
        17:(2, ),
        18:(0, ),
        20:(0, ),
    },
    'microwave':{
        2:(4, ),
        3:(7, ),
        4:(7, ),
        5:(6, ),
        6:(5, ),
        8:(7, ),
        9:(5, ),
        10:(7, ),
        11:(5, ),
        12:(4, ),
        13:(6, 7, ),
        14:(6, ),
        16:(6, ),
        17:(8, ),
        18:(3, ),
        19:(7, ),
    },
    'kettle':{
        2:(7, ),
        3:(8, ),
        4:(8, ),
        5:(7, ),
        6:(6, ),
        7:(8, ),
        8:(8, ),
        9:(6, ),
        11:(6, ),
        12:(5, ),
        13:(8, ),
        16:(7, ),
        18:(4, ),
        19:(8, ),
    },
    'broadband router':{
        11:(7, ),
        13:(5, ),
    },
    'audio system':{
        2:(6, ),
        9:(7, ),
        11:(8, ),
        14:(7, ),
        18:(8, ),
    },
    'tumble dryer':{
        3:(3, ),
        4:(3, ),
        5:(1, ),
        7:(3, ),
        14:(1, ),
        16:(2, ),
        19:(2, ),
        20:(1, ),
    },
    'dehumidifier':{
        15:(8, ),
    },
    'breadmaker':{
        18:(6, ),
    },
    'games console':{
        18:(7, ),
    },
    'fan':{
        2:(8, ),
    },
    'appliance':{
        20:(7, ),
    },
    'pond pump':{
        20:(8, ),
    },
}


""" A collection of all appliances available. Each appliance has a consumption mean 
and standard deviation, as well as a list of houses containing the appliance. """

appliance_data = {
    "kettle": {
        "mean": 700,
        "std": 1000,
        "houses": [2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 19, 20],
        "channels": [8, 9, 9, 8, 7, 9, 9, 7, 6, 9, 5, 9],
        "test_house": 2,
        "validation_house": 5,
    },
    "fridge": {
        "mean": 200,
        "std": 400,
        "houses": [2, 5, 9, 12, 15],
        "channels": [1, 1, 1, 1, 1],
        "test_house": 15,
        "validation_house": 12
    },
    "dishwasher": {
        "mean": 700,
        "std": 1000,
        "houses": [5, 7, 9, 13, 16, 18, 20],
        "channels": [4, 6, 4, 4, 6, 6, 5],
        "test_house": 9,
        "validation_house": 18,     
    },
    "washingmachine": {
        "mean": 400,
        "std": 700,
        "houses": [2, 5, 7, 8, 9, 15, 16, 17, 18],
        "channels": [2, 3, 5, 4, 3, 3, 5, 4, 5],
        "test_house": 8,
        "validation_house": 18,
    },
    "microwave": {
        "mean": 500,
        "std": 800,
        "houses": [4, 10, 12, 17, 19],
        "channels": [8, 8, 3, 7, 4],
        "test_house": 4,
        "validation_house": 17,
    },
    'freezer': {
        'mean': 50,
        'std': 13,
        'houses': [7, 7, 8],
        'channels': [2, 3, 3],

    },
    #  my collection, excluding power-off period
    'Freezer(1)': {
        'mean': 96, 
        'std': 35,
    }, 
    'Fridge': {
        'mean' : 80, 
        'std' : 22,
    },
    'Washing_Machine': {
        'mean': 2036, 
        'std': 83,
    },
    'Dishwasher': {
        'mean': 2145, 
        'std': 75,
    }
}

# The std and mean values for normalising the mains data which are used
# as input to the networks
mains_data = {
    "mean": 522,
    "std":  814        
    }

if __name__ == '__main__':
    
    from pandas import to_datetime, Timedelta
    for k1, i1 in TT_time.items():
        
        for k2, i2 in i1.items():
            print(Timedelta(to_datetime(i2['end_time']) - to_datetime(i2['start_time'])))
            for k3, i3 in i2.items():
                print('{:2}:{:>6}:{:>11}'.format(k1, k2, k3), end='\t')
                print(to_datetime(i3))
                pass
        print('')