# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/09_tools.ipynb (unless otherwise specified).

__all__ = ['custom_response', 'is_valid_csv', 'get_valid_names_in_connector']

# Cell
import json

# Cell

def custom_response(res):
    """ De-Serializes the JSON response
    """
    try:
        return json.loads(res.text), res
    except:
        return "No JSON available", res

# Cell


def is_valid_csv(file):
    """ A valid file is a csv file whose name is in a
    set of valid names

    """
    valid_names = [
        'agents',
        'calls',
        'summary',
        'skills',
        'teams',
        'campaings',
    ]

    filename = file.split('/')[-1].split('.')
    if len(filename) == 1:
        return False

    fname, ext = filename
    is_valid_name = any(vname in fname for vname in valid_names)
    return is_valid_name and ext.lower() == 'csv'

# Cell


def get_valid_names_in_connector(list_queues):
    """ Gets a list of valid names from the list of queues
    """
    flowfile_summaries = list_queues['listingRequest']['flowFileSummaries']
    valid_uuids = [
        ff['filename']
        for ff in flowfile_summaries
        if is_valid_csv(ff['filename'])
    ]
    return valid_uuids