# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/04_source_to_refined.ipynb (unless otherwise specified).

__all__ = ['NifiIds', 'source_to_refined', 'source_to_discovery']

# Cell

import json
from os import environ
from time import sleep
from .dataflow import DataFlow
from .environment import DataFlowIds

# Cell
class NifiIds:
    """ The collection of the DataFlowIds:
          - source to raw
          - raw to discovery
          - discovery to refined
    """

    nifi_json_ids = json.load(open(environ['CONFIG_FILE']))['NifiIds']

    sourceToRaw = DataFlowIds(pipeline=nifi_json_ids['SourceToRaw'])
    rawToDiscovery = DataFlowIds(pipeline=nifi_json_ids['RawToDiscovery'])
    discoveryToRefined = DataFlowIds(
        pipeline=nifi_json_ids['DiscoveryToRefined'])

# Cell
def source_to_refined():
    """ The Source To Refined dataflow is decomposed in three sequential steps:
        - Source To Raw
        - Raw To Discovery
        - Discovery To Refined
    This function assures that each of these steps starts only after the
    previous step has finished.
    """

    # time between steps
    T = 15
    time_after_start = 15

    time_between_checks = 15

    source_to_raw = DataFlow(
        NifiIds.sourceToRaw,
        delay_seconds_after_start=time_after_start,
        delay_seconds_between_checks=time_between_checks,
    )
    raw_to_discovery = DataFlow(
        NifiIds.rawToDiscovery,
        delay_seconds_after_start=time_after_start,
        delay_seconds_between_checks=time_between_checks,
    )
    discovery_to_refined = DataFlow(
        NifiIds.discoveryToRefined,
        delay_seconds_after_start=time_after_start,
        delay_seconds_between_checks=time_between_checks,
    )

    source_to_raw.run()
    sleep(T)
    raw_to_discovery.run()
    sleep(T)
    discovery_to_refined.run()

# Cell
def source_to_discovery():
    """ The Source To Refined dataflow is decomposed in three sequential steps:
        - Source To Raw
        - Raw To Discovery
    This function assures that each of these steps starts only after the
    previous step has finished.
    """

    # time between steps
    T = 15
    time_after_start = 15

    time_between_checks = 15

    source_to_raw = DataFlow(
        NifiIds.sourceToRaw,
        delay_seconds_after_start=time_after_start,
        delay_seconds_between_checks=time_between_checks,
    )
    raw_to_discovery = DataFlow(
        NifiIds.rawToDiscovery,
        delay_seconds_after_start=time_after_start,
        delay_seconds_between_checks=time_between_checks,
    )
    source_to_raw.run()
    sleep(T)
    raw_to_discovery.run()