# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_rest.ipynb (unless otherwise specified).

__all__ = ['Processor', 'Flowfiles']

# Cell

import requests
import json
from .environment import NifiEndpoint, Credentials
from .tools import custom_response, get_valid_names_in_connector

# Cell


class Processor:

    nifi_api = NifiEndpoint.processors

    def __init__(self, processor_id: str) -> None:
        self.processor_id = processor_id

    def get(self) -> tuple:
        url = self.nifi_api + self.processor_id
        res = requests.get(url, auth=Credentials.credentials)
        return custom_response(res)

    def get_state(self) -> None:
        self.state, _ = self.get()
        self.version = self.state['revision']['version']

    def update_run_status(self, state) -> tuple:
        """
Change the status of the processor.

 Attributes
----------
state : str
     The possible values are: "RUNNING", "STOPPED", "DISABLED".

 Returns
----------
 custom_response : tuple
   The response as defined in tools module
"""

        self.get_state()

        data = {
            "revision": {
                #   'clientId': self.client_id,
                'version': self.version
            },
            "state": state,
            "disconnectedNodeAcknowledged": True
        }

        url = self.nifi_api + f"{self.processor_id}/run-status"

        res = requests.put(url,
                           data=json.dumps(data),
                           auth=Credentials.credentials,
                           headers={'content-type': 'application/json'})
        return custom_response(res)

# Cell


class Flowfiles:

    def __init__(self, connection_id: str) -> None:
        self.connection_id = connection_id

    def post_listing_request(self) -> None:
        url = NifiEndpoint.flowfile_queues + f"{self.connection_id}/listing-requests"
        res = requests.post(url, auth=Credentials.credentials)
        self.listing_request = custom_response(res)[0]
        self.listing_request_id = self.listing_request["listingRequest"]['id']

    def get_list_queue(self) -> None:
        self.post_listing_request()
        endpoint = f"{self.connection_id}/listing-requests/{self.listing_request_id}"
        url = NifiEndpoint.flowfile_queues + endpoint
        res = requests.get(url, auth=Credentials.credentials)
        self.list_queue, _ = custom_response(res)

    def get_ids(self) -> None:
        self.get_list_queue()
        self.ids = get_valid_names_in_connector(self.list_queue)

    def equals(self, flowfile) -> bool:
        return set(self.ids) == set(flowfile.ids)