# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_dataflow.ipynb (unless otherwise specified).

__all__ = ['DataFlow']

# Cell

import time

from .rest import Flowfiles, Processor

# Cell


class DataFlow:
    """
    Monitors and controls a Nifi dataflow. The dataflow starts
    when the **run** method is called.

    Parameters
   -------------

      dataFlowIds: DataFlowIds
        data structure that contains all the IDs of the in/out
        processors and connections

"""

    def __init__(
        self,
        dataflow_ids: object,
        delay_seconds_after_start: int = 14,
        delay_seconds_between_checks: int = 15,
    ) -> None:
        self.in_processor = Processor(dataflow_ids.in_processor)
        self.in_flowfiles = Flowfiles(dataflow_ids.in_connection)
        self.middle_processor = Processor(dataflow_ids.middle_processor)
        self.out_processor = Processor(dataflow_ids.out_processor)
        self.out_flowfiles = Flowfiles(dataflow_ids.out_connection)

        self.seconds_after_start = delay_seconds_after_start
        self.seconds_between_checks = delay_seconds_between_checks

    def run(self) -> None:

        print('pipeline watching has started..')

        self.out_processor.update_run_status("STOPPED")
        self.in_processor.update_run_status("RUNNING")
        time.sleep(self.seconds_after_start)
        self.in_flowfiles.get_ids()
        self.middle_processor.update_run_status("RUNNING")
        self.in_processor.update_run_status("STOPPED")

        while True:

            self.out_flowfiles.get_ids()

            if self.in_flowfiles.equals(self.out_flowfiles):

                self.middle_processor.update_run_status("STOPPED")
                self.out_processor.update_run_status("RUNNING")
                print("Pipeline watching has finished ...")
                break
            time.sleep(self.seconds_between_checks)