"""Lists of DLLs to handle specially."""

import re

# ignore_names_32 is a set containing the lowercase names of all DLLs that can
# be assumed to be present on 32-bit Windows 7 or later. These are all the files
# with extension .dll or .drv found in C:\Windows\SysWOW64 on a vanilla Windows
# 7 Ultimate SP1 64-bit installation.
ignore_names_32 = {
    'aaclient.dll',
    'accessibilitycpl.dll',
    'acctres.dll',
    'acledit.dll',
    'aclui.dll',
    'acppage.dll',
    'actioncenter.dll',
    'actioncentercpl.dll',
    'activeds.dll',
    'actxprxy.dll',
    'admtmpl.dll',
    'adprovider.dll',
    'adsldp.dll',
    'adsldpc.dll',
    'adsmsext.dll',
    'adsnt.dll',
    'adtschema.dll',
    'advapi32.dll',
    'advpack.dll',
    'aecache.dll',
    'aeevts.dll',
    'alttab.dll',
    'amstream.dll',
    'amxread.dll',
    'apds.dll',
    'api-ms-win-core-file-l1-2-0.dll',
    'api-ms-win-core-file-l2-1-0.dll',
    'api-ms-win-core-localization-l1-2-0.dll',
    'api-ms-win-core-processthreads-l1-1-1.dll',
    'api-ms-win-core-synch-l1-2-0.dll',
    'api-ms-win-core-timezone-l1-1-0.dll',
    'api-ms-win-core-xstate-l2-1-0.dll',
    'api-ms-win-crt-conio-l1-1-0.dll',
    'api-ms-win-crt-convert-l1-1-0.dll',
    'api-ms-win-crt-environment-l1-1-0.dll',
    'api-ms-win-crt-filesystem-l1-1-0.dll',
    'api-ms-win-crt-heap-l1-1-0.dll',
    'api-ms-win-crt-locale-l1-1-0.dll',
    'api-ms-win-crt-math-l1-1-0.dll',
    'api-ms-win-crt-multibyte-l1-1-0.dll',
    'api-ms-win-crt-private-l1-1-0.dll',
    'api-ms-win-crt-process-l1-1-0.dll',
    'api-ms-win-crt-runtime-l1-1-0.dll',
    'api-ms-win-crt-stdio-l1-1-0.dll',
    'api-ms-win-crt-string-l1-1-0.dll',
    'api-ms-win-crt-time-l1-1-0.dll',
    'api-ms-win-crt-utility-l1-1-0.dll',
    'apilogen.dll',
    'apircl.dll',
    'apisetschema.dll',
    'apphelp.dll',
    'apphlpdm.dll',
    'appidapi.dll',
    'appidpolicyengineapi.dll',
    'appmgmts.dll',
    'appmgr.dll',
    'apss.dll',
    'asferror.dll',
    'aspnet_counters.dll',
    'asycfilt.dll',
    'atl.dll',
    'atmfd.dll',
    'atmlib.dll',
    'audiodev.dll',
    'audioeng.dll',
    'audiokse.dll',
    'audioses.dll',
    'auditnativesnapin.dll',
    'auditpolicygpinterop.dll',
    'auditpolmsg.dll',
    'authfwcfg.dll',
    'authfwgp.dll',
    'authfwsnapin.dll',
    'authfwwizfwk.dll',
    'authui.dll',
    'authz.dll',
    'autoplay.dll',
    'auxiliarydisplayapi.dll',
    'auxiliarydisplaycpl.dll',
    'avicap32.dll',
    'avifil32.dll',
    'avrt.dll',
    'azroles.dll',
    'azroleui.dll',
    'azsqlext.dll',
    'basecsp.dll',
    'batmeter.dll',
    'bcrypt.dll',
    'bcryptprimitives.dll',
    'bidispl.dll',
    'biocredprov.dll',
    'bitsperf.dll',
    'bitsprx2.dll',
    'bitsprx3.dll',
    'bitsprx4.dll',
    'bitsprx5.dll',
    'bitsprx6.dll',
    'blackbox.dll',
    'bootvid.dll',
    'browcli.dll',
    'browseui.dll',
    'btpanui.dll',
    'bwcontexthandler.dll',
    'bwunpairelevated.dll',
    'cabinet.dll',
    'cabview.dll',
    'capiprovider.dll',
    'capisp.dll',
    'catsrv.dll',
    'catsrvps.dll',
    'catsrvut.dll',
    'cca.dll',
    'cdosys.dll',
    'certcli.dll',
    'certcredprovider.dll',
    'certenc.dll',
    'certenroll.dll',
    'certenrollui.dll',
    'certmgr.dll',
    'certpoleng.dll',
    'cewmdm.dll',
    'cfgbkend.dll',
    'cfgmgr32.dll',
    'chsbrkr.dll',
    'chtbrkr.dll',
    'chxreadingstringime.dll',
    'cic.dll',
    'clb.dll',
    'clbcatq.dll',
    'clfsw32.dll',
    'cliconfg.dll',
    'clusapi.dll',
    'cmcfg32.dll',
    'cmdial32.dll',
    'cmicryptinstall.dll',
    'cmifw.dll',
    'cmipnpinstall.dll',
    'cmlua.dll',
    'cmpbk32.dll',
    'cmstplua.dll',
    'cmutil.dll',
    'cngaudit.dll',
    'cngprovider.dll',
    'cnvfat.dll',
    'colbact.dll',
    'colorcnv.dll',
    'colorui.dll',
    'comcat.dll',
    'comctl32.dll',
    'comdlg32.dll',
    'compobj.dll',
    'compstui.dll',
    'comrepl.dll',
    'comres.dll',
    'comsnap.dll',
    'comsvcs.dll',
    'comuid.dll',
    'connect.dll',
    'console.dll',
    'cpfilters.dll',
    'credssp.dll',
    'credui.dll',
    'crtdll.dll',
    'crypt32.dll',
    'cryptbase.dll',
    'cryptdlg.dll',
    'cryptdll.dll',
    'cryptext.dll',
    'cryptnet.dll',
    'cryptsp.dll',
    'cryptsvc.dll',
    'cryptui.dll',
    'cryptxml.dll',
    'cscapi.dll',
    'cscdll.dll',
    'cscobj.dll',
    'ctl3d32.dll',
    'c_g18030.dll',
    'c_is2022.dll',
    'c_iscii.dll',
    'd2d1.dll',
    'd3d10.dll',
    'd3d10core.dll',
    'd3d10level9.dll',
    'd3d10warp.dll',
    'd3d10_1.dll',
    'd3d10_1core.dll',
    'd3d11.dll',
    'd3d8.dll',
    'd3d8thk.dll',
    'd3d9.dll',
    'd3dcompiler_47.dll',
    'd3dim.dll',
    'd3dim700.dll',
    'd3dramp.dll',
    'd3dxof.dll',
    'dataclen.dll',
    'davclnt.dll',
    'davhlpr.dll',
    'dbgeng.dll',
    'dbghelp.dll',
    'dbnetlib.dll',
    'dbnmpntw.dll',
    'dciman32.dll',
    'ddaclsys.dll',
    'ddoiproxy.dll',
    'ddores.dll',
    'ddraw.dll',
    'ddrawex.dll',
    'defaultlocationcpl.dll',
    'deskadp.dll',
    'deskmon.dll',
    'deskperf.dll',
    'devenum.dll',
    'devicecenter.dll',
    'devicedisplaystatusmanager.dll',
    'devicemetadataparsers.dll',
    'devicepairing.dll',
    'devicepairingfolder.dll',
    'devicepairinghandler.dll',
    'devicepairingproxy.dll',
    'deviceuxres.dll',
    'devmgr.dll',
    'devobj.dll',
    'devrtl.dll',
    'dfscli.dll',
    'dfshim.dll',
    'dfsshlex.dll',
    'dhcpcmonitor.dll',
    'dhcpcore.dll',
    'dhcpcore6.dll',
    'dhcpcsvc.dll',
    'dhcpcsvc6.dll',
    'dhcpqec.dll',
    'dhcpsapi.dll',
    'difxapi.dll',
    'dimsjob.dll',
    'dimsroam.dll',
    'dinput.dll',
    'dinput8.dll',
    'diskcopy.dll',
    'dispex.dll',
    'display.dll',
    'dmband.dll',
    'dmcompos.dll',
    'dmdlgs.dll',
    'dmdskmgr.dll',
    'dmdskres.dll',
    'dmdskres2.dll',
    'dmime.dll',
    'dmintf.dll',
    'dmloader.dll',
    'dmocx.dll',
    'dmrc.dll',
    'dmscript.dll',
    'dmstyle.dll',
    'dmsynth.dll',
    'dmusic.dll',
    'dmutil.dll',
    'dmvdsitf.dll',
    'dnsapi.dll',
    'dnscmmc.dll',
    'docprop.dll',
    'dot3api.dll',
    'dot3cfg.dll',
    'dot3dlg.dll',
    'dot3gpclnt.dll',
    'dot3gpui.dll',
    'dot3hc.dll',
    'dot3msm.dll',
    'dot3ui.dll',
    'dpapiprovider.dll',
    'dplayx.dll',
    'dpmodemx.dll',
    'dpnaddr.dll',
    'dpnathlp.dll',
    'dpnet.dll',
    'dpnhpast.dll',
    'dpnhupnp.dll',
    'dpnlobby.dll',
    'dpwsockx.dll',
    'dpx.dll',
    'drmmgrtn.dll',
    'drmv2clt.dll',
    'drprov.dll',
    'drt.dll',
    'drtprov.dll',
    'drttransport.dll',
    'drvstore.dll',
    'ds32gt.dll',
    'dsauth.dll',
    'dsdmo.dll',
    'dshowrdpfilter.dll',
    'dskquota.dll',
    'dskquoui.dll',
    'dsound.dll',
    'dsprop.dll',
    'dsquery.dll',
    'dsrole.dll',
    'dssec.dll',
    'dssenh.dll',
    'dsuiext.dll',
    'dswave.dll',
    'dtsh.dll',
    'dui70.dll',
    'duser.dll',
    'dwmapi.dll',
    'dwmcore.dll',
    'dwrite.dll',
    'dxdiagn.dll',
    'dxgi.dll',
    'dxmasf.dll',
    'dxptaskringtone.dll',
    'dxptasksync.dll',
    'dxtmsft.dll',
    'dxtrans.dll',
    'dxva2.dll',
    'eapp3hst.dll',
    'eappcfg.dll',
    'eappgnui.dll',
    'eapphost.dll',
    'eappprxy.dll',
    'eapqec.dll',
    'efsadu.dll',
    'efscore.dll',
    'efsutil.dll',
    'ehstorapi.dll',
    'ehstorpwdmgr.dll',
    'ehstorshell.dll',
    'els.dll',
    'elscore.dll',
    'elshyph.dll',
    'elslad.dll',
    'elstrans.dll',
    'encapi.dll',
    'encdec.dll',
    'eqossnap.dll',
    'es.dll',
    'esent.dll',
    'esentprf.dll',
    'eventcls.dll',
    'evr.dll',
    'explorerframe.dll',
    'expsrv.dll',
    'f3ahvoas.dll',
    'faultrep.dll',
    'fdbth.dll',
    'fdbthproxy.dll',
    'fde.dll',
    'fdeploy.dll',
    'fdpnp.dll',
    'fdproxy.dll',
    'fdssdp.dll',
    'fdwcn.dll',
    'fdwnet.dll',
    'fdwsd.dll',
    'feclient.dll',
    'filemgmt.dll',
    'findnetprinters.dll',
    'firewallapi.dll',
    'firewallcontrolpanel.dll',
    'fltlib.dll',
    'fmifs.dll',
    'fms.dll',
    'fontext.dll',
    'fontsub.dll',
    'fphc.dll',
    'framedyn.dll',
    'framedynos.dll',
    'fthsvc.dll',
    'fundisc.dll',
    'fwcfg.dll',
    'fwpuclnt.dll',
    'fwremotesvr.dll',
    'fxsapi.dll',
    'fxscom.dll',
    'fxscomex.dll',
    'fxsext32.dll',
    'fxsresm.dll',
    'fxsxp32.dll',
    'gameux.dll',
    'gameuxlegacygdfs.dll',
    'gcdef.dll',
    'gdi32.dll',
    'getuname.dll',
    'glmf32.dll',
    'glu32.dll',
    'gpapi.dll',
    'gpedit.dll',
    'gpprefcl.dll',
    'gpprnext.dll',
    'gpscript.dll',
    'gptext.dll',
    'hbaapi.dll',
    'hcproviders.dll',
    'helppaneproxy.dll',
    'hgcpl.dll',
    'hhsetup.dll',
    'hid.dll',
    'hidserv.dll',
    'hlink.dll',
    'hnetcfg.dll',
    'hnetmon.dll',
    'httpapi.dll',
    'htui.dll',
    'ias.dll',
    'iasacct.dll',
    'iasads.dll',
    'iasdatastore.dll',
    'iashlpr.dll',
    'iasmigplugin.dll',
    'iasnap.dll',
    'iaspolcy.dll',
    'iasrad.dll',
    'iasrecst.dll',
    'iassam.dll',
    'iassdo.dll',
    'iassvcs.dll',
    'icardie.dll',
    'icardres.dll',
    'iccvid.dll',
    'icm32.dll',
    'icmp.dll',
    'icmui.dll',
    'iconcodecservice.dll',
    'icsigd.dll',
    'idndl.dll',
    'idstore.dll',
    'ieadvpack.dll',
    'ieapfltr.dll',
    'iedkcs32.dll',
    'ieetwproxystub.dll',
    'ieframe.dll',
    'iepeers.dll',
    'iernonce.dll',
    'iertutil.dll',
    'iesetup.dll',
    'iesysprep.dll',
    'ieui.dll',
    'ifmon.dll',
    'ifsutil.dll',
    'ifsutilx.dll',
    'imagehlp.dll',
    'imageres.dll',
    'imagesp1.dll',
    'imapi.dll',
    'imapi2.dll',
    'imapi2fs.dll',
    'imgutil.dll',
    'imjp10k.dll',
    'imm32.dll',
    'inetcomm.dll',
    'inetmib1.dll',
    'inetres.dll',
    'infocardapi.dll',
    'inked.dll',
    'input.dll',
    'inseng.dll',
    'iologmsg.dll',
    'ipbusenumproxy.dll',
    'iphlpapi.dll',
    'iprop.dll',
    'iprtprio.dll',
    'iprtrmgr.dll',
    'ipsecsnp.dll',
    'ipsmsnap.dll',
    'ir32_32.dll',
    'ir41_qc.dll',
    'ir41_qcx.dll',
    'ir50_32.dll',
    'ir50_qc.dll',
    'ir50_qcx.dll',
    'irclass.dll',
    'iscsicpl.dll',
    'iscsidsc.dll',
    'iscsied.dll',
    'iscsium.dll',
    'iscsiwmi.dll',
    'itircl.dll',
    'itss.dll',
    'itvdata.dll',
    'iyuv_32.dll',
    'javascriptcollectionagent.dll',
    'jscript.dll',
    'jscript9.dll',
    'jscript9diag.dll',
    'jsintl.dll',
    'jsproxy.dll',
    'kbd101.dll',
    'kbd101a.dll',
    'kbd101b.dll',
    'kbd101c.dll',
    'kbd103.dll',
    'kbd106.dll',
    'kbd106n.dll',
    'kbda1.dll',
    'kbda2.dll',
    'kbda3.dll',
    'kbdal.dll',
    'kbdarme.dll',
    'kbdarmw.dll',
    'kbdax2.dll',
    'kbdaze.dll',
    'kbdazel.dll',
    'kbdbash.dll',
    'kbdbe.dll',
    'kbdbene.dll',
    'kbdbgph.dll',
    'kbdbgph1.dll',
    'kbdbhc.dll',
    'kbdblr.dll',
    'kbdbr.dll',
    'kbdbu.dll',
    'kbdbulg.dll',
    'kbdca.dll',
    'kbdcan.dll',
    'kbdcr.dll',
    'kbdcz.dll',
    'kbdcz1.dll',
    'kbdcz2.dll',
    'kbdda.dll',
    'kbddiv1.dll',
    'kbddiv2.dll',
    'kbddv.dll',
    'kbdes.dll',
    'kbdest.dll',
    'kbdfa.dll',
    'kbdfc.dll',
    'kbdfi.dll',
    'kbdfi1.dll',
    'kbdfo.dll',
    'kbdfr.dll',
    'kbdgae.dll',
    'kbdgeo.dll',
    'kbdgeoer.dll',
    'kbdgeoqw.dll',
    'kbdgkl.dll',
    'kbdgr.dll',
    'kbdgr1.dll',
    'kbdgrlnd.dll',
    'kbdhau.dll',
    'kbdhe.dll',
    'kbdhe220.dll',
    'kbdhe319.dll',
    'kbdheb.dll',
    'kbdhela2.dll',
    'kbdhela3.dll',
    'kbdhept.dll',
    'kbdhu.dll',
    'kbdhu1.dll',
    'kbdibm02.dll',
    'kbdibo.dll',
    'kbdic.dll',
    'kbdinasa.dll',
    'kbdinbe1.dll',
    'kbdinbe2.dll',
    'kbdinben.dll',
    'kbdindev.dll',
    'kbdinguj.dll',
    'kbdinhin.dll',
    'kbdinkan.dll',
    'kbdinmal.dll',
    'kbdinmar.dll',
    'kbdinori.dll',
    'kbdinpun.dll',
    'kbdintam.dll',
    'kbdintel.dll',
    'kbdinuk2.dll',
    'kbdir.dll',
    'kbdit.dll',
    'kbdit142.dll',
    'kbdiulat.dll',
    'kbdjpn.dll',
    'kbdkaz.dll',
    'kbdkhmr.dll',
    'kbdkor.dll',
    'kbdkyr.dll',
    'kbdla.dll',
    'kbdlao.dll',
    'kbdlk41a.dll',
    'kbdlt.dll',
    'kbdlt1.dll',
    'kbdlt2.dll',
    'kbdlv.dll',
    'kbdlv1.dll',
    'kbdmac.dll',
    'kbdmacst.dll',
    'kbdmaori.dll',
    'kbdmlt47.dll',
    'kbdmlt48.dll',
    'kbdmon.dll',
    'kbdmonmo.dll',
    'kbdne.dll',
    'kbdnec.dll',
    'kbdnec95.dll',
    'kbdnecat.dll',
    'kbdnecnt.dll',
    'kbdnepr.dll',
    'kbdno.dll',
    'kbdno1.dll',
    'kbdnso.dll',
    'kbdpash.dll',
    'kbdpl.dll',
    'kbdpl1.dll',
    'kbdpo.dll',
    'kbdro.dll',
    'kbdropr.dll',
    'kbdrost.dll',
    'kbdru.dll',
    'kbdru1.dll',
    'kbdsf.dll',
    'kbdsg.dll',
    'kbdsl.dll',
    'kbdsl1.dll',
    'kbdsmsfi.dll',
    'kbdsmsno.dll',
    'kbdsn1.dll',
    'kbdsorex.dll',
    'kbdsors1.dll',
    'kbdsorst.dll',
    'kbdsp.dll',
    'kbdsw.dll',
    'kbdsw09.dll',
    'kbdsyr1.dll',
    'kbdsyr2.dll',
    'kbdtajik.dll',
    'kbdtat.dll',
    'kbdth0.dll',
    'kbdth1.dll',
    'kbdth2.dll',
    'kbdth3.dll',
    'kbdtiprc.dll',
    'kbdtuf.dll',
    'kbdtuq.dll',
    'kbdturme.dll',
    'kbdughr.dll',
    'kbdughr1.dll',
    'kbduk.dll',
    'kbdukx.dll',
    'kbdur.dll',
    'kbdur1.dll',
    'kbdurdu.dll',
    'kbdus.dll',
    'kbdusa.dll',
    'kbdusl.dll',
    'kbdusr.dll',
    'kbdusx.dll',
    'kbduzb.dll',
    'kbdvntc.dll',
    'kbdwol.dll',
    'kbdyak.dll',
    'kbdyba.dll',
    'kbdycc.dll',
    'kbdycl.dll',
    'kerberos.dll',
    'kernel32.dll',
    'kernelbase.dll',
    'keyiso.dll',
    'keymgr.dll',
    'korwbrkr.dll',
    'ksuser.dll',
    'ktmw32.dll',
    'l2gpstore.dll',
    'l2nacp.dll',
    'l2sechc.dll',
    'laprxy.dll',
    'licmgr10.dll',
    'linkinfo.dll',
    'loadperf.dll',
    'localsec.dll',
    'locationapi.dll',
    'loghours.dll',
    'logoncli.dll',
    'lpk.dll',
    'lsmproxy.dll',
    'luainstall.dll',
    'lz32.dll',
    'magnification.dll',
    'mapi32.dll',
    'mapistub.dll',
    'mcewmdrmndbootstrap.dll',
    'mciavi32.dll',
    'mcicda.dll',
    'mciqtz32.dll',
    'mciseq.dll',
    'mciwave.dll',
    'mctres.dll',
    'mdminst.dll',
    'mediametadatahandler.dll',
    'mf.dll',
    'mf3216.dll',
    'mfaacenc.dll',
    'mfc40.dll',
    'mfc40u.dll',
    'mfc42.dll',
    'mfc42u.dll',
    'mfcsubs.dll',
    'mfds.dll',
    'mfdvdec.dll',
    'mferror.dll',
    'mfh264enc.dll',
    'mfmjpegdec.dll',
    'mfplat.dll',
    'mfplay.dll',
    'mfps.dll',
    'mfreadwrite.dll',
    'mfvdsp.dll',
    'mfwmaaec.dll',
    'mgmtapi.dll',
    'midimap.dll',
    'migisol.dll',
    'miguiresource.dll',
    'mimefilt.dll',
    'mlang.dll',
    'mmcbase.dll',
    'mmci.dll',
    'mmcico.dll',
    'mmcndmgr.dll',
    'mmcshext.dll',
    'mmdevapi.dll',
    'mmres.dll',
    'modemui.dll',
    'moricons.dll',
    'mp3dmod.dll',
    'mp43decd.dll',
    'mp4sdecd.dll',
    'mpg4decd.dll',
    'mpr.dll',
    'mprapi.dll',
    'mprddm.dll',
    'mprdim.dll',
    'mprmsg.dll',
    'msaatext.dll',
    'msac3enc.dll',
    'msacm32.dll',
    'msafd.dll',
    'msasn1.dll',
    'msaudite.dll',
    'mscandui.dll',
    'mscat32.dll',
    'msclmd.dll',
    'mscms.dll',
    'mscoree.dll',
    'mscorier.dll',
    'mscories.dll',
    'mscpx32r.dll',
    'mscpxl32.dll',
    'msctf.dll',
    'msctfmonitor.dll',
    'msctfp.dll',
    'msctfui.dll',
    'msdadiag.dll',
    'msdart.dll',
    'msdelta.dll',
    'msdmo.dll',
    'msdrm.dll',
    'msdtcprx.dll',
    'msdtcuiu.dll',
    'msdtcvsp1res.dll',
    'msexch40.dll',
    'msexcl40.dll',
    'msfeeds.dll',
    'msfeedsbs.dll',
    'msftedit.dll',
    'mshtml.dll',
    'mshtmldac.dll',
    'mshtmled.dll',
    'mshtmler.dll',
    'mshtmlmedia.dll',
    'msi.dll',
    'msidcrl30.dll',
    'msident.dll',
    'msidle.dll',
    'msidntld.dll',
    'msieftp.dll',
    'msihnd.dll',
    'msiltcfg.dll',
    'msimg32.dll',
    'msimsg.dll',
    'msimtf.dll',
    'msisip.dll',
    'msjet40.dll',
    'msjetoledb40.dll',
    'msjint40.dll',
    'msjter40.dll',
    'msjtes40.dll',
    'msls31.dll',
    'msltus40.dll',
    'msmpeg2adec.dll',
    'msmpeg2enc.dll',
    'msmpeg2vdec.dll',
    'msnetobj.dll',
    'msobjs.dll',
    'msoeacct.dll',
    'msoert2.dll',
    'msorc32r.dll',
    'msorcl32.dll',
    'mspatcha.dll',
    'mspbde40.dll',
    'msports.dll',
    'msrating.dll',
    'msrd2x40.dll',
    'msrd3x40.dll',
    'msrdc.dll',
    'msrdpwebaccess.dll',
    'msrepl40.dll',
    'msrle32.dll',
    'msscntrs.dll',
    'msscp.dll',
    'mssha.dll',
    'msshavmsg.dll',
    'msshooks.dll',
    'mssign32.dll',
    'mssip32.dll',
    'mssitlb.dll',
    'mssph.dll',
    'mssphtb.dll',
    'mssprxy.dll',
    'mssrch.dll',
    'mssvp.dll',
    'msswch.dll',
    'mstask.dll',
    'mstext40.dll',
    'mstscax.dll',
    'msutb.dll',
    'msv1_0.dll',
    'msvbvm60.dll',
    'msvcirt.dll',
    'msvcp110_clr0400.dll',
    'msvcp120_clr0400.dll',
    'msvcp60.dll',
    'msvcr100_clr0400.dll',
    'msvcr110_clr0400.dll',
    'msvcr120_clr0400.dll',
    'msvcrt.dll',
    'msvcrt20.dll',
    'msvcrt40.dll',
    'msvfw32.dll',
    'msvidc32.dll',
    'msvidctl.dll',
    'mswdat10.dll',
    'mswmdm.dll',
    'mswsock.dll',
    'mswstr10.dll',
    'msxbde40.dll',
    'msxml3.dll',
    'msxml3r.dll',
    'msxml6.dll',
    'msxml6r.dll',
    'msyuv.dll',
    'mtxclu.dll',
    'mtxdm.dll',
    'mtxex.dll',
    'mtxlegih.dll',
    'mtxoci.dll',
    'muifontsetup.dll',
    'mycomput.dll',
    'mydocs.dll',
    'napcrypt.dll',
    'napdsnap.dll',
    'naphlpr.dll',
    'napinsp.dll',
    'napipsec.dll',
    'napmontr.dll',
    'nativehooks.dll',
    'naturallanguage6.dll',
    'ncdprop.dll',
    'nci.dll',
    'ncobjapi.dll',
    'ncrypt.dll',
    'ncryptui.dll',
    'ncsi.dll',
    'nddeapi.dll',
    'ndfapi.dll',
    'ndfetw.dll',
    'ndfhcdiscovery.dll',
    'ndiscapcfg.dll',
    'ndishc.dll',
    'ndproxystub.dll',
    'negoexts.dll',
    'netapi32.dll',
    'netbios.dll',
    'netcenter.dll',
    'netcfgx.dll',
    'netcorehc.dll',
    'netdiagfx.dll',
    'netevent.dll',
    'netfxperf.dll',
    'neth.dll',
    'netid.dll',
    'netiohlp.dll',
    'netjoin.dll',
    'netlogon.dll',
    'netmsg.dll',
    'netplwiz.dll',
    'netprof.dll',
    'netprofm.dll',
    'netshell.dll',
    'netutils.dll',
    'networkexplorer.dll',
    'networkitemfactory.dll',
    'networkmap.dll',
    'newdev.dll',
    'nlaapi.dll',
    'nlhtml.dll',
    'nlmgp.dll',
    'nlmsprep.dll',
    'nlsbres.dll',
    'nlsdata0000.dll',
    'nlsdata0001.dll',
    'nlsdata0002.dll',
    'nlsdata0003.dll',
    'nlsdata0007.dll',
    'nlsdata0009.dll',
    'nlsdata000a.dll',
    'nlsdata000c.dll',
    'nlsdata000d.dll',
    'nlsdata000f.dll',
    'nlsdata0010.dll',
    'nlsdata0011.dll',
    'nlsdata0013.dll',
    'nlsdata0018.dll',
    'nlsdata0019.dll',
    'nlsdata001a.dll',
    'nlsdata001b.dll',
    'nlsdata001d.dll',
    'nlsdata0020.dll',
    'nlsdata0021.dll',
    'nlsdata0022.dll',
    'nlsdata0024.dll',
    'nlsdata0026.dll',
    'nlsdata0027.dll',
    'nlsdata002a.dll',
    'nlsdata0039.dll',
    'nlsdata003e.dll',
    'nlsdata0045.dll',
    'nlsdata0046.dll',
    'nlsdata0047.dll',
    'nlsdata0049.dll',
    'nlsdata004a.dll',
    'nlsdata004b.dll',
    'nlsdata004c.dll',
    'nlsdata004e.dll',
    'nlsdata0414.dll',
    'nlsdata0416.dll',
    'nlsdata0816.dll',
    'nlsdata081a.dll',
    'nlsdata0c1a.dll',
    'nlsdl.dll',
    'nlslexicons0001.dll',
    'nlslexicons0002.dll',
    'nlslexicons0003.dll',
    'nlslexicons0007.dll',
    'nlslexicons0009.dll',
    'nlslexicons000a.dll',
    'nlslexicons000c.dll',
    'nlslexicons000d.dll',
    'nlslexicons000f.dll',
    'nlslexicons0010.dll',
    'nlslexicons0011.dll',
    'nlslexicons0013.dll',
    'nlslexicons0018.dll',
    'nlslexicons0019.dll',
    'nlslexicons001a.dll',
    'nlslexicons001b.dll',
    'nlslexicons001d.dll',
    'nlslexicons0020.dll',
    'nlslexicons0021.dll',
    'nlslexicons0022.dll',
    'nlslexicons0024.dll',
    'nlslexicons0026.dll',
    'nlslexicons0027.dll',
    'nlslexicons002a.dll',
    'nlslexicons0039.dll',
    'nlslexicons003e.dll',
    'nlslexicons0045.dll',
    'nlslexicons0046.dll',
    'nlslexicons0047.dll',
    'nlslexicons0049.dll',
    'nlslexicons004a.dll',
    'nlslexicons004b.dll',
    'nlslexicons004c.dll',
    'nlslexicons004e.dll',
    'nlslexicons0414.dll',
    'nlslexicons0416.dll',
    'nlslexicons0816.dll',
    'nlslexicons081a.dll',
    'nlslexicons0c1a.dll',
    'nlsmodels0011.dll',
    'normaliz.dll',
    'npmproxy.dll',
    'nshhttp.dll',
    'nshipsec.dll',
    'nshwfp.dll',
    'nsi.dll',
    'ntdll.dll',
    'ntdsapi.dll',
    'ntlanman.dll',
    'ntlanui2.dll',
    'ntmarta.dll',
    'ntprint.dll',
    'ntshrui.dll',
    'ntvdm64.dll',
    'objsel.dll',
    'occache.dll',
    'ocsetapi.dll',
    'odbc32.dll',
    'odbc32gt.dll',
    'odbcbcp.dll',
    'odbcconf.dll',
    'odbccp32.dll',
    'odbccr32.dll',
    'odbccu32.dll',
    'odbcint.dll',
    'odbcji32.dll',
    'odbcjt32.dll',
    'odbctrac.dll',
    'oddbse32.dll',
    'odexl32.dll',
    'odfox32.dll',
    'odpdx32.dll',
    'odtext32.dll',
    'offfilt.dll',
    'ogldrv.dll',
    'ole2.dll',
    'ole2disp.dll',
    'ole2nls.dll',
    'ole32.dll',
    'oleacc.dll',
    'oleacchooks.dll',
    'oleaccrc.dll',
    'oleaut32.dll',
    'olecli32.dll',
    'oledlg.dll',
    'oleprn.dll',
    'olepro32.dll',
    'oleres.dll',
    'olesvr32.dll',
    'olethk32.dll',
    'onex.dll',
    'onexui.dll',
    'onlineidcpl.dll',
    'oobefldr.dll',
    'opcservices.dll',
    'opengl32.dll',
    'osbaseln.dll',
    'osuninst.dll',
    'p2p.dll',
    'p2pcollab.dll',
    'p2pgraph.dll',
    'p2pnetsh.dll',
    'packager.dll',
    'panmap.dll',
    'pautoenr.dll',
    'pcaui.dll',
    'pcwum.dll',
    'pdh.dll',
    'pdhui.dll',
    'peerdist.dll',
    'peerdistsh.dll',
    'perfcentercpl.dll',
    'perfctrs.dll',
    'perfdisk.dll',
    'perfnet.dll',
    'perfos.dll',
    'perfproc.dll',
    'perfts.dll',
    'photometadatahandler.dll',
    'photowiz.dll',
    'pid.dll',
    'pidgenx.dll',
    'pifmgr.dll',
    'pku2u.dll',
    'pla.dll',
    'playsndsrv.dll',
    'pmcsnap.dll',
    'pngfilt.dll',
    'pnidui.dll',
    'pnpsetup.dll',
    'pnrpnsp.dll',
    'polstore.dll',
    'portabledeviceapi.dll',
    'portabledeviceclassextension.dll',
    'portabledeviceconnectapi.dll',
    'portabledevicestatus.dll',
    'portabledevicesyncprovider.dll',
    'portabledevicetypes.dll',
    'portabledevicewiacompat.dll',
    'portabledevicewmdrm.dll',
    'pots.dll',
    'powercpl.dll',
    'powrprof.dll',
    'ppcsnap.dll',
    'presentationcffrasterizernative_v0300.dll',
    'presentationhostproxy.dll',
    'presentationnative_v0300.dll',
    'prflbmsg.dll',
    'printui.dll',
    'prncache.dll',
    'prnfldr.dll',
    'prnntfy.dll',
    'prntvpt.dll',
    'profapi.dll',
    'propsys.dll',
    'provsvc.dll',
    'provthrd.dll',
    'psapi.dll',
    'psbase.dll',
    'pshed.dll',
    'psisdecd.dll',
    'pstorec.dll',
    'pstorsvc.dll',
    'puiapi.dll',
    'puiobj.dll',
    'pwrshplugin.dll',
    'qagent.dll',
    'qasf.dll',
    'qcap.dll',
    'qcliprov.dll',
    'qdv.dll',
    'qdvd.dll',
    'qedit.dll',
    'qedwipes.dll',
    'qmgrprxy.dll',
    'qshvhost.dll',
    'qsvrmgmt.dll',
    'quartz.dll',
    'query.dll',
    'qutil.dll',
    'qwave.dll',
    'racengn.dll',
    'racpldlg.dll',
    'radardt.dll',
    'radarrs.dll',
    'rasadhlp.dll',
    'rasapi32.dll',
    'rascfg.dll',
    'raschap.dll',
    'rasctrs.dll',
    'rasdiag.dll',
    'rasdlg.dll',
    'rasgcw.dll',
    'rasman.dll',
    'rasmm.dll',
    'rasmontr.dll',
    'rasmxs.dll',
    'rasplap.dll',
    'rasppp.dll',
    'rasser.dll',
    'rastapi.dll',
    'rastls.dll',
    'rdpcore.dll',
    'rdpd3d.dll',
    'rdpencom.dll',
    'rdpendp.dll',
    'rdprefdrvapi.dll',
    'rdvgumd32.dll',
    'reagent.dll',
    'regapi.dll',
    'regctrl.dll',
    'remotepg.dll',
    'resampledmo.dll',
    'resutils.dll',
    'rgb9rast.dll',
    'riched20.dll',
    'riched32.dll',
    'rnr20.dll',
    'rpcdiag.dll',
    'rpchttp.dll',
    'rpcndfp.dll',
    'rpcns4.dll',
    'rpcnsh.dll',
    'rpcrt4.dll',
    'rpcrtremote.dll',
    'rsaenh.dll',
    'rshx32.dll',
    'rstrtmgr.dll',
    'rtffilt.dll',
    'rtm.dll',
    'rtutils.dll',
    'samcli.dll',
    'samlib.dll',
    'sampleres.dll',
    'sas.dll',
    'sbe.dll',
    'sbeio.dll',
    'sberes.dll',
    'scansetting.dll',
    'scarddlg.dll',
    'scecli.dll',
    'scesrv.dll',
    'schannel.dll',
    'schedcli.dll',
    'scksp.dll',
    'scripto.dll',
    'scrobj.dll',
    'scrptadm.dll',
    'scrrun.dll',
    'sdiageng.dll',
    'sdiagprv.dll',
    'sdohlp.dll',
    'searchfolder.dll',
    'sechost.dll',
    'secproc.dll',
    'secproc_isv.dll',
    'secproc_ssp.dll',
    'secproc_ssp_isv.dll',
    'secur32.dll',
    'security.dll',
    'sendmail.dll',
    'sens.dll',
    'sensapi.dll',
    'sensorsapi.dll',
    'sensorscpl.dll',
    'serialui.dll',
    'serwvdrv.dll',
    'sessenv.dll',
    'setupapi.dll',
    'setupcln.dll',
    'sfc.dll',
    'sfc_os.dll',
    'shacct.dll',
    'shdocvw.dll',
    'shell32.dll',
    'shellstyle.dll',
    'shfolder.dll',
    'shgina.dll',
    'shimeng.dll',
    'shimgvw.dll',
    'shlwapi.dll',
    'shpafact.dll',
    'shsetup.dll',
    'shsvcs.dll',
    'shunimpl.dll',
    'shwebsvc.dll',
    'signdrv.dll',
    'sisbkup.dll',
    'slc.dll',
    'slcext.dll',
    'slwga.dll',
    'smartcardcredentialprovider.dll',
    'smbhelperclass.dll',
    'sndvolsso.dll',
    'snmpapi.dll',
    'softkbd.dll',
    'softpub.dll',
    'sortserver2003compat.dll',
    'sortwindows6compat.dll',
    'spbcd.dll',
    'spfileq.dll',
    'spinf.dll',
    'spnet.dll',
    'spopk.dll',
    'spp.dll',
    'sppc.dll',
    'sppcc.dll',
    'sppcext.dll',
    'sppcomapi.dll',
    'sppcommdlg.dll',
    'sppinst.dll',
    'sppwmi.dll',
    'spwinsat.dll',
    'spwizeng.dll',
    'spwizimg.dll',
    'spwizres.dll',
    'spwmp.dll',
    'sqlceoledb30.dll',
    'sqlceqp30.dll',
    'sqlcese30.dll',
    'sqlsrv32.dll',
    'sqlunirl.dll',
    'sqlwid.dll',
    'sqlwoa.dll',
    'sqmapi.dll',
    'srchadmin.dll',
    'srclient.dll',
    'srhelper.dll',
    'srpuxnativesnapin.dll',
    'srvcli.dll',
    'sscore.dll',
    'ssdpapi.dll',
    'sspicli.dll',
    'ssshim.dll',
    'stclient.dll',
    'sti.dll',
    'stobject.dll',
    'storage.dll',
    'storagecontexthandler.dll',
    'storprop.dll',
    'structuredquery.dll',
    'sud.dll',
    'sxproxy.dll',
    'sxs.dll',
    'sxshared.dll',
    'sxsstore.dll',
    'synccenter.dll',
    'synceng.dll',
    'synchostps.dll',
    'syncinfrastructure.dll',
    'syncinfrastructureps.dll',
    'syncreg.dll',
    'syncui.dll',
    'syssetup.dll',
    'systemcpl.dll',
    't2embed.dll',
    'tapi3.dll',
    'tapi32.dll',
    'tapimigplugin.dll',
    'tapiperf.dll',
    'tapisrv.dll',
    'tapisysprep.dll',
    'tapiui.dll',
    'taskcomp.dll',
    'taskschd.dll',
    'taskschdps.dll',
    'tbs.dll',
    'tcpipcfg.dll',
    'tcpmonui.dll',
    'tdh.dll',
    'termmgr.dll',
    'thawbrkr.dll',
    'themecpl.dll',
    'themeui.dll',
    'thumbcache.dll',
    'timedatemuicallback.dll',
    'tlscsp.dll',
    'tpmcompc.dll',
    'tquery.dll',
    'traffic.dll',
    'trapi.dll',
    'tsbyuv.dll',
    'tschannel.dll',
    'tsgqec.dll',
    'tsmf.dll',
    'tspkg.dll',
    'tsworkspace.dll',
    'tvratings.dll',
    'twext.dll',
    'txflog.dll',
    'txfw32.dll',
    'typelib.dll',
    'tzres.dll',
    'ubpm.dll',
    'ucmhc.dll',
    'ucrtbase.dll',
    'udhisapi.dll',
    'uexfat.dll',
    'ufat.dll',
    'uianimation.dll',
    'uiautomationcore.dll',
    'uicom.dll',
    'uiribbon.dll',
    'uiribbonres.dll',
    'ulib.dll',
    'umdmxfrm.dll',
    'unimdmat.dll',
    'uniplat.dll',
    'untfs.dll',
    'upnp.dll',
    'upnphost.dll',
    'ureg.dll',
    'url.dll',
    'urlmon.dll',
    'usbceip.dll',
    'usbperf.dll',
    'usbui.dll',
    'user32.dll',
    'useraccountcontrolsettings.dll',
    'usercpl.dll',
    'userenv.dll',
    'usp10.dll',
    'utildll.dll',
    'uudf.dll',
    'uxinit.dll',
    'uxlib.dll',
    'uxlibres.dll',
    'uxtheme.dll',
    'van.dll',
    'vault.dll',
    'vaultcli.dll',
    'vbajet32.dll',
    'vbscript.dll',
    'vdmdbg.dll',
    'vdsbas.dll',
    'vdsdyn.dll',
    'vdsvd.dll',
    'vds_ps.dll',
    'verifier.dll',
    'version.dll',
    'vfpodbc.dll',
    'vfwwdm32.dll',
    'vidreszr.dll',
    'virtdisk.dll',
    'vpnikeapi.dll',
    'vssapi.dll',
    'vsstrace.dll',
    'vss_ps.dll',
    'w32topl.dll',
    'wabsyncprovider.dll',
    'wavemsp.dll',
    'wbemcomn.dll',
    'wcnapi.dll',
    'wcncsvc.dll',
    'wcneapauthproxy.dll',
    'wcneappeerproxy.dll',
    'wcnwiz.dll',
    'wcspluginservice.dll',
    'wdc.dll',
    'wdi.dll',
    'wdigest.dll',
    'wdscore.dll',
    'webcheck.dll',
    'webclnt.dll',
    'webio.dll',
    'webservices.dll',
    'wecapi.dll',
    'wer.dll',
    'werdiagcontroller.dll',
    'werui.dll',
    'wevtapi.dll',
    'wevtfwd.dll',
    'wfapigp.dll',
    'wfhc.dll',
    'whealogr.dll',
    'whhelper.dll',
    'wiaaut.dll',
    'wiadefui.dll',
    'wiadss.dll',
    'wiaextensionhost64.dll',
    'wiascanprofiles.dll',
    'wiashext.dll',
    'wiatrace.dll',
    'wiavideo.dll',
    'wimgapi.dll',
    'win32spl.dll',
    'winbio.dll',
    'winbrand.dll',
    'wincredprovider.dll',
    'windowscodecs.dll',
    'windowscodecsext.dll',
    'winfax.dll',
    'winhttp.dll',
    'wininet.dll',
    'winipsec.dll',
    'winmm.dll',
    'winnsi.dll',
    'winrnr.dll',
    'winrscmd.dll',
    'winrsmgr.dll',
    'winrssrv.dll',
    'winsatapi.dll',
    'winscard.dll',
    'winshfhc.dll',
    'winsockhc.dll',
    'winsrpc.dll',
    'winsta.dll',
    'winsync.dll',
    'winsyncmetastore.dll',
    'winsyncproviders.dll',
    'wintrust.dll',
    'winusb.dll',
    'wkscli.dll',
    'wksprtps.dll',
    'wlanapi.dll',
    'wlancfg.dll',
    'wlanconn.dll',
    'wlandlg.dll',
    'wlangpui.dll',
    'wlanhlp.dll',
    'wlaninst.dll',
    'wlanmm.dll',
    'wlanmsm.dll',
    'wlanpref.dll',
    'wlansec.dll',
    'wlanui.dll',
    'wlanutil.dll',
    'wldap32.dll',
    'wlgpclnt.dll',
    'wls0wndh.dll',
    'wmadmod.dll',
    'wmadmoe.dll',
    'wmasf.dll',
    'wmcodecdspps.dll',
    'wmdmlog.dll',
    'wmdmps.dll',
    'wmdrmdev.dll',
    'wmdrmnet.dll',
    'wmdrmsdk.dll',
    'wmerror.dll',
    'wmi.dll',
    'wmidx.dll',
    'wmiprop.dll',
    'wmnetmgr.dll',
    'wmp.dll',
    'wmpcm.dll',
    'wmpdui.dll',
    'wmpdxm.dll',
    'wmpeffects.dll',
    'wmpencen.dll',
    'wmphoto.dll',
    'wmploc.dll',
    'wmpmde.dll',
    'wmpps.dll',
    'wmpshell.dll',
    'wmpsrcwp.dll',
    'wmsgapi.dll',
    'wmspdmod.dll',
    'wmspdmoe.dll',
    'wmvcore.dll',
    'wmvdecod.dll',
    'wmvdspa.dll',
    'wmvencod.dll',
    'wmvsdecd.dll',
    'wmvsencd.dll',
    'wmvxencd.dll',
    'wow32.dll',
    'wpc.dll',
    'wpcao.dll',
    'wpcsvc.dll',
    'wpdshext.dll',
    'wpdshserviceobj.dll',
    'wpdsp.dll',
    'wpdwcn.dll',
    'ws2help.dll',
    'ws2_32.dll',
    'wscapi.dll',
    'wscinterop.dll',
    'wscisvif.dll',
    'wscmisetup.dll',
    'wscproxystub.dll',
    'wsdapi.dll',
    'wsdchngr.dll',
    'wsecedit.dll',
    'wshbth.dll',
    'wshcon.dll',
    'wshelper.dll',
    'wshext.dll',
    'wship6.dll',
    'wshirda.dll',
    'wshqos.dll',
    'wshrm.dll',
    'wshtcpip.dll',
    'wsmanmigrationplugin.dll',
    'wsmauto.dll',
    'wsmplpxy.dll',
    'wsmres.dll',
    'wsmsvc.dll',
    'wsmwmipl.dll',
    'wsnmp32.dll',
    'wsock32.dll',
    'wtsapi32.dll',
    'wuapi.dll',
    'wudriver.dll',
    'wups.dll',
    'wuwebv.dll',
    'wvc.dll',
    'wwanapi.dll',
    'wwapi.dll',
    'wzcdlg.dll',
    'xinput9_1_0.dll',
    'xmlfilter.dll',
    'xmllite.dll',
    'xmlprovi.dll',
    'xolehlp.dll',
    'xpsfilt.dll',
    'xpsgdiconverter.dll',
    'xpsprint.dll',
    'xpsrasterservice.dll',
    'xpsservices.dll',
    'xpsshhdr.dll',
    'xpssvcs.dll',
    'xwizards.dll',
    'xwreg.dll',
    'xwtpdui.dll',
    'xwtpw32.dll',
    'zipfldr.dll',
    'msacm32.drv',
    'wdmaud.drv',
    'winspool.drv',
}

# ignore_names_64 is a set containing the lowercase names of all DLLs that can
# be assumed to be present on 64-bit Windows 7 or later. These are all the files
# with extension .dll or .drv found in C:\Windows\System32 on a vanilla Windows
# 7 Ultimate SP1 64-bit installation.
ignore_names_64 = {
    'aaclient.dll',
    'accessibilitycpl.dll',
    'acctres.dll',
    'acledit.dll',
    'aclui.dll',
    'acppage.dll',
    'actioncenter.dll',
    'actioncentercpl.dll',
    'activeds.dll',
    'actxprxy.dll',
    'admtmpl.dll',
    'adprovider.dll',
    'adsldp.dll',
    'adsldpc.dll',
    'adsmsext.dll',
    'adsnt.dll',
    'adtschema.dll',
    'advapi32.dll',
    'advpack.dll',
    'aecache.dll',
    'aeevts.dll',
    'alttab.dll',
    'amstream.dll',
    'amxread.dll',
    'apds.dll',
    'api-ms-win-core-file-l1-2-0.dll',
    'api-ms-win-core-file-l2-1-0.dll',
    'api-ms-win-core-localization-l1-2-0.dll',
    'api-ms-win-core-processthreads-l1-1-1.dll',
    'api-ms-win-core-synch-l1-2-0.dll',
    'api-ms-win-core-timezone-l1-1-0.dll',
    'api-ms-win-core-xstate-l2-1-0.dll',
    'api-ms-win-crt-conio-l1-1-0.dll',
    'api-ms-win-crt-convert-l1-1-0.dll',
    'api-ms-win-crt-environment-l1-1-0.dll',
    'api-ms-win-crt-filesystem-l1-1-0.dll',
    'api-ms-win-crt-heap-l1-1-0.dll',
    'api-ms-win-crt-locale-l1-1-0.dll',
    'api-ms-win-crt-math-l1-1-0.dll',
    'api-ms-win-crt-multibyte-l1-1-0.dll',
    'api-ms-win-crt-private-l1-1-0.dll',
    'api-ms-win-crt-process-l1-1-0.dll',
    'api-ms-win-crt-runtime-l1-1-0.dll',
    'api-ms-win-crt-stdio-l1-1-0.dll',
    'api-ms-win-crt-string-l1-1-0.dll',
    'api-ms-win-crt-time-l1-1-0.dll',
    'api-ms-win-crt-utility-l1-1-0.dll',
    'apilogen.dll',
    'apircl.dll',
    'apisetschema.dll',
    'apphelp.dll',
    'apphlpdm.dll',
    'appidapi.dll',
    'appidpolicyengineapi.dll',
    'appmgmts.dll',
    'appmgr.dll',
    'apss.dll',
    'asferror.dll',
    'aspnet_counters.dll',
    'asycfilt.dll',
    'atl.dll',
    'atmfd.dll',
    'atmlib.dll',
    'audiodev.dll',
    'audioeng.dll',
    'audiokse.dll',
    'audioses.dll',
    'auditnativesnapin.dll',
    'auditpolicygpinterop.dll',
    'auditpolmsg.dll',
    'authfwcfg.dll',
    'authfwgp.dll',
    'authfwsnapin.dll',
    'authfwwizfwk.dll',
    'authui.dll',
    'authz.dll',
    'autoplay.dll',
    'auxiliarydisplayapi.dll',
    'auxiliarydisplaycpl.dll',
    'avicap32.dll',
    'avifil32.dll',
    'avrt.dll',
    'azroles.dll',
    'azroleui.dll',
    'azsqlext.dll',
    'basecsp.dll',
    'batmeter.dll',
    'bcrypt.dll',
    'bcryptprimitives.dll',
    'bidispl.dll',
    'biocredprov.dll',
    'bitsperf.dll',
    'bitsprx2.dll',
    'bitsprx3.dll',
    'bitsprx4.dll',
    'bitsprx5.dll',
    'bitsprx6.dll',
    'blackbox.dll',
    'bootvid.dll',
    'browcli.dll',
    'browseui.dll',
    'btpanui.dll',
    'bwcontexthandler.dll',
    'bwunpairelevated.dll',
    'cabinet.dll',
    'cabview.dll',
    'capiprovider.dll',
    'capisp.dll',
    'catsrv.dll',
    'catsrvps.dll',
    'catsrvut.dll',
    'cca.dll',
    'cdosys.dll',
    'certcli.dll',
    'certcredprovider.dll',
    'certenc.dll',
    'certenroll.dll',
    'certenrollui.dll',
    'certmgr.dll',
    'certpoleng.dll',
    'cewmdm.dll',
    'cfgbkend.dll',
    'cfgmgr32.dll',
    'chsbrkr.dll',
    'chtbrkr.dll',
    'chxreadingstringime.dll',
    'cic.dll',
    'clb.dll',
    'clbcatq.dll',
    'clfsw32.dll',
    'cliconfg.dll',
    'clusapi.dll',
    'cmcfg32.dll',
    'cmdial32.dll',
    'cmicryptinstall.dll',
    'cmifw.dll',
    'cmipnpinstall.dll',
    'cmlua.dll',
    'cmpbk32.dll',
    'cmstplua.dll',
    'cmutil.dll',
    'cngaudit.dll',
    'cngprovider.dll',
    'cnvfat.dll',
    'colbact.dll',
    'colorcnv.dll',
    'colorui.dll',
    'comcat.dll',
    'comctl32.dll',
    'comdlg32.dll',
    'compobj.dll',
    'compstui.dll',
    'comrepl.dll',
    'comres.dll',
    'comsnap.dll',
    'comsvcs.dll',
    'comuid.dll',
    'connect.dll',
    'console.dll',
    'cpfilters.dll',
    'credssp.dll',
    'credui.dll',
    'crtdll.dll',
    'crypt32.dll',
    'cryptbase.dll',
    'cryptdlg.dll',
    'cryptdll.dll',
    'cryptext.dll',
    'cryptnet.dll',
    'cryptsp.dll',
    'cryptsvc.dll',
    'cryptui.dll',
    'cryptxml.dll',
    'cscapi.dll',
    'cscdll.dll',
    'cscobj.dll',
    'ctl3d32.dll',
    'c_g18030.dll',
    'c_is2022.dll',
    'c_iscii.dll',
    'd2d1.dll',
    'd3d10.dll',
    'd3d10core.dll',
    'd3d10level9.dll',
    'd3d10warp.dll',
    'd3d10_1.dll',
    'd3d10_1core.dll',
    'd3d11.dll',
    'd3d8.dll',
    'd3d8thk.dll',
    'd3d9.dll',
    'd3dcompiler_47.dll',
    'd3dim.dll',
    'd3dim700.dll',
    'd3dramp.dll',
    'd3dxof.dll',
    'dataclen.dll',
    'davclnt.dll',
    'davhlpr.dll',
    'dbgeng.dll',
    'dbghelp.dll',
    'dbnetlib.dll',
    'dbnmpntw.dll',
    'dciman32.dll',
    'ddaclsys.dll',
    'ddoiproxy.dll',
    'ddores.dll',
    'ddraw.dll',
    'ddrawex.dll',
    'defaultlocationcpl.dll',
    'deskadp.dll',
    'deskmon.dll',
    'deskperf.dll',
    'devenum.dll',
    'devicecenter.dll',
    'devicedisplaystatusmanager.dll',
    'devicemetadataparsers.dll',
    'devicepairing.dll',
    'devicepairingfolder.dll',
    'devicepairinghandler.dll',
    'devicepairingproxy.dll',
    'deviceuxres.dll',
    'devmgr.dll',
    'devobj.dll',
    'devrtl.dll',
    'dfscli.dll',
    'dfshim.dll',
    'dfsshlex.dll',
    'dhcpcmonitor.dll',
    'dhcpcore.dll',
    'dhcpcore6.dll',
    'dhcpcsvc.dll',
    'dhcpcsvc6.dll',
    'dhcpqec.dll',
    'dhcpsapi.dll',
    'difxapi.dll',
    'dimsjob.dll',
    'dimsroam.dll',
    'dinput.dll',
    'dinput8.dll',
    'diskcopy.dll',
    'dispex.dll',
    'display.dll',
    'dmband.dll',
    'dmcompos.dll',
    'dmdlgs.dll',
    'dmdskmgr.dll',
    'dmdskres.dll',
    'dmdskres2.dll',
    'dmime.dll',
    'dmintf.dll',
    'dmloader.dll',
    'dmocx.dll',
    'dmrc.dll',
    'dmscript.dll',
    'dmstyle.dll',
    'dmsynth.dll',
    'dmusic.dll',
    'dmutil.dll',
    'dmvdsitf.dll',
    'dnsapi.dll',
    'dnscmmc.dll',
    'docprop.dll',
    'dot3api.dll',
    'dot3cfg.dll',
    'dot3dlg.dll',
    'dot3gpclnt.dll',
    'dot3gpui.dll',
    'dot3hc.dll',
    'dot3msm.dll',
    'dot3ui.dll',
    'dpapiprovider.dll',
    'dplayx.dll',
    'dpmodemx.dll',
    'dpnaddr.dll',
    'dpnathlp.dll',
    'dpnet.dll',
    'dpnhpast.dll',
    'dpnhupnp.dll',
    'dpnlobby.dll',
    'dpwsockx.dll',
    'dpx.dll',
    'drmmgrtn.dll',
    'drmv2clt.dll',
    'drprov.dll',
    'drt.dll',
    'drtprov.dll',
    'drttransport.dll',
    'drvstore.dll',
    'ds32gt.dll',
    'dsauth.dll',
    'dsdmo.dll',
    'dshowrdpfilter.dll',
    'dskquota.dll',
    'dskquoui.dll',
    'dsound.dll',
    'dsprop.dll',
    'dsquery.dll',
    'dsrole.dll',
    'dssec.dll',
    'dssenh.dll',
    'dsuiext.dll',
    'dswave.dll',
    'dtsh.dll',
    'dui70.dll',
    'duser.dll',
    'dwmapi.dll',
    'dwmcore.dll',
    'dwrite.dll',
    'dxdiagn.dll',
    'dxgi.dll',
    'dxmasf.dll',
    'dxptaskringtone.dll',
    'dxptasksync.dll',
    'dxtmsft.dll',
    'dxtrans.dll',
    'dxva2.dll',
    'eapp3hst.dll',
    'eappcfg.dll',
    'eappgnui.dll',
    'eapphost.dll',
    'eappprxy.dll',
    'eapqec.dll',
    'efsadu.dll',
    'efscore.dll',
    'efsutil.dll',
    'ehstorapi.dll',
    'ehstorpwdmgr.dll',
    'ehstorshell.dll',
    'els.dll',
    'elscore.dll',
    'elshyph.dll',
    'elslad.dll',
    'elstrans.dll',
    'encapi.dll',
    'encdec.dll',
    'eqossnap.dll',
    'es.dll',
    'esent.dll',
    'esentprf.dll',
    'eventcls.dll',
    'evr.dll',
    'explorerframe.dll',
    'expsrv.dll',
    'f3ahvoas.dll',
    'faultrep.dll',
    'fdbth.dll',
    'fdbthproxy.dll',
    'fde.dll',
    'fdeploy.dll',
    'fdpnp.dll',
    'fdproxy.dll',
    'fdssdp.dll',
    'fdwcn.dll',
    'fdwnet.dll',
    'fdwsd.dll',
    'feclient.dll',
    'filemgmt.dll',
    'findnetprinters.dll',
    'firewallapi.dll',
    'firewallcontrolpanel.dll',
    'fltlib.dll',
    'fmifs.dll',
    'fms.dll',
    'fontext.dll',
    'fontsub.dll',
    'fphc.dll',
    'framedyn.dll',
    'framedynos.dll',
    'fthsvc.dll',
    'fundisc.dll',
    'fwcfg.dll',
    'fwpuclnt.dll',
    'fwremotesvr.dll',
    'fxsapi.dll',
    'fxscom.dll',
    'fxscomex.dll',
    'fxsext32.dll',
    'fxsresm.dll',
    'fxsxp32.dll',
    'gameux.dll',
    'gameuxlegacygdfs.dll',
    'gcdef.dll',
    'gdi32.dll',
    'getuname.dll',
    'glmf32.dll',
    'glu32.dll',
    'gpapi.dll',
    'gpedit.dll',
    'gpprefcl.dll',
    'gpprnext.dll',
    'gpscript.dll',
    'gptext.dll',
    'hbaapi.dll',
    'hcproviders.dll',
    'helppaneproxy.dll',
    'hgcpl.dll',
    'hhsetup.dll',
    'hid.dll',
    'hidserv.dll',
    'hlink.dll',
    'hnetcfg.dll',
    'hnetmon.dll',
    'httpapi.dll',
    'htui.dll',
    'ias.dll',
    'iasacct.dll',
    'iasads.dll',
    'iasdatastore.dll',
    'iashlpr.dll',
    'iasmigplugin.dll',
    'iasnap.dll',
    'iaspolcy.dll',
    'iasrad.dll',
    'iasrecst.dll',
    'iassam.dll',
    'iassdo.dll',
    'iassvcs.dll',
    'icardie.dll',
    'icardres.dll',
    'iccvid.dll',
    'icm32.dll',
    'icmp.dll',
    'icmui.dll',
    'iconcodecservice.dll',
    'icsigd.dll',
    'idndl.dll',
    'idstore.dll',
    'ieadvpack.dll',
    'ieapfltr.dll',
    'iedkcs32.dll',
    'ieetwproxystub.dll',
    'ieframe.dll',
    'iepeers.dll',
    'iernonce.dll',
    'iertutil.dll',
    'iesetup.dll',
    'iesysprep.dll',
    'ieui.dll',
    'ifmon.dll',
    'ifsutil.dll',
    'ifsutilx.dll',
    'imagehlp.dll',
    'imageres.dll',
    'imagesp1.dll',
    'imapi.dll',
    'imapi2.dll',
    'imapi2fs.dll',
    'imgutil.dll',
    'imjp10k.dll',
    'imm32.dll',
    'inetcomm.dll',
    'inetmib1.dll',
    'inetres.dll',
    'infocardapi.dll',
    'inked.dll',
    'input.dll',
    'inseng.dll',
    'iologmsg.dll',
    'ipbusenumproxy.dll',
    'iphlpapi.dll',
    'iprop.dll',
    'iprtprio.dll',
    'iprtrmgr.dll',
    'ipsecsnp.dll',
    'ipsmsnap.dll',
    'ir32_32.dll',
    'ir41_qc.dll',
    'ir41_qcx.dll',
    'ir50_32.dll',
    'ir50_qc.dll',
    'ir50_qcx.dll',
    'irclass.dll',
    'iscsicpl.dll',
    'iscsidsc.dll',
    'iscsied.dll',
    'iscsium.dll',
    'iscsiwmi.dll',
    'itircl.dll',
    'itss.dll',
    'itvdata.dll',
    'iyuv_32.dll',
    'javascriptcollectionagent.dll',
    'jscript.dll',
    'jscript9.dll',
    'jscript9diag.dll',
    'jsintl.dll',
    'jsproxy.dll',
    'kbd101.dll',
    'kbd101a.dll',
    'kbd101b.dll',
    'kbd101c.dll',
    'kbd103.dll',
    'kbd106.dll',
    'kbd106n.dll',
    'kbda1.dll',
    'kbda2.dll',
    'kbda3.dll',
    'kbdal.dll',
    'kbdarme.dll',
    'kbdarmw.dll',
    'kbdax2.dll',
    'kbdaze.dll',
    'kbdazel.dll',
    'kbdbash.dll',
    'kbdbe.dll',
    'kbdbene.dll',
    'kbdbgph.dll',
    'kbdbgph1.dll',
    'kbdbhc.dll',
    'kbdblr.dll',
    'kbdbr.dll',
    'kbdbu.dll',
    'kbdbulg.dll',
    'kbdca.dll',
    'kbdcan.dll',
    'kbdcr.dll',
    'kbdcz.dll',
    'kbdcz1.dll',
    'kbdcz2.dll',
    'kbdda.dll',
    'kbddiv1.dll',
    'kbddiv2.dll',
    'kbddv.dll',
    'kbdes.dll',
    'kbdest.dll',
    'kbdfa.dll',
    'kbdfc.dll',
    'kbdfi.dll',
    'kbdfi1.dll',
    'kbdfo.dll',
    'kbdfr.dll',
    'kbdgae.dll',
    'kbdgeo.dll',
    'kbdgeoer.dll',
    'kbdgeoqw.dll',
    'kbdgkl.dll',
    'kbdgr.dll',
    'kbdgr1.dll',
    'kbdgrlnd.dll',
    'kbdhau.dll',
    'kbdhe.dll',
    'kbdhe220.dll',
    'kbdhe319.dll',
    'kbdheb.dll',
    'kbdhela2.dll',
    'kbdhela3.dll',
    'kbdhept.dll',
    'kbdhu.dll',
    'kbdhu1.dll',
    'kbdibm02.dll',
    'kbdibo.dll',
    'kbdic.dll',
    'kbdinasa.dll',
    'kbdinbe1.dll',
    'kbdinbe2.dll',
    'kbdinben.dll',
    'kbdindev.dll',
    'kbdinguj.dll',
    'kbdinhin.dll',
    'kbdinkan.dll',
    'kbdinmal.dll',
    'kbdinmar.dll',
    'kbdinori.dll',
    'kbdinpun.dll',
    'kbdintam.dll',
    'kbdintel.dll',
    'kbdinuk2.dll',
    'kbdir.dll',
    'kbdit.dll',
    'kbdit142.dll',
    'kbdiulat.dll',
    'kbdjpn.dll',
    'kbdkaz.dll',
    'kbdkhmr.dll',
    'kbdkor.dll',
    'kbdkyr.dll',
    'kbdla.dll',
    'kbdlao.dll',
    'kbdlk41a.dll',
    'kbdlt.dll',
    'kbdlt1.dll',
    'kbdlt2.dll',
    'kbdlv.dll',
    'kbdlv1.dll',
    'kbdmac.dll',
    'kbdmacst.dll',
    'kbdmaori.dll',
    'kbdmlt47.dll',
    'kbdmlt48.dll',
    'kbdmon.dll',
    'kbdmonmo.dll',
    'kbdne.dll',
    'kbdnec.dll',
    'kbdnec95.dll',
    'kbdnecat.dll',
    'kbdnecnt.dll',
    'kbdnepr.dll',
    'kbdno.dll',
    'kbdno1.dll',
    'kbdnso.dll',
    'kbdpash.dll',
    'kbdpl.dll',
    'kbdpl1.dll',
    'kbdpo.dll',
    'kbdro.dll',
    'kbdropr.dll',
    'kbdrost.dll',
    'kbdru.dll',
    'kbdru1.dll',
    'kbdsf.dll',
    'kbdsg.dll',
    'kbdsl.dll',
    'kbdsl1.dll',
    'kbdsmsfi.dll',
    'kbdsmsno.dll',
    'kbdsn1.dll',
    'kbdsorex.dll',
    'kbdsors1.dll',
    'kbdsorst.dll',
    'kbdsp.dll',
    'kbdsw.dll',
    'kbdsw09.dll',
    'kbdsyr1.dll',
    'kbdsyr2.dll',
    'kbdtajik.dll',
    'kbdtat.dll',
    'kbdth0.dll',
    'kbdth1.dll',
    'kbdth2.dll',
    'kbdth3.dll',
    'kbdtiprc.dll',
    'kbdtuf.dll',
    'kbdtuq.dll',
    'kbdturme.dll',
    'kbdughr.dll',
    'kbdughr1.dll',
    'kbduk.dll',
    'kbdukx.dll',
    'kbdur.dll',
    'kbdur1.dll',
    'kbdurdu.dll',
    'kbdus.dll',
    'kbdusa.dll',
    'kbdusl.dll',
    'kbdusr.dll',
    'kbdusx.dll',
    'kbduzb.dll',
    'kbdvntc.dll',
    'kbdwol.dll',
    'kbdyak.dll',
    'kbdyba.dll',
    'kbdycc.dll',
    'kbdycl.dll',
    'kerberos.dll',
    'kernel32.dll',
    'kernelbase.dll',
    'keyiso.dll',
    'keymgr.dll',
    'korwbrkr.dll',
    'ksuser.dll',
    'ktmw32.dll',
    'l2gpstore.dll',
    'l2nacp.dll',
    'l2sechc.dll',
    'laprxy.dll',
    'licmgr10.dll',
    'linkinfo.dll',
    'loadperf.dll',
    'localsec.dll',
    'locationapi.dll',
    'loghours.dll',
    'logoncli.dll',
    'lpk.dll',
    'lsmproxy.dll',
    'luainstall.dll',
    'lz32.dll',
    'magnification.dll',
    'mapi32.dll',
    'mapistub.dll',
    'mcewmdrmndbootstrap.dll',
    'mciavi32.dll',
    'mcicda.dll',
    'mciqtz32.dll',
    'mciseq.dll',
    'mciwave.dll',
    'mctres.dll',
    'mdminst.dll',
    'mediametadatahandler.dll',
    'mf.dll',
    'mf3216.dll',
    'mfaacenc.dll',
    'mfc40.dll',
    'mfc40u.dll',
    'mfc42.dll',
    'mfc42u.dll',
    'mfcsubs.dll',
    'mfds.dll',
    'mfdvdec.dll',
    'mferror.dll',
    'mfh264enc.dll',
    'mfmjpegdec.dll',
    'mfplat.dll',
    'mfplay.dll',
    'mfps.dll',
    'mfreadwrite.dll',
    'mfvdsp.dll',
    'mfwmaaec.dll',
    'mgmtapi.dll',
    'midimap.dll',
    'migisol.dll',
    'miguiresource.dll',
    'mimefilt.dll',
    'mlang.dll',
    'mmcbase.dll',
    'mmci.dll',
    'mmcico.dll',
    'mmcndmgr.dll',
    'mmcshext.dll',
    'mmdevapi.dll',
    'mmres.dll',
    'modemui.dll',
    'moricons.dll',
    'mp3dmod.dll',
    'mp43decd.dll',
    'mp4sdecd.dll',
    'mpg4decd.dll',
    'mpr.dll',
    'mprapi.dll',
    'mprddm.dll',
    'mprdim.dll',
    'mprmsg.dll',
    'msaatext.dll',
    'msac3enc.dll',
    'msacm32.dll',
    'msafd.dll',
    'msasn1.dll',
    'msaudite.dll',
    'mscandui.dll',
    'mscat32.dll',
    'msclmd.dll',
    'mscms.dll',
    'mscoree.dll',
    'mscorier.dll',
    'mscories.dll',
    'mscpx32r.dll',
    'mscpxl32.dll',
    'msctf.dll',
    'msctfmonitor.dll',
    'msctfp.dll',
    'msctfui.dll',
    'msdadiag.dll',
    'msdart.dll',
    'msdelta.dll',
    'msdmo.dll',
    'msdrm.dll',
    'msdtcprx.dll',
    'msdtcuiu.dll',
    'msdtcvsp1res.dll',
    'msexch40.dll',
    'msexcl40.dll',
    'msfeeds.dll',
    'msfeedsbs.dll',
    'msftedit.dll',
    'mshtml.dll',
    'mshtmldac.dll',
    'mshtmled.dll',
    'mshtmler.dll',
    'mshtmlmedia.dll',
    'msi.dll',
    'msidcrl30.dll',
    'msident.dll',
    'msidle.dll',
    'msidntld.dll',
    'msieftp.dll',
    'msihnd.dll',
    'msiltcfg.dll',
    'msimg32.dll',
    'msimsg.dll',
    'msimtf.dll',
    'msisip.dll',
    'msjet40.dll',
    'msjetoledb40.dll',
    'msjint40.dll',
    'msjter40.dll',
    'msjtes40.dll',
    'msls31.dll',
    'msltus40.dll',
    'msmpeg2adec.dll',
    'msmpeg2enc.dll',
    'msmpeg2vdec.dll',
    'msnetobj.dll',
    'msobjs.dll',
    'msoeacct.dll',
    'msoert2.dll',
    'msorc32r.dll',
    'msorcl32.dll',
    'mspatcha.dll',
    'mspbde40.dll',
    'msports.dll',
    'msrating.dll',
    'msrd2x40.dll',
    'msrd3x40.dll',
    'msrdc.dll',
    'msrdpwebaccess.dll',
    'msrepl40.dll',
    'msrle32.dll',
    'msscntrs.dll',
    'msscp.dll',
    'mssha.dll',
    'msshavmsg.dll',
    'msshooks.dll',
    'mssign32.dll',
    'mssip32.dll',
    'mssitlb.dll',
    'mssph.dll',
    'mssphtb.dll',
    'mssprxy.dll',
    'mssrch.dll',
    'mssvp.dll',
    'msswch.dll',
    'mstask.dll',
    'mstext40.dll',
    'mstscax.dll',
    'msutb.dll',
    'msv1_0.dll',
    'msvbvm60.dll',
    'msvcirt.dll',
    'msvcp110_clr0400.dll',
    'msvcp120_clr0400.dll',
    'msvcp60.dll',
    'msvcr100_clr0400.dll',
    'msvcr110_clr0400.dll',
    'msvcr120_clr0400.dll',
    'msvcrt.dll',
    'msvcrt20.dll',
    'msvcrt40.dll',
    'msvfw32.dll',
    'msvidc32.dll',
    'msvidctl.dll',
    'mswdat10.dll',
    'mswmdm.dll',
    'mswsock.dll',
    'mswstr10.dll',
    'msxbde40.dll',
    'msxml3.dll',
    'msxml3r.dll',
    'msxml6.dll',
    'msxml6r.dll',
    'msyuv.dll',
    'mtxclu.dll',
    'mtxdm.dll',
    'mtxex.dll',
    'mtxlegih.dll',
    'mtxoci.dll',
    'muifontsetup.dll',
    'mycomput.dll',
    'mydocs.dll',
    'napcrypt.dll',
    'napdsnap.dll',
    'naphlpr.dll',
    'napinsp.dll',
    'napipsec.dll',
    'napmontr.dll',
    'nativehooks.dll',
    'naturallanguage6.dll',
    'ncdprop.dll',
    'nci.dll',
    'ncobjapi.dll',
    'ncrypt.dll',
    'ncryptui.dll',
    'ncsi.dll',
    'nddeapi.dll',
    'ndfapi.dll',
    'ndfetw.dll',
    'ndfhcdiscovery.dll',
    'ndiscapcfg.dll',
    'ndishc.dll',
    'ndproxystub.dll',
    'negoexts.dll',
    'netapi32.dll',
    'netbios.dll',
    'netcenter.dll',
    'netcfgx.dll',
    'netcorehc.dll',
    'netdiagfx.dll',
    'netevent.dll',
    'netfxperf.dll',
    'neth.dll',
    'netid.dll',
    'netiohlp.dll',
    'netjoin.dll',
    'netlogon.dll',
    'netmsg.dll',
    'netplwiz.dll',
    'netprof.dll',
    'netprofm.dll',
    'netshell.dll',
    'netutils.dll',
    'networkexplorer.dll',
    'networkitemfactory.dll',
    'networkmap.dll',
    'newdev.dll',
    'nlaapi.dll',
    'nlhtml.dll',
    'nlmgp.dll',
    'nlmsprep.dll',
    'nlsbres.dll',
    'nlsdata0000.dll',
    'nlsdata0001.dll',
    'nlsdata0002.dll',
    'nlsdata0003.dll',
    'nlsdata0007.dll',
    'nlsdata0009.dll',
    'nlsdata000a.dll',
    'nlsdata000c.dll',
    'nlsdata000d.dll',
    'nlsdata000f.dll',
    'nlsdata0010.dll',
    'nlsdata0011.dll',
    'nlsdata0013.dll',
    'nlsdata0018.dll',
    'nlsdata0019.dll',
    'nlsdata001a.dll',
    'nlsdata001b.dll',
    'nlsdata001d.dll',
    'nlsdata0020.dll',
    'nlsdata0021.dll',
    'nlsdata0022.dll',
    'nlsdata0024.dll',
    'nlsdata0026.dll',
    'nlsdata0027.dll',
    'nlsdata002a.dll',
    'nlsdata0039.dll',
    'nlsdata003e.dll',
    'nlsdata0045.dll',
    'nlsdata0046.dll',
    'nlsdata0047.dll',
    'nlsdata0049.dll',
    'nlsdata004a.dll',
    'nlsdata004b.dll',
    'nlsdata004c.dll',
    'nlsdata004e.dll',
    'nlsdata0414.dll',
    'nlsdata0416.dll',
    'nlsdata0816.dll',
    'nlsdata081a.dll',
    'nlsdata0c1a.dll',
    'nlsdl.dll',
    'nlslexicons0001.dll',
    'nlslexicons0002.dll',
    'nlslexicons0003.dll',
    'nlslexicons0007.dll',
    'nlslexicons0009.dll',
    'nlslexicons000a.dll',
    'nlslexicons000c.dll',
    'nlslexicons000d.dll',
    'nlslexicons000f.dll',
    'nlslexicons0010.dll',
    'nlslexicons0011.dll',
    'nlslexicons0013.dll',
    'nlslexicons0018.dll',
    'nlslexicons0019.dll',
    'nlslexicons001a.dll',
    'nlslexicons001b.dll',
    'nlslexicons001d.dll',
    'nlslexicons0020.dll',
    'nlslexicons0021.dll',
    'nlslexicons0022.dll',
    'nlslexicons0024.dll',
    'nlslexicons0026.dll',
    'nlslexicons0027.dll',
    'nlslexicons002a.dll',
    'nlslexicons0039.dll',
    'nlslexicons003e.dll',
    'nlslexicons0045.dll',
    'nlslexicons0046.dll',
    'nlslexicons0047.dll',
    'nlslexicons0049.dll',
    'nlslexicons004a.dll',
    'nlslexicons004b.dll',
    'nlslexicons004c.dll',
    'nlslexicons004e.dll',
    'nlslexicons0414.dll',
    'nlslexicons0416.dll',
    'nlslexicons0816.dll',
    'nlslexicons081a.dll',
    'nlslexicons0c1a.dll',
    'nlsmodels0011.dll',
    'normaliz.dll',
    'npmproxy.dll',
    'nshhttp.dll',
    'nshipsec.dll',
    'nshwfp.dll',
    'nsi.dll',
    'ntdll.dll',
    'ntdsapi.dll',
    'ntlanman.dll',
    'ntlanui2.dll',
    'ntmarta.dll',
    'ntprint.dll',
    'ntshrui.dll',
    'ntvdm64.dll',
    'objsel.dll',
    'occache.dll',
    'ocsetapi.dll',
    'odbc32.dll',
    'odbc32gt.dll',
    'odbcbcp.dll',
    'odbcconf.dll',
    'odbccp32.dll',
    'odbccr32.dll',
    'odbccu32.dll',
    'odbcint.dll',
    'odbcji32.dll',
    'odbcjt32.dll',
    'odbctrac.dll',
    'oddbse32.dll',
    'odexl32.dll',
    'odfox32.dll',
    'odpdx32.dll',
    'odtext32.dll',
    'offfilt.dll',
    'ogldrv.dll',
    'ole2.dll',
    'ole2disp.dll',
    'ole2nls.dll',
    'ole32.dll',
    'oleacc.dll',
    'oleacchooks.dll',
    'oleaccrc.dll',
    'oleaut32.dll',
    'olecli32.dll',
    'oledlg.dll',
    'oleprn.dll',
    'olepro32.dll',
    'oleres.dll',
    'olesvr32.dll',
    'olethk32.dll',
    'onex.dll',
    'onexui.dll',
    'onlineidcpl.dll',
    'oobefldr.dll',
    'opcservices.dll',
    'opengl32.dll',
    'osbaseln.dll',
    'osuninst.dll',
    'p2p.dll',
    'p2pcollab.dll',
    'p2pgraph.dll',
    'p2pnetsh.dll',
    'packager.dll',
    'panmap.dll',
    'pautoenr.dll',
    'pcaui.dll',
    'pcwum.dll',
    'pdh.dll',
    'pdhui.dll',
    'peerdist.dll',
    'peerdistsh.dll',
    'perfcentercpl.dll',
    'perfctrs.dll',
    'perfdisk.dll',
    'perfnet.dll',
    'perfos.dll',
    'perfproc.dll',
    'perfts.dll',
    'photometadatahandler.dll',
    'photowiz.dll',
    'pid.dll',
    'pidgenx.dll',
    'pifmgr.dll',
    'pku2u.dll',
    'pla.dll',
    'playsndsrv.dll',
    'pmcsnap.dll',
    'pngfilt.dll',
    'pnidui.dll',
    'pnpsetup.dll',
    'pnrpnsp.dll',
    'polstore.dll',
    'portabledeviceapi.dll',
    'portabledeviceclassextension.dll',
    'portabledeviceconnectapi.dll',
    'portabledevicestatus.dll',
    'portabledevicesyncprovider.dll',
    'portabledevicetypes.dll',
    'portabledevicewiacompat.dll',
    'portabledevicewmdrm.dll',
    'pots.dll',
    'powercpl.dll',
    'powrprof.dll',
    'ppcsnap.dll',
    'presentationcffrasterizernative_v0300.dll',
    'presentationhostproxy.dll',
    'presentationnative_v0300.dll',
    'prflbmsg.dll',
    'printui.dll',
    'prncache.dll',
    'prnfldr.dll',
    'prnntfy.dll',
    'prntvpt.dll',
    'profapi.dll',
    'propsys.dll',
    'provsvc.dll',
    'provthrd.dll',
    'psapi.dll',
    'psbase.dll',
    'pshed.dll',
    'psisdecd.dll',
    'pstorec.dll',
    'pstorsvc.dll',
    'puiapi.dll',
    'puiobj.dll',
    'pwrshplugin.dll',
    'qagent.dll',
    'qasf.dll',
    'qcap.dll',
    'qcliprov.dll',
    'qdv.dll',
    'qdvd.dll',
    'qedit.dll',
    'qedwipes.dll',
    'qmgrprxy.dll',
    'qshvhost.dll',
    'qsvrmgmt.dll',
    'quartz.dll',
    'query.dll',
    'qutil.dll',
    'qwave.dll',
    'racengn.dll',
    'racpldlg.dll',
    'radardt.dll',
    'radarrs.dll',
    'rasadhlp.dll',
    'rasapi32.dll',
    'rascfg.dll',
    'raschap.dll',
    'rasctrs.dll',
    'rasdiag.dll',
    'rasdlg.dll',
    'rasgcw.dll',
    'rasman.dll',
    'rasmm.dll',
    'rasmontr.dll',
    'rasmxs.dll',
    'rasplap.dll',
    'rasppp.dll',
    'rasser.dll',
    'rastapi.dll',
    'rastls.dll',
    'rdpcore.dll',
    'rdpd3d.dll',
    'rdpencom.dll',
    'rdpendp.dll',
    'rdprefdrvapi.dll',
    'rdvgumd32.dll',
    'reagent.dll',
    'regapi.dll',
    'regctrl.dll',
    'remotepg.dll',
    'resampledmo.dll',
    'resutils.dll',
    'rgb9rast.dll',
    'riched20.dll',
    'riched32.dll',
    'rnr20.dll',
    'rpcdiag.dll',
    'rpchttp.dll',
    'rpcndfp.dll',
    'rpcns4.dll',
    'rpcnsh.dll',
    'rpcrt4.dll',
    'rpcrtremote.dll',
    'rsaenh.dll',
    'rshx32.dll',
    'rstrtmgr.dll',
    'rtffilt.dll',
    'rtm.dll',
    'rtutils.dll',
    'samcli.dll',
    'samlib.dll',
    'sampleres.dll',
    'sas.dll',
    'sbe.dll',
    'sbeio.dll',
    'sberes.dll',
    'scansetting.dll',
    'scarddlg.dll',
    'scecli.dll',
    'scesrv.dll',
    'schannel.dll',
    'schedcli.dll',
    'scksp.dll',
    'scripto.dll',
    'scrobj.dll',
    'scrptadm.dll',
    'scrrun.dll',
    'sdiageng.dll',
    'sdiagprv.dll',
    'sdohlp.dll',
    'searchfolder.dll',
    'sechost.dll',
    'secproc.dll',
    'secproc_isv.dll',
    'secproc_ssp.dll',
    'secproc_ssp_isv.dll',
    'secur32.dll',
    'security.dll',
    'sendmail.dll',
    'sens.dll',
    'sensapi.dll',
    'sensorsapi.dll',
    'sensorscpl.dll',
    'serialui.dll',
    'serwvdrv.dll',
    'sessenv.dll',
    'setupapi.dll',
    'setupcln.dll',
    'sfc.dll',
    'sfc_os.dll',
    'shacct.dll',
    'shdocvw.dll',
    'shell32.dll',
    'shellstyle.dll',
    'shfolder.dll',
    'shgina.dll',
    'shimeng.dll',
    'shimgvw.dll',
    'shlwapi.dll',
    'shpafact.dll',
    'shsetup.dll',
    'shsvcs.dll',
    'shunimpl.dll',
    'shwebsvc.dll',
    'signdrv.dll',
    'sisbkup.dll',
    'slc.dll',
    'slcext.dll',
    'slwga.dll',
    'smartcardcredentialprovider.dll',
    'smbhelperclass.dll',
    'sndvolsso.dll',
    'snmpapi.dll',
    'softkbd.dll',
    'softpub.dll',
    'sortserver2003compat.dll',
    'sortwindows6compat.dll',
    'spbcd.dll',
    'spfileq.dll',
    'spinf.dll',
    'spnet.dll',
    'spopk.dll',
    'spp.dll',
    'sppc.dll',
    'sppcc.dll',
    'sppcext.dll',
    'sppcomapi.dll',
    'sppcommdlg.dll',
    'sppinst.dll',
    'sppwmi.dll',
    'spwinsat.dll',
    'spwizeng.dll',
    'spwizimg.dll',
    'spwizres.dll',
    'spwmp.dll',
    'sqlceoledb30.dll',
    'sqlceqp30.dll',
    'sqlcese30.dll',
    'sqlsrv32.dll',
    'sqlunirl.dll',
    'sqlwid.dll',
    'sqlwoa.dll',
    'sqmapi.dll',
    'srchadmin.dll',
    'srclient.dll',
    'srhelper.dll',
    'srpuxnativesnapin.dll',
    'srvcli.dll',
    'sscore.dll',
    'ssdpapi.dll',
    'sspicli.dll',
    'ssshim.dll',
    'stclient.dll',
    'sti.dll',
    'stobject.dll',
    'storage.dll',
    'storagecontexthandler.dll',
    'storprop.dll',
    'structuredquery.dll',
    'sud.dll',
    'sxproxy.dll',
    'sxs.dll',
    'sxshared.dll',
    'sxsstore.dll',
    'synccenter.dll',
    'synceng.dll',
    'synchostps.dll',
    'syncinfrastructure.dll',
    'syncinfrastructureps.dll',
    'syncreg.dll',
    'syncui.dll',
    'syssetup.dll',
    'systemcpl.dll',
    't2embed.dll',
    'tapi3.dll',
    'tapi32.dll',
    'tapimigplugin.dll',
    'tapiperf.dll',
    'tapisrv.dll',
    'tapisysprep.dll',
    'tapiui.dll',
    'taskcomp.dll',
    'taskschd.dll',
    'taskschdps.dll',
    'tbs.dll',
    'tcpipcfg.dll',
    'tcpmonui.dll',
    'tdh.dll',
    'termmgr.dll',
    'thawbrkr.dll',
    'themecpl.dll',
    'themeui.dll',
    'thumbcache.dll',
    'timedatemuicallback.dll',
    'tlscsp.dll',
    'tpmcompc.dll',
    'tquery.dll',
    'traffic.dll',
    'trapi.dll',
    'tsbyuv.dll',
    'tschannel.dll',
    'tsgqec.dll',
    'tsmf.dll',
    'tspkg.dll',
    'tsworkspace.dll',
    'tvratings.dll',
    'twext.dll',
    'txflog.dll',
    'txfw32.dll',
    'typelib.dll',
    'tzres.dll',
    'ubpm.dll',
    'ucmhc.dll',
    'ucrtbase.dll',
    'udhisapi.dll',
    'uexfat.dll',
    'ufat.dll',
    'uianimation.dll',
    'uiautomationcore.dll',
    'uicom.dll',
    'uiribbon.dll',
    'uiribbonres.dll',
    'ulib.dll',
    'umdmxfrm.dll',
    'unimdmat.dll',
    'uniplat.dll',
    'untfs.dll',
    'upnp.dll',
    'upnphost.dll',
    'ureg.dll',
    'url.dll',
    'urlmon.dll',
    'usbceip.dll',
    'usbperf.dll',
    'usbui.dll',
    'user32.dll',
    'useraccountcontrolsettings.dll',
    'usercpl.dll',
    'userenv.dll',
    'usp10.dll',
    'utildll.dll',
    'uudf.dll',
    'uxinit.dll',
    'uxlib.dll',
    'uxlibres.dll',
    'uxtheme.dll',
    'van.dll',
    'vault.dll',
    'vaultcli.dll',
    'vbajet32.dll',
    'vbscript.dll',
    'vdmdbg.dll',
    'vdsbas.dll',
    'vdsdyn.dll',
    'vdsvd.dll',
    'vds_ps.dll',
    'verifier.dll',
    'version.dll',
    'vfpodbc.dll',
    'vfwwdm32.dll',
    'vidreszr.dll',
    'virtdisk.dll',
    'vpnikeapi.dll',
    'vssapi.dll',
    'vsstrace.dll',
    'vss_ps.dll',
    'w32topl.dll',
    'wabsyncprovider.dll',
    'wavemsp.dll',
    'wbemcomn.dll',
    'wcnapi.dll',
    'wcncsvc.dll',
    'wcneapauthproxy.dll',
    'wcneappeerproxy.dll',
    'wcnwiz.dll',
    'wcspluginservice.dll',
    'wdc.dll',
    'wdi.dll',
    'wdigest.dll',
    'wdscore.dll',
    'webcheck.dll',
    'webclnt.dll',
    'webio.dll',
    'webservices.dll',
    'wecapi.dll',
    'wer.dll',
    'werdiagcontroller.dll',
    'werui.dll',
    'wevtapi.dll',
    'wevtfwd.dll',
    'wfapigp.dll',
    'wfhc.dll',
    'whealogr.dll',
    'whhelper.dll',
    'wiaaut.dll',
    'wiadefui.dll',
    'wiadss.dll',
    'wiaextensionhost64.dll',
    'wiascanprofiles.dll',
    'wiashext.dll',
    'wiatrace.dll',
    'wiavideo.dll',
    'wimgapi.dll',
    'win32spl.dll',
    'winbio.dll',
    'winbrand.dll',
    'wincredprovider.dll',
    'windowscodecs.dll',
    'windowscodecsext.dll',
    'winfax.dll',
    'winhttp.dll',
    'wininet.dll',
    'winipsec.dll',
    'winmm.dll',
    'winnsi.dll',
    'winrnr.dll',
    'winrscmd.dll',
    'winrsmgr.dll',
    'winrssrv.dll',
    'winsatapi.dll',
    'winscard.dll',
    'winshfhc.dll',
    'winsockhc.dll',
    'winsrpc.dll',
    'winsta.dll',
    'winsync.dll',
    'winsyncmetastore.dll',
    'winsyncproviders.dll',
    'wintrust.dll',
    'winusb.dll',
    'wkscli.dll',
    'wksprtps.dll',
    'wlanapi.dll',
    'wlancfg.dll',
    'wlanconn.dll',
    'wlandlg.dll',
    'wlangpui.dll',
    'wlanhlp.dll',
    'wlaninst.dll',
    'wlanmm.dll',
    'wlanmsm.dll',
    'wlanpref.dll',
    'wlansec.dll',
    'wlanui.dll',
    'wlanutil.dll',
    'wldap32.dll',
    'wlgpclnt.dll',
    'wls0wndh.dll',
    'wmadmod.dll',
    'wmadmoe.dll',
    'wmasf.dll',
    'wmcodecdspps.dll',
    'wmdmlog.dll',
    'wmdmps.dll',
    'wmdrmdev.dll',
    'wmdrmnet.dll',
    'wmdrmsdk.dll',
    'wmerror.dll',
    'wmi.dll',
    'wmidx.dll',
    'wmiprop.dll',
    'wmnetmgr.dll',
    'wmp.dll',
    'wmpcm.dll',
    'wmpdui.dll',
    'wmpdxm.dll',
    'wmpeffects.dll',
    'wmpencen.dll',
    'wmphoto.dll',
    'wmploc.dll',
    'wmpmde.dll',
    'wmpps.dll',
    'wmpshell.dll',
    'wmpsrcwp.dll',
    'wmsgapi.dll',
    'wmspdmod.dll',
    'wmspdmoe.dll',
    'wmvcore.dll',
    'wmvdecod.dll',
    'wmvdspa.dll',
    'wmvencod.dll',
    'wmvsdecd.dll',
    'wmvsencd.dll',
    'wmvxencd.dll',
    'wow32.dll',
    'wpc.dll',
    'wpcao.dll',
    'wpcsvc.dll',
    'wpdshext.dll',
    'wpdshserviceobj.dll',
    'wpdsp.dll',
    'wpdwcn.dll',
    'ws2help.dll',
    'ws2_32.dll',
    'wscapi.dll',
    'wscinterop.dll',
    'wscisvif.dll',
    'wscmisetup.dll',
    'wscproxystub.dll',
    'wsdapi.dll',
    'wsdchngr.dll',
    'wsecedit.dll',
    'wshbth.dll',
    'wshcon.dll',
    'wshelper.dll',
    'wshext.dll',
    'wship6.dll',
    'wshirda.dll',
    'wshqos.dll',
    'wshrm.dll',
    'wshtcpip.dll',
    'wsmanmigrationplugin.dll',
    'wsmauto.dll',
    'wsmplpxy.dll',
    'wsmres.dll',
    'wsmsvc.dll',
    'wsmwmipl.dll',
    'wsnmp32.dll',
    'wsock32.dll',
    'wtsapi32.dll',
    'wuapi.dll',
    'wudriver.dll',
    'wups.dll',
    'wuwebv.dll',
    'wvc.dll',
    'wwanapi.dll',
    'wwapi.dll',
    'wzcdlg.dll',
    'xinput9_1_0.dll',
    'xmlfilter.dll',
    'xmllite.dll',
    'xmlprovi.dll',
    'xolehlp.dll',
    'xpsfilt.dll',
    'xpsgdiconverter.dll',
    'xpsprint.dll',
    'xpsrasterservice.dll',
    'xpsservices.dll',
    'xpsshhdr.dll',
    'xpssvcs.dll',
    'xwizards.dll',
    'xwreg.dll',
    'xwtpdui.dll',
    'xwtpw32.dll',
    'zipfldr.dll',
    'msacm32.drv',
    'wdmaud.drv',
    'winspool.drv',
}

# set of regular expressions for additional DLLs to ignore
ignore_regexes = {
    re.compile(r'^python[0-9]+\.dll$'),  # included in CPython distribution
    re.compile(r'^libpypy([0-9]+\.)*[0-9]+-c\.dll$'),  # included in PyPy distribution
    re.compile(r'^api-'),  # let Windows handle API sets
}

# DLLs to ignore based on Python ABI tag and platform tag. For CPython, these
# are included in their respective Python distributions. For PyPy, these are
# prerequisites for PyPy to run in the first place.
ignore_by_distribution = {
    'cp27m-win32': {'msvcr90.dll'},
    'cp27m-win_amd64': {'msvcr90.dll'},
    'pypy_41-win32': {'msvcr90.dll'},
    'pypy_73-win32': {'vcruntime140.dll'},
    'pypy_73-win_amd64': {'vcruntime140.dll'},
    'cp34m-win32': {'msvcr100.dll'},
    'cp34m-win_amd64': {'msvcr100.dll'},
    'cp35m-win32': {'vcruntime140.dll'},
    'cp35m-win_amd64': {'vcruntime140.dll'},
    'cp36m-win32': {'vcruntime140.dll'},
    'cp36m-win_amd64': {'vcruntime140.dll'},
    'pypy36_pp73-win32': {'vcruntime140.dll'},
    'cp37m-win32': {'vcruntime140.dll'},
    'cp37m-win_amd64': {'vcruntime140.dll'},
    'pypy37_pp73-win32': {'vcruntime140.dll'},
    'pypy37_pp73-win_amd64': {'vcruntime140.dll'},
    'cp38-win32': {'vcruntime140.dll'},
    'cp38-win_amd64': {'vcruntime140.dll', 'vcruntime140_1.dll'},
    'pypy38_pp73-win_amd64': {'vcruntime140.dll'},
    'cp39-win32': {'vcruntime140.dll'},
    'cp39-win_amd64': {'vcruntime140.dll', 'vcruntime140_1.dll'},
    'pypy39_pp73-win_amd64': {'vcruntime140.dll'},
    'cp310-win32': {'vcruntime140.dll'},
    'cp310-win_amd64': {'vcruntime140.dll', 'vcruntime140_1.dll'},
    'cp311-win32': {'vcruntime140.dll'},
    'cp311-win_amd64': {'vcruntime140.dll', 'vcruntime140_1.dll'},
}

# Prefixes of DLLs whose names should not be mangled. These either are
# dependencies of DLLs that contain data after the PE file proper (and thus
# cannot be modified by machomachomangler) or already have the version in the
# filename.
no_mangle_prefixes = {
    'vcruntime',
    'vccorlib',
    'msvcp',
    'msvcr',
    'concrt',
    'mfc',
    'vcamp',
    'vcomp',
    'libwinpthread',
    'ucrtbase',
}
