import re  # noqa: F401
import sys  # noqa: F401

from smscx_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    ApiModel
)
from smscx_client.exceptions import ApiAttributeError


def lazy_import():
    from smscx_client.model.accepted import Accepted
    from smscx_client.model.delivered import Delivered
    from smscx_client.model.failed import Failed
    from smscx_client.model.no_coverage import NoCoverage
    from smscx_client.model.scheduled import Scheduled
    globals()['Accepted'] = Accepted
    globals()['Delivered'] = Delivered
    globals()['Failed'] = Failed
    globals()['NoCoverage'] = NoCoverage
    globals()['Scheduled'] = Scheduled


class DataSummaryDelivery(ModelNormal):


    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def api_types():
        """
        Returns
            api_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'accepted': (Accepted,),  # noqa: E501
            'delivered': (Delivered,),  # noqa: E501
            'failed': (Failed,),  # noqa: E501
            'scheduled': (Scheduled,),  # noqa: E501
            'no_coverage': (NoCoverage,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'accepted': 'accepted',  # noqa: E501
        'delivered': 'delivered',  # noqa: E501
        'failed': 'failed',  # noqa: E501
        'scheduled': 'scheduled',  # noqa: E501
        'no_coverage': 'noCoverage',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_api_data(cls, accepted, delivered, failed, scheduled, no_coverage, *args, **kwargs):  # noqa: E501
        """DataSummaryDelivery - a model

        Args:
            accepted (Accepted):
            delivered (Delivered):
            failed (Failed):
            scheduled (Scheduled):
            no_coverage (NoCoverage):


        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(ApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.accepted = accepted
        self.delivered = delivered
        self.failed = failed
        self.scheduled = scheduled
        self.no_coverage = no_coverage
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, accepted, delivered, failed, scheduled, no_coverage, *args, **kwargs):  # noqa: E501
        """DataSummaryDelivery - a model

        Args:
            accepted (Accepted):
            delivered (Delivered):
            failed (Failed):
            scheduled (Scheduled):
            no_coverage (NoCoverage):


        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.accepted = accepted
        self.delivered = delivered
        self.failed = failed
        self.scheduled = scheduled
        self.no_coverage = no_coverage
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_api_data` to instantiate "
                                     f"class with read only attributes.")
