# Django Glue

![Build](https://img.shields.io/github/actions/workflow/status/stratusadv/django-glue/run_tests.yml)
![Python Versions](https://img.shields.io/pypi/pyversions/django-glue)
![PyPI Version](https://img.shields.io/pypi/v/django-glue)
![Downloads](https://img.shields.io/pypi/dm/django-glue)

We built Django Glue to help solve the problem of fluid interactions between the front and back ends of a Django application.
Our end goal is to bring as much front end power to the Django framework as possible while remaining pythonic.

This project is in prototype phase please look at the tests directory of this code base for example and instructions.

## Why?
We are active web platform developers that want to provide our clients with the best user experience without having to learn a bunch of different technology stacks.
Django glue allows us to do fancy javascript like page interactions and updates while remaining in the comfort of our django/python world.

Education is also a big part of what we do and our focus is on teaching our people python, so they can focus on data science and automation and make solid interfaces! 

## Inspiration
We are inspired by how quickly django's model structure, ORM and forms (crispy forms) allow you to create functional web applications.
Can we build on top of 25+ years of development to create a front end tool that uses the power of django.

## Documentation

Our documentation is available on our [website](https://django-glue.stratusadv.com), including guides, example, api reference and more.

<p align="center">
    <a href="https://django-glue.stratusadv.com">
        <img alt="Django Glue Logo" src="https://django-glue.stratusadv.com/static/img/django_glue_logo_256.png"/>
    </a>
</p>
