# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/verifiable-credentials/templates/v1/templates.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class FieldType(betterproto.Enum):
    STRING = 0
    NUMBER = 1
    BOOL = 2
    DATETIME = 4


@dataclass(eq=False, repr=False)
class GetCredentialTemplateRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetCredentialTemplateResponse(betterproto.Message):
    template: "TemplateData" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SearchCredentialTemplatesRequest(betterproto.Message):
    query: str = betterproto.string_field(1)
    continuation_token: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SearchCredentialTemplatesResponse(betterproto.Message):
    items_json: str = betterproto.string_field(1)
    has_more: bool = betterproto.bool_field(2)
    count: int = betterproto.int32_field(3)
    continuation_token: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ListCredentialTemplatesRequest(betterproto.Message):
    query: str = betterproto.string_field(1)
    continuation_token: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ListCredentialTemplatesResponse(betterproto.Message):
    templates: List["TemplateData"] = betterproto.message_field(1)
    has_more_results: bool = betterproto.bool_field(2)
    continuation_token: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class DeleteCredentialTemplateRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DeleteCredentialTemplateResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CreateCredentialTemplateRequest(betterproto.Message):
    """Request to create new template"""

    name: str = betterproto.string_field(1)
    fields: Dict[str, "TemplateField"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    allow_additional_fields: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class CreateCredentialTemplateResponse(betterproto.Message):
    data: "TemplateData" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class TemplateField(betterproto.Message):
    description: str = betterproto.string_field(2)
    optional: bool = betterproto.bool_field(3)
    type: "FieldType" = betterproto.enum_field(4)


@dataclass(eq=False, repr=False)
class GetTemplateRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetTemplateResponse(betterproto.Message):
    data: "TemplateData" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListTemplatesRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListTemplatesResponse(betterproto.Message):
    templates: List["TemplateData"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class TemplateData(betterproto.Message):
    id: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)
    version: int = betterproto.int32_field(3)
    fields: Dict[str, "TemplateField"] = betterproto.map_field(
        4, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    allow_additional_fields: bool = betterproto.bool_field(5)
    schema_uri: str = betterproto.string_field(6)
    context_uri: str = betterproto.string_field(7)
    ecosystem_id: str = betterproto.string_field(8)
    type: str = betterproto.string_field(9)


class CredentialTemplatesStub(betterproto.ServiceStub):
    async def create(
        self,
        *,
        name: str = "",
        fields: Dict[str, "TemplateField"] = None,
        allow_additional_fields: bool = False,
    ) -> "CreateCredentialTemplateResponse":

        request = CreateCredentialTemplateRequest()
        request.name = name
        request.fields = fields
        request.allow_additional_fields = allow_additional_fields

        return await self._unary_unary(
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Create",
            request,
            CreateCredentialTemplateResponse,
        )

    async def get(self, *, id: str = "") -> "GetCredentialTemplateResponse":

        request = GetCredentialTemplateRequest()
        request.id = id

        return await self._unary_unary(
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Get",
            request,
            GetCredentialTemplateResponse,
        )

    async def list(
        self, *, query: str = "", continuation_token: str = ""
    ) -> "ListCredentialTemplatesResponse":

        request = ListCredentialTemplatesRequest()
        request.query = query
        request.continuation_token = continuation_token

        return await self._unary_unary(
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/List",
            request,
            ListCredentialTemplatesResponse,
        )

    async def search(
        self, *, query: str = "", continuation_token: str = ""
    ) -> "SearchCredentialTemplatesResponse":

        request = SearchCredentialTemplatesRequest()
        request.query = query
        request.continuation_token = continuation_token

        return await self._unary_unary(
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Search",
            request,
            SearchCredentialTemplatesResponse,
        )

    async def delete(self, *, id: str = "") -> "DeleteCredentialTemplateResponse":

        request = DeleteCredentialTemplateRequest()
        request.id = id

        return await self._unary_unary(
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Delete",
            request,
            DeleteCredentialTemplateResponse,
        )


class CredentialTemplatesBase(ServiceBase):
    async def create(
        self,
        name: str,
        fields: Dict[str, "TemplateField"],
        allow_additional_fields: bool,
    ) -> "CreateCredentialTemplateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get(self, id: str) -> "GetCredentialTemplateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list(
        self, query: str, continuation_token: str
    ) -> "ListCredentialTemplatesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def search(
        self, query: str, continuation_token: str
    ) -> "SearchCredentialTemplatesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete(self, id: str) -> "DeleteCredentialTemplateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "name": request.name,
            "fields": request.fields,
            "allow_additional_fields": request.allow_additional_fields,
        }

        response = await self.create(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.get(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "query": request.query,
            "continuation_token": request.continuation_token,
        }

        response = await self.list(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_search(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "query": request.query,
            "continuation_token": request.continuation_token,
        }

        response = await self.search(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delete(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.delete(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Create": grpclib.const.Handler(
                self.__rpc_create,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateCredentialTemplateRequest,
                CreateCredentialTemplateResponse,
            ),
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Get": grpclib.const.Handler(
                self.__rpc_get,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetCredentialTemplateRequest,
                GetCredentialTemplateResponse,
            ),
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/List": grpclib.const.Handler(
                self.__rpc_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListCredentialTemplatesRequest,
                ListCredentialTemplatesResponse,
            ),
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Search": grpclib.const.Handler(
                self.__rpc_search,
                grpclib.const.Cardinality.UNARY_UNARY,
                SearchCredentialTemplatesRequest,
                SearchCredentialTemplatesResponse,
            ),
            "/services.verifiablecredentials.templates.v1.CredentialTemplates/Delete": grpclib.const.Handler(
                self.__rpc_delete,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteCredentialTemplateRequest,
                DeleteCredentialTemplateResponse,
            ),
        }
