# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/universal-wallet/v1/universal-wallet.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class SearchRequest(betterproto.Message):
    """Search request object"""

    query: str = betterproto.string_field(1)
    continuation_token: str = betterproto.string_field(2)
    options: "__common_v1__.RequestOptions" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class SearchResponse(betterproto.Message):
    """Search response object"""

    items: List["__common_v1__.JsonPayload"] = betterproto.message_field(1)
    has_more: bool = betterproto.bool_field(2)
    count: int = betterproto.int32_field(3)
    continuation_token: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class InsertItemRequest(betterproto.Message):
    """Insert item request"""

    item: "__common_v1__.JsonPayload" = betterproto.message_field(1)
    item_type: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class InsertItemResponse(betterproto.Message):
    """Insert item response"""

    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)
    # The item identifier of the inserted record
    item_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteItemRequest(betterproto.Message):
    """Delete item request"""

    pass


@dataclass(eq=False, repr=False)
class DeleteItemResponse(betterproto.Message):
    pass


class UniversalWalletStub(betterproto.ServiceStub):
    async def search(
        self,
        *,
        query: str = "",
        continuation_token: str = "",
        options: "__common_v1__.RequestOptions" = None,
    ) -> "SearchResponse":

        request = SearchRequest()
        request.query = query
        request.continuation_token = continuation_token
        if options is not None:
            request.options = options

        return await self._unary_unary(
            "/services.universalwallet.v1.UniversalWallet/Search",
            request,
            SearchResponse,
        )

    async def insert_item(
        self, *, item: "__common_v1__.JsonPayload" = None, item_type: str = ""
    ) -> "InsertItemResponse":

        request = InsertItemRequest()
        if item is not None:
            request.item = item
        request.item_type = item_type

        return await self._unary_unary(
            "/services.universalwallet.v1.UniversalWallet/InsertItem",
            request,
            InsertItemResponse,
        )

    async def deleteitem(self) -> "DeleteItemResponse":

        request = DeleteItemRequest()

        return await self._unary_unary(
            "/services.universalwallet.v1.UniversalWallet/Deleteitem",
            request,
            DeleteItemResponse,
        )


class UniversalWalletBase(ServiceBase):
    async def search(
        self,
        query: str,
        continuation_token: str,
        options: "__common_v1__.RequestOptions",
    ) -> "SearchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def insert_item(
        self, item: "__common_v1__.JsonPayload", item_type: str
    ) -> "InsertItemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def deleteitem(self) -> "DeleteItemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_search(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "query": request.query,
            "continuation_token": request.continuation_token,
            "options": request.options,
        }

        response = await self.search(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_insert_item(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "item": request.item,
            "item_type": request.item_type,
        }

        response = await self.insert_item(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_deleteitem(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.deleteitem(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.universalwallet.v1.UniversalWallet/Search": grpclib.const.Handler(
                self.__rpc_search,
                grpclib.const.Cardinality.UNARY_UNARY,
                SearchRequest,
                SearchResponse,
            ),
            "/services.universalwallet.v1.UniversalWallet/InsertItem": grpclib.const.Handler(
                self.__rpc_insert_item,
                grpclib.const.Cardinality.UNARY_UNARY,
                InsertItemRequest,
                InsertItemResponse,
            ),
            "/services.universalwallet.v1.UniversalWallet/Deleteitem": grpclib.const.Handler(
                self.__rpc_deleteitem,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteItemRequest,
                DeleteItemResponse,
            ),
        }


from ...common import v1 as __common_v1__
