# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/trust-registry/v1/trust-registry.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, Dict

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class RegistrationStatus(betterproto.Enum):
    CURRENT = 0
    EXPIRED = 1
    TERMINATED = 2
    REVOKED = 3
    NOT_FOUND = 10


@dataclass(eq=False, repr=False)
class AddFrameworkRequest(betterproto.Message):
    governance_framework: "GovernanceFramework" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AddFrameworkResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class RemoveFrameworkRequest(betterproto.Message):
    governance_framework: "GovernanceFramework" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RemoveFrameworkResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class SearchRegistryRequest(betterproto.Message):
    query: str = betterproto.string_field(1)
    continuation_token: str = betterproto.string_field(2)
    options: "__common_v1__.RequestOptions" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class SearchRegistryResponse(betterproto.Message):
    items_json: str = betterproto.string_field(1)
    has_more: bool = betterproto.bool_field(2)
    count: int = betterproto.int32_field(3)
    continuation_token: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class GovernanceFramework(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    trust_registry_uri: str = betterproto.string_field(2)
    description: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class RegisterIssuerRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    credential_type_uri: str = betterproto.string_field(10)
    valid_from_utc: int = betterproto.uint64_field(11)
    valid_until_utc: int = betterproto.uint64_field(12)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class RegisterIssuerResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class RegisterVerifierRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    presentation_type_uri: str = betterproto.string_field(10)
    valid_from_utc: int = betterproto.uint64_field(11)
    valid_until_utc: int = betterproto.uint64_field(12)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class RegisterVerifierResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class UnregisterIssuerRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    credential_type_uri: str = betterproto.string_field(10)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class UnregisterIssuerResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class UnregisterVerifierRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    presentation_type_uri: str = betterproto.string_field(10)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class UnregisterVerifierResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class CheckIssuerStatusRequest(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    did_uri: str = betterproto.string_field(2, group="member")
    x509_cert: str = betterproto.string_field(3, group="member")
    credential_type_uri: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class CheckIssuerStatusResponse(betterproto.Message):
    status: "RegistrationStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class CheckVerifierStatusRequest(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    did_uri: str = betterproto.string_field(2, group="member")
    x509_cert: str = betterproto.string_field(3, group="member")
    presentation_type_uri: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class CheckVerifierStatusResponse(betterproto.Message):
    status: "RegistrationStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class FetchDataRequest(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    query: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class FetchDataResponse(betterproto.Message):
    response_json: str = betterproto.string_field(1)
    has_more_results: bool = betterproto.bool_field(2)
    continuation_token: str = betterproto.string_field(3)


class TrustRegistryStub(betterproto.ServiceStub):
    async def add_framework(
        self, *, governance_framework: "GovernanceFramework" = None
    ) -> "AddFrameworkResponse":

        request = AddFrameworkRequest()
        if governance_framework is not None:
            request.governance_framework = governance_framework

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/AddFramework",
            request,
            AddFrameworkResponse,
        )

    async def remove_framework(
        self, *, governance_framework: "GovernanceFramework" = None
    ) -> "RemoveFrameworkResponse":

        request = RemoveFrameworkRequest()
        if governance_framework is not None:
            request.governance_framework = governance_framework

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/RemoveFramework",
            request,
            RemoveFrameworkResponse,
        )

    async def search_registry(
        self,
        *,
        query: str = "",
        continuation_token: str = "",
        options: "__common_v1__.RequestOptions" = None,
    ) -> "SearchRegistryResponse":

        request = SearchRegistryRequest()
        request.query = query
        request.continuation_token = continuation_token
        if options is not None:
            request.options = options

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/SearchRegistry",
            request,
            SearchRegistryResponse,
        )

    async def register_issuer(
        self,
        *,
        did_uri: str = "",
        x509_cert: str = "",
        credential_type_uri: str = "",
        valid_from_utc: int = 0,
        valid_until_utc: int = 0,
        governance_framework_uri: str = "",
    ) -> "RegisterIssuerResponse":

        request = RegisterIssuerRequest()
        if did_uri:
            request.did_uri = did_uri
        if x509_cert:
            request.x509_cert = x509_cert
        request.credential_type_uri = credential_type_uri
        request.valid_from_utc = valid_from_utc
        request.valid_until_utc = valid_until_utc
        request.governance_framework_uri = governance_framework_uri

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/RegisterIssuer",
            request,
            RegisterIssuerResponse,
        )

    async def register_verifier(
        self,
        *,
        did_uri: str = "",
        x509_cert: str = "",
        presentation_type_uri: str = "",
        valid_from_utc: int = 0,
        valid_until_utc: int = 0,
        governance_framework_uri: str = "",
    ) -> "RegisterVerifierResponse":

        request = RegisterVerifierRequest()
        if did_uri:
            request.did_uri = did_uri
        if x509_cert:
            request.x509_cert = x509_cert
        request.presentation_type_uri = presentation_type_uri
        request.valid_from_utc = valid_from_utc
        request.valid_until_utc = valid_until_utc
        request.governance_framework_uri = governance_framework_uri

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/RegisterVerifier",
            request,
            RegisterVerifierResponse,
        )

    async def unregister_issuer(
        self,
        *,
        did_uri: str = "",
        x509_cert: str = "",
        credential_type_uri: str = "",
        governance_framework_uri: str = "",
    ) -> "UnregisterIssuerResponse":

        request = UnregisterIssuerRequest()
        if did_uri:
            request.did_uri = did_uri
        if x509_cert:
            request.x509_cert = x509_cert
        request.credential_type_uri = credential_type_uri
        request.governance_framework_uri = governance_framework_uri

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/UnregisterIssuer",
            request,
            UnregisterIssuerResponse,
        )

    async def unregister_verifier(
        self,
        *,
        did_uri: str = "",
        x509_cert: str = "",
        presentation_type_uri: str = "",
        governance_framework_uri: str = "",
    ) -> "UnregisterVerifierResponse":

        request = UnregisterVerifierRequest()
        if did_uri:
            request.did_uri = did_uri
        if x509_cert:
            request.x509_cert = x509_cert
        request.presentation_type_uri = presentation_type_uri
        request.governance_framework_uri = governance_framework_uri

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/UnregisterVerifier",
            request,
            UnregisterVerifierResponse,
        )

    async def check_issuer_status(
        self,
        *,
        governance_framework_uri: str = "",
        did_uri: str = "",
        x509_cert: str = "",
        credential_type_uri: str = "",
    ) -> "CheckIssuerStatusResponse":

        request = CheckIssuerStatusRequest()
        request.governance_framework_uri = governance_framework_uri
        if did_uri:
            request.did_uri = did_uri
        if x509_cert:
            request.x509_cert = x509_cert
        request.credential_type_uri = credential_type_uri

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/CheckIssuerStatus",
            request,
            CheckIssuerStatusResponse,
        )

    async def check_verifier_status(
        self,
        *,
        governance_framework_uri: str = "",
        did_uri: str = "",
        x509_cert: str = "",
        presentation_type_uri: str = "",
    ) -> "CheckVerifierStatusResponse":

        request = CheckVerifierStatusRequest()
        request.governance_framework_uri = governance_framework_uri
        if did_uri:
            request.did_uri = did_uri
        if x509_cert:
            request.x509_cert = x509_cert
        request.presentation_type_uri = presentation_type_uri

        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/CheckVerifierStatus",
            request,
            CheckVerifierStatusResponse,
        )

    async def fetch_data(
        self, *, governance_framework_uri: str = "", query: str = ""
    ) -> AsyncIterator["FetchDataResponse"]:

        request = FetchDataRequest()
        request.governance_framework_uri = governance_framework_uri
        request.query = query

        async for response in self._unary_stream(
            "/services.trustregistry.v1.TrustRegistry/FetchData",
            request,
            FetchDataResponse,
        ):
            yield response


class TrustRegistryBase(ServiceBase):
    async def add_framework(
        self, governance_framework: "GovernanceFramework"
    ) -> "AddFrameworkResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_framework(
        self, governance_framework: "GovernanceFramework"
    ) -> "RemoveFrameworkResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def search_registry(
        self,
        query: str,
        continuation_token: str,
        options: "__common_v1__.RequestOptions",
    ) -> "SearchRegistryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def register_issuer(
        self,
        did_uri: str,
        x509_cert: str,
        credential_type_uri: str,
        valid_from_utc: int,
        valid_until_utc: int,
        governance_framework_uri: str,
    ) -> "RegisterIssuerResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def register_verifier(
        self,
        did_uri: str,
        x509_cert: str,
        presentation_type_uri: str,
        valid_from_utc: int,
        valid_until_utc: int,
        governance_framework_uri: str,
    ) -> "RegisterVerifierResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unregister_issuer(
        self,
        did_uri: str,
        x509_cert: str,
        credential_type_uri: str,
        governance_framework_uri: str,
    ) -> "UnregisterIssuerResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unregister_verifier(
        self,
        did_uri: str,
        x509_cert: str,
        presentation_type_uri: str,
        governance_framework_uri: str,
    ) -> "UnregisterVerifierResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_issuer_status(
        self,
        governance_framework_uri: str,
        did_uri: str,
        x509_cert: str,
        credential_type_uri: str,
    ) -> "CheckIssuerStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_verifier_status(
        self,
        governance_framework_uri: str,
        did_uri: str,
        x509_cert: str,
        presentation_type_uri: str,
    ) -> "CheckVerifierStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_data(
        self, governance_framework_uri: str, query: str
    ) -> AsyncIterator["FetchDataResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_add_framework(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "governance_framework": request.governance_framework,
        }

        response = await self.add_framework(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_remove_framework(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "governance_framework": request.governance_framework,
        }

        response = await self.remove_framework(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_search_registry(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "query": request.query,
            "continuation_token": request.continuation_token,
            "options": request.options,
        }

        response = await self.search_registry(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_register_issuer(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "did_uri": request.did_uri,
            "x509_cert": request.x509_cert,
            "credential_type_uri": request.credential_type_uri,
            "valid_from_utc": request.valid_from_utc,
            "valid_until_utc": request.valid_until_utc,
            "governance_framework_uri": request.governance_framework_uri,
        }

        response = await self.register_issuer(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_register_verifier(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "did_uri": request.did_uri,
            "x509_cert": request.x509_cert,
            "presentation_type_uri": request.presentation_type_uri,
            "valid_from_utc": request.valid_from_utc,
            "valid_until_utc": request.valid_until_utc,
            "governance_framework_uri": request.governance_framework_uri,
        }

        response = await self.register_verifier(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_unregister_issuer(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "did_uri": request.did_uri,
            "x509_cert": request.x509_cert,
            "credential_type_uri": request.credential_type_uri,
            "governance_framework_uri": request.governance_framework_uri,
        }

        response = await self.unregister_issuer(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_unregister_verifier(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "did_uri": request.did_uri,
            "x509_cert": request.x509_cert,
            "presentation_type_uri": request.presentation_type_uri,
            "governance_framework_uri": request.governance_framework_uri,
        }

        response = await self.unregister_verifier(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_check_issuer_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "governance_framework_uri": request.governance_framework_uri,
            "did_uri": request.did_uri,
            "x509_cert": request.x509_cert,
            "credential_type_uri": request.credential_type_uri,
        }

        response = await self.check_issuer_status(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_check_verifier_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "governance_framework_uri": request.governance_framework_uri,
            "did_uri": request.did_uri,
            "x509_cert": request.x509_cert,
            "presentation_type_uri": request.presentation_type_uri,
        }

        response = await self.check_verifier_status(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_fetch_data(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "governance_framework_uri": request.governance_framework_uri,
            "query": request.query,
        }

        await self._call_rpc_handler_server_stream(
            self.fetch_data,
            stream,
            request_kwargs,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.trustregistry.v1.TrustRegistry/AddFramework": grpclib.const.Handler(
                self.__rpc_add_framework,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddFrameworkRequest,
                AddFrameworkResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/RemoveFramework": grpclib.const.Handler(
                self.__rpc_remove_framework,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveFrameworkRequest,
                RemoveFrameworkResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/SearchRegistry": grpclib.const.Handler(
                self.__rpc_search_registry,
                grpclib.const.Cardinality.UNARY_UNARY,
                SearchRegistryRequest,
                SearchRegistryResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/RegisterIssuer": grpclib.const.Handler(
                self.__rpc_register_issuer,
                grpclib.const.Cardinality.UNARY_UNARY,
                RegisterIssuerRequest,
                RegisterIssuerResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/RegisterVerifier": grpclib.const.Handler(
                self.__rpc_register_verifier,
                grpclib.const.Cardinality.UNARY_UNARY,
                RegisterVerifierRequest,
                RegisterVerifierResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/UnregisterIssuer": grpclib.const.Handler(
                self.__rpc_unregister_issuer,
                grpclib.const.Cardinality.UNARY_UNARY,
                UnregisterIssuerRequest,
                UnregisterIssuerResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/UnregisterVerifier": grpclib.const.Handler(
                self.__rpc_unregister_verifier,
                grpclib.const.Cardinality.UNARY_UNARY,
                UnregisterVerifierRequest,
                UnregisterVerifierResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/CheckIssuerStatus": grpclib.const.Handler(
                self.__rpc_check_issuer_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckIssuerStatusRequest,
                CheckIssuerStatusResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/CheckVerifierStatus": grpclib.const.Handler(
                self.__rpc_check_verifier_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckVerifierStatusRequest,
                CheckVerifierStatusResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/FetchData": grpclib.const.Handler(
                self.__rpc_fetch_data,
                grpclib.const.Cardinality.UNARY_STREAM,
                FetchDataRequest,
                FetchDataResponse,
            ),
        }


from ...common import v1 as __common_v1__
