# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/provider/v1/provider.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class ParticipantType(betterproto.Enum):
    participant_type_individual = 0
    participant_type_organization = 1


class InvitationStatusResponseStatus(betterproto.Enum):
    Error = 0
    InvitationSent = 1
    Completed = 2
    Expired = 3


@dataclass(eq=False, repr=False)
class Invite(betterproto.Message):
    id: str = betterproto.string_field(1)
    code: str = betterproto.string_field(2)
    created: str = betterproto.string_field(3)
    accepted: str = betterproto.string_field(4)
    expires: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class InviteRequest(betterproto.Message):
    participant: "ParticipantType" = betterproto.enum_field(1)
    description: str = betterproto.string_field(2)
    email: str = betterproto.string_field(5, group="contact_method")
    phone: str = betterproto.string_field(6, group="contact_method")
    didcomm_invitation: "InviteRequestDidCommInvitation" = betterproto.message_field(
        7, group="contact_method"
    )


@dataclass(eq=False, repr=False)
class InviteRequestDidCommInvitation(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class InviteResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)
    invitation_id: str = betterproto.string_field(10)


@dataclass(eq=False, repr=False)
class InvitationStatusRequest(betterproto.Message):
    """
    Request details for the status of onboarding an individual or organization.
    The referenece_id passed is the response from the `Onboard` method call
    """

    invitation_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class InvitationStatusResponse(betterproto.Message):
    status: "InvitationStatusResponseStatus" = betterproto.enum_field(1)
    status_details: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Ecosystem(betterproto.Message):
    id: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)
    description: str = betterproto.string_field(3)
    uri: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class CreateEcosystemRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    uri: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class CreateEcosystemResponse(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ListEcosystemsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListEcosystemsResponse(betterproto.Message):
    ecosystem: List["Ecosystem"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AcceptInviteRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    code: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class AcceptInviteResponse(betterproto.Message):
    ecosystem: "Ecosystem" = betterproto.message_field(2)


class ProviderStub(betterproto.ServiceStub):
    async def create_ecosystem(
        self, *, name: str = "", description: str = "", uri: str = ""
    ) -> "CreateEcosystemResponse":

        request = CreateEcosystemRequest()
        request.name = name
        request.description = description
        request.uri = uri

        return await self._unary_unary(
            "/services.provider.v1.Provider/CreateEcosystem",
            request,
            CreateEcosystemResponse,
        )

    async def list_ecosystems(self) -> "ListEcosystemsResponse":

        request = ListEcosystemsRequest()

        return await self._unary_unary(
            "/services.provider.v1.Provider/ListEcosystems",
            request,
            ListEcosystemsResponse,
        )

    async def invite(
        self,
        *,
        participant: "ParticipantType" = None,
        description: str = "",
        email: str = "",
        phone: str = "",
        didcomm_invitation: "InviteRequestDidCommInvitation" = None,
    ) -> "InviteResponse":

        request = InviteRequest()
        request.participant = participant
        request.description = description
        if email is not None and email != "":
            request.email = email
        if phone is not None and phone != "":
            request.phone = phone
        if didcomm_invitation is not None:
            request.didcomm_invitation = didcomm_invitation

        return await self._unary_unary(
            "/services.provider.v1.Provider/Invite", request, InviteResponse
        )

    async def accept_invite(
        self, *, id: str = "", code: str = ""
    ) -> "AcceptInviteResponse":

        request = AcceptInviteRequest()
        request.id = id
        request.code = code

        return await self._unary_unary(
            "/services.provider.v1.Provider/AcceptInvite", request, AcceptInviteResponse
        )

    async def invitation_status(
        self, *, invitation_id: str = ""
    ) -> "InvitationStatusResponse":

        request = InvitationStatusRequest()
        request.invitation_id = invitation_id

        return await self._unary_unary(
            "/services.provider.v1.Provider/InvitationStatus",
            request,
            InvitationStatusResponse,
        )


class ProviderBase(ServiceBase):
    async def create_ecosystem(
        self, name: str, description: str, uri: str
    ) -> "CreateEcosystemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_ecosystems(self) -> "ListEcosystemsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invite(
        self,
        participant: "ParticipantType",
        description: str,
        email: str,
        phone: str,
        didcomm_invitation: "InviteRequestDidCommInvitation",
    ) -> "InviteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def accept_invite(self, id: str, code: str) -> "AcceptInviteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invitation_status(self, invitation_id: str) -> "InvitationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_ecosystem(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "name": request.name,
            "description": request.description,
            "uri": request.uri,
        }

        response = await self.create_ecosystem(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_ecosystems(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.list_ecosystems(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_invite(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "participant": request.participant,
            "description": request.description,
            "email": request.email,
            "phone": request.phone,
            "didcomm_invitation": request.didcomm_invitation,
        }

        response = await self.invite(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_accept_invite(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "code": request.code,
        }

        response = await self.accept_invite(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_invitation_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "invitation_id": request.invitation_id,
        }

        response = await self.invitation_status(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.provider.v1.Provider/CreateEcosystem": grpclib.const.Handler(
                self.__rpc_create_ecosystem,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateEcosystemRequest,
                CreateEcosystemResponse,
            ),
            "/services.provider.v1.Provider/ListEcosystems": grpclib.const.Handler(
                self.__rpc_list_ecosystems,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListEcosystemsRequest,
                ListEcosystemsResponse,
            ),
            "/services.provider.v1.Provider/Invite": grpclib.const.Handler(
                self.__rpc_invite,
                grpclib.const.Cardinality.UNARY_UNARY,
                InviteRequest,
                InviteResponse,
            ),
            "/services.provider.v1.Provider/AcceptInvite": grpclib.const.Handler(
                self.__rpc_accept_invite,
                grpclib.const.Cardinality.UNARY_UNARY,
                AcceptInviteRequest,
                AcceptInviteResponse,
            ),
            "/services.provider.v1.Provider/InvitationStatus": grpclib.const.Handler(
                self.__rpc_invitation_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                InvitationStatusRequest,
                InvitationStatusResponse,
            ),
        }


from ...common import v1 as __common_v1__
