

LeanIXCloudScanBillingPolicyReader = {
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "ce:*"
            ],
            "Resource": [
                "*"
            ]
        }
    ]
}

LeanIXCloudScanAdvisorPolicyReader = {
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "VisualEditor0",
            "Effect": "Allow",
            "Action": [
                "support:DescribeTrustedAdvisorCheckResult",
                "support:DescribeTrustedAdvisorChecks"
            ],
            "Resource": "*"
        }
    ]
}

ReadOnlyAccess = {
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": [
                "a4b:Get*",
                "a4b:List*",
                "a4b:Search*",
                "access-analyzer:GetAccessPreview",
                "access-analyzer:GetAnalyzedResource",
                "access-analyzer:GetAnalyzer",
                "access-analyzer:GetArchiveRule",
                "access-analyzer:GetFinding",
                "access-analyzer:ListAccessPreviewFindings",
                "access-analyzer:ListAccessPreviews",
                "access-analyzer:ListAnalyzedResources",
                "access-analyzer:ListAnalyzers",
                "access-analyzer:ListArchiveRules",
                "access-analyzer:ListFindings",
                "access-analyzer:ListTagsForResource",
                "access-analyzer:ValidatePolicy",
                "acm-pca:Describe*",
                "acm-pca:Get*",
                "acm-pca:List*",
                "acm:Describe*",
                "acm:Get*",
                "acm:List*",
                "amplify:GetApp",
                "amplify:GetBranch",
                "amplify:GetDomainAssociation",
                "amplify:GetJob",
                "amplify:ListApps",
                "amplify:ListBranches",
                "amplify:ListDomainAssociations",
                "amplify:ListJobs",
                "apigateway:GET",
                "application-autoscaling:Describe*",
                "applicationinsights:Describe*",
                "applicationinsights:List*",
                "appmesh:Describe*",
                "appmesh:List*",
                "appstream:Describe*",
                "appstream:List*",
                "appsync:Get*",
                "appsync:List*",
                "athena:Batch*",
                "athena:Get*",
                "athena:List*",
                "autoscaling-plans:Describe*",
                "autoscaling-plans:GetScalingPlanResourceForecastData",
                "autoscaling:Describe*",
                "aws-portal:View*",
                "backup:Describe*",
                "backup:Get*",
                "backup:List*",
                "batch:Describe*",
                "batch:List*",
                "braket:GetDevice",
                "braket:GetQuantumTask",
                "braket:SearchDevices",
                "braket:SearchQuantumTasks",
                "budgets:Describe*",
                "budgets:View*",
                "cassandra:Select",
                "chatbot:Describe*",
                "chatbot:Get*",
                "chime:Get*",
                "chime:List*",
                "chime:Retrieve*",
                "chime:Search*",
                "chime:Validate*",
                "cloud9:Describe*",
                "cloud9:List*",
                "clouddirectory:BatchRead",
                "clouddirectory:Get*",
                "clouddirectory:List*",
                "clouddirectory:LookupPolicy",
                "cloudformation:Describe*",
                "cloudformation:Detect*",
                "cloudformation:Estimate*",
                "cloudformation:Get*",
                "cloudformation:List*",
                "cloudfront:Get*",
                "cloudfront:List*",
                "cloudhsm:Describe*",
                "cloudhsm:Get*",
                "cloudhsm:List*",
                "cloudsearch:Describe*",
                "cloudsearch:List*",
                "cloudtrail:Describe*",
                "cloudtrail:Get*",
                "cloudtrail:List*",
                "cloudtrail:LookupEvents",
                "cloudwatch:Describe*",
                "cloudwatch:Get*",
                "cloudwatch:List*",
                "codeartifact:DescribeDomain",
                "codeartifact:DescribePackageVersion",
                "codeartifact:DescribeRepository",
                "codeartifact:GetAuthorizationToken",
                "codeartifact:GetDomainPermissionsPolicy",
                "codeartifact:GetPackageVersionAsset",
                "codeartifact:GetPackageVersionReadme",
                "codeartifact:GetRepositoryEndpoint",
                "codeartifact:GetRepositoryPermissionsPolicy",
                "codeartifact:ListDomains",
                "codeartifact:ListPackages",
                "codeartifact:ListPackageVersionAssets",
                "codeartifact:ListPackageVersionDependencies",
                "codeartifact:ListPackageVersions",
                "codeartifact:ListRepositories",
                "codeartifact:ListRepositoriesInDomain",
                "codebuild:BatchGet*",
                "codebuild:DescribeCodeCoverages",
                "codebuild:DescribeTestCases",
                "codebuild:List*",
                "codecommit:BatchGet*",
                "codecommit:Describe*",
                "codecommit:Get*",
                "codecommit:GitPull",
                "codecommit:List*",
                "codedeploy:BatchGet*",
                "codedeploy:Get*",
                "codedeploy:List*",
                "codeguru-profiler:Describe*",
                "codeguru-profiler:Get*",
                "codeguru-profiler:List*",
                "codeguru-reviewer:Describe*",
                "codeguru-reviewer:Get*",
                "codeguru-reviewer:List*",
                "codepipeline:Get*",
                "codepipeline:List*",
                "codestar-notifications:describeNotificationRule",
                "codestar-notifications:listEventTypes",
                "codestar-notifications:listNotificationRules",
                "codestar-notifications:listTagsForResource",
                "codestar-notifications:ListTargets",
                "codestar:Describe*",
                "codestar:Get*",
                "codestar:List*",
                "codestar:Verify*",
                "cognito-identity:Describe*",
                "cognito-identity:GetCredentialsForIdentity",
                "cognito-identity:GetIdentityPoolRoles",
                "cognito-identity:GetOpenIdToken",
                "cognito-identity:GetOpenIdTokenForDeveloperIdentity",
                "cognito-identity:List*",
                "cognito-identity:Lookup*",
                "cognito-idp:AdminGet*",
                "cognito-idp:AdminList*",
                "cognito-idp:Describe*",
                "cognito-idp:Get*",
                "cognito-idp:List*",
                "cognito-sync:Describe*",
                "cognito-sync:Get*",
                "cognito-sync:List*",
                "cognito-sync:QueryRecords",
                "compute-optimizer:DescribeRecommendationExportJobs",
                "compute-optimizer:GetAutoScalingGroupRecommendations",
                "compute-optimizer:GetEBSVolumeRecommendations",
                "compute-optimizer:GetEC2InstanceRecommendations",
                "compute-optimizer:GetEC2RecommendationProjectedMetrics",
                "compute-optimizer:GetEnrollmentStatus",
                "compute-optimizer:GetLambdaFunctionRecommendations",
                "compute-optimizer:GetRecommendationSummaries",
                "config:BatchGetAggregateResourceConfig",
                "config:BatchGetResourceConfig",
                "config:Deliver*",
                "config:Describe*",
                "config:Get*",
                "config:List*",
                "config:SelectAggregateResourceConfig",
                "config:SelectResourceConfig",
                "connect:Describe*",
                "connect:GetFederationToken",
                "connect:List*",
                "dataexchange:Get*",
                "dataexchange:List*",
                "datapipeline:Describe*",
                "datapipeline:EvaluateExpression",
                "datapipeline:Get*",
                "datapipeline:List*",
                "datapipeline:QueryObjects",
                "datapipeline:Validate*",
                "datasync:Describe*",
                "datasync:List*",
                "dax:BatchGetItem",
                "dax:Describe*",
                "dax:GetItem",
                "dax:ListTags",
                "dax:Query",
                "dax:Scan",
                "deepcomposer:GetComposition",
                "deepcomposer:GetModel",
                "deepcomposer:GetSampleModel",
                "deepcomposer:ListCompositions",
                "deepcomposer:ListModels",
                "deepcomposer:ListSampleModels",
                "deepcomposer:ListTrainingTopics",
                "detective:Get*",
                "detective:List*",
                "devicefarm:Get*",
                "devicefarm:List*",
                "devops-guru:DescribeAccountHealth",
                "devops-guru:DescribeAccountOverview",
                "devops-guru:DescribeAnomaly",
                "devops-guru:DescribeInsight",
                "devops-guru:DescribeResourceCollectionHealth",
                "devops-guru:DescribeServiceIntegration",
                "devops-guru:GetResourceCollection",
                "devops-guru:ListAnomaliesForInsight",
                "devops-guru:ListEvents",
                "devops-guru:ListInsights",
                "devops-guru:ListNotificationChannels",
                "devops-guru:ListRecommendations",
                "devops-guru:SearchInsights",
                "directconnect:Describe*",
                "discovery:Describe*",
                "discovery:Get*",
                "discovery:List*",
                "dlm:Get*",
                "dms:Describe*",
                "dms:List*",
                "dms:Test*",
                "ds:Check*",
                "ds:Describe*",
                "ds:Get*",
                "ds:List*",
                "ds:Verify*",
                "dynamodb:BatchGet*",
                "dynamodb:Describe*",
                "dynamodb:Get*",
                "dynamodb:List*",
                "dynamodb:Query",
                "dynamodb:Scan",
                "ec2:Describe*",
                "ec2:Get*",
                "ec2:SearchTransitGatewayRoutes",
                "ec2messages:Get*",
                "ecr:BatchCheck*",
                "ecr:BatchGet*",
                "ecr:Describe*",
                "ecr:Get*",
                "ecr:List*",
                "ecs:Describe*",
                "ecs:List*",
                "eks:Describe*",
                "eks:List*",
                "elasticache:Describe*",
                "elasticache:List*",
                "elasticbeanstalk:Check*",
                "elasticbeanstalk:Describe*",
                "elasticbeanstalk:List*",
                "elasticbeanstalk:Request*",
                "elasticbeanstalk:Retrieve*",
                "elasticbeanstalk:Validate*",
                "elasticfilesystem:Describe*",
                "elasticloadbalancing:Describe*",
                "elasticmapreduce:Describe*",
                "elasticmapreduce:GetBlockPublicAccessConfiguration",
                "elasticmapreduce:List*",
                "elasticmapreduce:View*",
                "elastictranscoder:List*",
                "elastictranscoder:Read*",
                "elemental-appliances-software:Get*",
                "elemental-appliances-software:List*",
                "es:Describe*",
                "es:ESHttpGet",
                "es:ESHttpHead",
                "es:Get*",
                "es:List*",
                "events:Describe*",
                "events:List*",
                "events:Test*",
                "firehose:Describe*",
                "firehose:List*",
                "fis:GetAction",
                "fis:GetExperiment",
                "fis:GetExperimentTemplate",
                "fis:ListActions",
                "fis:ListExperiments",
                "fis:ListExperimentTemplates",
                "fis:ListTagsForResource",
                "fms:GetAdminAccount",
                "fms:GetAppsList",
                "fms:GetComplianceDetail",
                "fms:GetNotificationChannel",
                "fms:GetPolicy",
                "fms:GetProtectionStatus",
                "fms:GetProtocolsList",
                "fms:GetViolationDetails",
                "fms:ListAppsLists",
                "fms:ListComplianceStatus",
                "fms:ListMemberAccounts",
                "fms:ListPolicies",
                "fms:ListProtocolsLists",
                "fms:ListTagsForResource",
                "freertos:Describe*",
                "freertos:List*",
                "fsx:Describe*",
                "fsx:List*",
                "gamelift:Describe*",
                "gamelift:Get*",
                "gamelift:List*",
                "gamelift:RequestUploadCredentials",
                "gamelift:ResolveAlias",
                "gamelift:Search*",
                "glacier:Describe*",
                "glacier:Get*",
                "glacier:List*",
                "globalaccelerator:Describe*",
                "globalaccelerator:List*",
                "glue:BatchGetDevEndpoints",
                "glue:BatchGetJobs",
                "glue:BatchGetPartition",
                "glue:BatchGetTriggers",
                "glue:BatchGetWorkflows",
                "glue:CheckSchemaVersionValidity",
                "glue:GetCatalogImportStatus",
                "glue:GetClassifier",
                "glue:GetClassifiers",
                "glue:GetCrawler",
                "glue:GetCrawlerMetrics",
                "glue:GetCrawlers",
                "glue:GetDatabase",
                "glue:GetDatabases",
                "glue:GetDataCatalogEncryptionSettings",
                "glue:GetDataflowGraph",
                "glue:GetDevEndpoint",
                "glue:GetDevEndpoints",
                "glue:GetJob",
                "glue:GetJobBookmark",
                "glue:GetJobRun",
                "glue:GetJobRuns",
                "glue:GetJobs",
                "glue:GetMapping",
                "glue:GetMLTaskRun",
                "glue:GetMLTaskRuns",
                "glue:GetMLTransform",
                "glue:GetMLTransforms",
                "glue:GetPartition",
                "glue:GetPartitions",
                "glue:GetPlan",
                "glue:GetRegistry",
                "glue:GetResourcePolicy",
                "glue:GetSchema",
                "glue:GetSchemaByDefinition",
                "glue:GetSchemaVersion",
                "glue:GetSchemaVersionsDiff",
                "glue:GetSecurityConfiguration",
                "glue:GetSecurityConfigurations",
                "glue:GetTable",
                "glue:GetTables",
                "glue:GetTableVersion",
                "glue:GetTableVersions",
                "glue:GetTags",
                "glue:GetTags",
                "glue:GetTrigger",
                "glue:GetTriggers",
                "glue:GetUserDefinedFunction",
                "glue:GetUserDefinedFunctions",
                "glue:GetWorkflow",
                "glue:GetWorkflowRun",
                "glue:GetWorkflowRunProperties",
                "glue:GetWorkflowRuns",
                "glue:ListCrawlers",
                "glue:ListDevEndpoints",
                "glue:ListJobs",
                "glue:ListMLTransforms",
                "glue:ListRegistries",
                "glue:ListSchemas",
                "glue:ListSchemaVersions",
                "glue:ListTriggers",
                "glue:ListWorkflows",
                "glue:QuerySchemaVersionMetadata",
                "greengrass:DescribeComponent",
                "greengrass:Get*",
                "greengrass:List*",
                "guardduty:DescribeOrganizationConfiguration",
                "guardduty:DescribePublishingDestination",
                "guardduty:Get*",
                "guardduty:List*",
                "health:Describe*",
                "iam:Generate*",
                "iam:Get*",
                "iam:List*",
                "iam:Simulate*",
                "imagebuilder:Get*",
                "imagebuilder:List*",
                "importexport:Get*",
                "importexport:List*",
                "inspector:Describe*",
                "inspector:Get*",
                "inspector:List*",
                "inspector:Preview*",
                "iot:Describe*",
                "iot:Get*",
                "iot:List*",
                "iotanalytics:Describe*",
                "iotanalytics:Get*",
                "iotanalytics:List*",
                "iotanalytics:SampleChannelData",
                "iotfleethub:DescribeApplication",
                "iotfleethub:ListApplications",
                "iotsitewise:Describe*",
                "iotsitewise:Get*",
                "iotsitewise:List*",
                "iotwireless:GetDestination",
                "iotwireless:GetDeviceProfile",
                "iotwireless:GetPartnerAccount",
                "iotwireless:GetServiceEndpoint",
                "iotwireless:GetServiceProfile",
                "iotwireless:GetWirelessDevice",
                "iotwireless:GetWirelessDeviceStatistics",
                "iotwireless:GetWirelessGateway",
                "iotwireless:GetWirelessGatewayCertificate",
                "iotwireless:GetWirelessGatewayFirmwareInformation",
                "iotwireless:GetWirelessGatewayStatistics",
                "iotwireless:GetWirelessGatewayTask",
                "iotwireless:GetWirelessGatewayTaskDefinition",
                "iotwireless:ListDestinations",
                "iotwireless:ListDeviceProfiles",
                "iotwireless:ListPartnerAccounts",
                "iotwireless:ListServiceProfiles",
                "iotwireless:ListTagsForResource",
                "iotwireless:ListWirelessDevices",
                "iotwireless:ListWirelessGateways",
                "iotwireless:ListWirelessGatewayTaskDefinitions",
                "ivs:BatchGetChannel",
                "ivs:GetChannel",
                "ivs:GetPlaybackKeyPair",
                "ivs:ListChannels",
                "ivs:ListPlaybackKeyPairs",
                "ivs:ListStreams",
                "ivs:ListTagsForResource",
                "kafka:Describe*",
                "kafka:Get*",
                "kafka:List*",
                "kendra:DescribeDataSource",
                "kendra:DescribeFaq",
                "kendra:DescribeIndex",
                "kendra:DescribeThesaurus",
                "kendra:ListDataSources",
                "kendra:ListDataSourceSyncJobs",
                "kendra:ListFaqs",
                "kendra:ListIndices",
                "kendra:ListTagsForResource",
                "kendra:ListThesauri",
                "kendra:Query",
                "kinesis:Describe*",
                "kinesis:Get*",
                "kinesis:List*",
                "kinesisanalytics:Describe*",
                "kinesisanalytics:Discover*",
                "kinesisanalytics:Get*",
                "kinesisanalytics:List*",
                "kinesisvideo:Describe*",
                "kinesisvideo:Get*",
                "kinesisvideo:List*",
                "kms:Describe*",
                "kms:Get*",
                "kms:List*",
                "lambda:Get*",
                "lambda:List*",
                "lex:Get*",
                "license-manager:Get*",
                "license-manager:List*",
                "lightsail:GetActiveNames",
                "lightsail:GetBlueprints",
                "lightsail:GetBundles",
                "lightsail:GetCloudFormationStackRecords",
                "lightsail:GetDisk",
                "lightsail:GetDisks",
                "lightsail:GetDiskSnapshot",
                "lightsail:GetDiskSnapshots",
                "lightsail:GetDomain",
                "lightsail:GetDomains",
                "lightsail:GetExportSnapshotRecords",
                "lightsail:GetInstance",
                "lightsail:GetInstanceMetricData",
                "lightsail:GetInstancePortStates",
                "lightsail:GetInstances",
                "lightsail:GetInstanceSnapshot",
                "lightsail:GetInstanceSnapshots",
                "lightsail:GetInstanceState",
                "lightsail:GetKeyPair",
                "lightsail:GetKeyPairs",
                "lightsail:GetLoadBalancer",
                "lightsail:GetLoadBalancerMetricData",
                "lightsail:GetLoadBalancers",
                "lightsail:GetLoadBalancerTlsCertificates",
                "lightsail:GetOperation",
                "lightsail:GetOperations",
                "lightsail:GetOperationsForResource",
                "lightsail:GetRegions",
                "lightsail:GetRelationalDatabase",
                "lightsail:GetRelationalDatabaseBlueprints",
                "lightsail:GetRelationalDatabaseBundles",
                "lightsail:GetRelationalDatabaseEvents",
                "lightsail:GetRelationalDatabaseLogEvents",
                "lightsail:GetRelationalDatabaseLogStreams",
                "lightsail:GetRelationalDatabaseMetricData",
                "lightsail:GetRelationalDatabaseParameters",
                "lightsail:GetRelationalDatabases",
                "lightsail:GetRelationalDatabaseSnapshot",
                "lightsail:GetRelationalDatabaseSnapshots",
                "lightsail:GetStaticIp",
                "lightsail:GetStaticIps",
                "lightsail:Is*",
                "logs:Describe*",
                "logs:FilterLogEvents",
                "logs:Get*",
                "logs:ListTagsLogGroup",
                "logs:StartQuery",
                "logs:StopQuery",
                "logs:TestMetricFilter",
                "machinelearning:Describe*",
                "machinelearning:Get*",
                "mediaconvert:DescribeEndpoints",
                "mediaconvert:Get*",
                "mediaconvert:List*",
                "mediapackage:Describe*",
                "mediapackage:List*",
                "mgh:Describe*",
                "mgh:GetHomeRegion",
                "mgh:List*",
                "mobileanalytics:Get*",
                "mobilehub:Describe*",
                "mobilehub:Export*",
                "mobilehub:Generate*",
                "mobilehub:Get*",
                "mobilehub:List*",
                "mobilehub:Validate*",
                "mobilehub:Verify*",
                "mobiletargeting:Get*",
                "mobiletargeting:List*",
                "mq:Describe*",
                "mq:List*",
                "networkmanager:DescribeGlobalNetworks",
                "networkmanager:GetConnections",
                "networkmanager:GetCustomerGatewayAssociations",
                "networkmanager:GetDevices",
                "networkmanager:GetLinkAssociations",
                "networkmanager:GetLinks",
                "networkmanager:GetSites",
                "networkmanager:GetTransitGatewayConnectPeerAssociations",
                "networkmanager:GetTransitGatewayRegistrations",
                "opsworks-cm:Describe*",
                "opsworks-cm:List*",
                "opsworks:Describe*",
                "opsworks:Get*",
                "organizations:Describe*",
                "organizations:List*",
                "outposts:Get*",
                "outposts:List*",
                "personalize:Describe*",
                "personalize:Get*",
                "personalize:List*",
                "pi:DescribeDimensionKeys",
                "pi:GetResourceMetrics",
                "polly:Describe*",
                "polly:Get*",
                "polly:List*",
                "polly:SynthesizeSpeech",
                "qldb:DescribeJournalS3Export",
                "qldb:DescribeLedger",
                "qldb:GetBlock",
                "qldb:GetDigest",
                "qldb:GetRevision",
                "qldb:ListJournalS3Exports",
                "qldb:ListJournalS3ExportsForLedger",
                "qldb:ListLedgers",
                "qldb:ListTagsForResource",
                "ram:Get*",
                "ram:List*",
                "rds:Describe*",
                "rds:Download*",
                "rds:List*",
                "redshift:Describe*",
                "redshift:GetReservedNodeExchangeOfferings",
                "redshift:View*",
                "rekognition:CompareFaces",
                "rekognition:Detect*",
                "rekognition:List*",
                "rekognition:Search*",
                "resource-groups:Get*",
                "resource-groups:List*",
                "resource-groups:Search*",
                "robomaker:BatchDescribe*",
                "robomaker:Describe*",
                "robomaker:Get*",
                "robomaker:List*",
                "route53:Get*",
                "route53:List*",
                "route53:Test*",
                "route53domains:Check*",
                "route53domains:Get*",
                "route53domains:List*",
                "route53domains:View*",
                "route53resolver:Get*",
                "route53resolver:List*",
                "s3:Get*",
                "s3:List*",
                "sagemaker:Describe*",
                "sagemaker:GetSearchSuggestions",
                "sagemaker:List*",
                "sagemaker:Search",
                "savingsplans:DescribeSavingsPlanRates",
                "savingsplans:DescribeSavingsPlans",
                "savingsplans:DescribeSavingsPlansOfferingRates",
                "savingsplans:DescribeSavingsPlansOfferings",
                "savingsplans:ListTagsForResource",
                "schemas:Describe*",
                "schemas:Get*",
                "schemas:List*",
                "schemas:Search*",
                "sdb:Get*",
                "sdb:List*",
                "sdb:Select*",
                "secretsmanager:Describe*",
                "secretsmanager:GetResourcePolicy",
                "secretsmanager:List*",
                "securityhub:Describe*",
                "securityhub:Get*",
                "securityhub:List*",
                "serverlessrepo:Get*",
                "serverlessrepo:List*",
                "serverlessrepo:SearchApplications",
                "servicecatalog:Describe*",
                "servicecatalog:GetApplication",
                "servicecatalog:GetAttributeGroup",
                "servicecatalog:List*",
                "servicecatalog:Scan*",
                "servicecatalog:Search*",
                "servicediscovery:Get*",
                "servicediscovery:List*",
                "servicequotas:GetAssociationForServiceQuotaTemplate",
                "servicequotas:GetAWSDefaultServiceQuota",
                "servicequotas:GetRequestedServiceQuotaChange",
                "servicequotas:GetServiceQuota",
                "servicequotas:GetServiceQuotaIncreaseRequestFromTemplate",
                "servicequotas:ListAWSDefaultServiceQuotas",
                "servicequotas:ListRequestedServiceQuotaChangeHistory",
                "servicequotas:ListRequestedServiceQuotaChangeHistoryByQuota",
                "servicequotas:ListServiceQuotaIncreaseRequestsInTemplate",
                "servicequotas:ListServiceQuotas",
                "servicequotas:ListServices",
                "ses:Describe*",
                "ses:Get*",
                "ses:List*",
                "shield:Describe*",
                "shield:Get*",
                "shield:List*",
                "signer:DescribeSigningJob",
                "signer:GetSigningPlatform",
                "signer:GetSigningProfile",
                "signer:ListProfilePermissions",
                "signer:ListSigningJobs",
                "signer:ListSigningPlatforms",
                "signer:ListSigningProfiles",
                "signer:ListTagsForResource",
                "snowball:Describe*",
                "snowball:Get*",
                "snowball:List*",
                "sns:Check*",
                "sns:Get*",
                "sns:List*",
                "sqs:Get*",
                "sqs:List*",
                "sqs:Receive*",
                "ssm:Describe*",
                "ssm:Get*",
                "ssm:List*",
                "sso-directory:Describe*",
                "sso-directory:List*",
                "sso-directory:Search*",
                "sso:Describe*",
                "sso:Get*",
                "sso:List*",
                "sso:Search*",
                "states:Describe*",
                "states:GetExecutionHistory",
                "states:List*",
                "storagegateway:Describe*",
                "storagegateway:List*",
                "sts:GetAccessKeyInfo",
                "sts:GetCallerIdentity",
                "sts:GetSessionToken",
                "swf:Count*",
                "swf:Describe*",
                "swf:Get*",
                "swf:List*",
                "synthetics:Describe*",
                "synthetics:Get*",
                "synthetics:List*",
                "tag:Get*",
                "transcribe:Get*",
                "transcribe:List*",
                "transfer:Describe*",
                "transfer:List*",
                "transfer:TestIdentityProvider",
                "trustedadvisor:Describe*",
                "waf-regional:Get*",
                "waf-regional:List*",
                "waf:Get*",
                "waf:List*",
                "wafv2:CheckCapacity",
                "wafv2:Describe*",
                "wafv2:Get*",
                "wafv2:List*",
                "workdocs:CheckAlias",
                "workdocs:Describe*",
                "workdocs:Get*",
                "worklink:Describe*",
                "worklink:List*",
                "workmail:Describe*",
                "workmail:Get*",
                "workmail:List*",
                "workmail:Search*",
                "workspaces:Describe*",
                "xray:BatchGet*",
                "xray:Get*"
            ],
            "Effect": "Allow",
            "Resource": "*"
        }
    ]
}
        
    

leanix_policies = {
    "LeanIXCloudScanBillingPolicyReader": LeanIXCloudScanBillingPolicyReader,
    "LeanIXCloudScanAdvisorPolicyReader": LeanIXCloudScanAdvisorPolicyReader,
    "arn:aws:iam::aws:policy/ReadOnlyAccess": ReadOnlyAccess

}
