"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientAttributes = exports.DateTimeAttribute = exports.BooleanAttribute = exports.NumberAttribute = exports.StringAttribute = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const attr_names_1 = require("./private/attr-names");
/**
 * The String custom attribute type.
 */
class StringAttribute {
    constructor(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_cognito_StringAttributeProps(props);
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
_a = JSII_RTTI_SYMBOL_1;
StringAttribute[_a] = { fqn: "@aws-cdk/aws-cognito.StringAttribute", version: "1.151.0" };
/**
 * The Number custom attribute type.
 */
class NumberAttribute {
    constructor(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_cognito_NumberAttributeProps(props);
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
_b = JSII_RTTI_SYMBOL_1;
NumberAttribute[_b] = { fqn: "@aws-cdk/aws-cognito.NumberAttribute", version: "1.151.0" };
/**
 * The Boolean custom attribute type.
 */
class BooleanAttribute {
    constructor(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_cognito_CustomAttributeProps(props);
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
_c = JSII_RTTI_SYMBOL_1;
BooleanAttribute[_c] = { fqn: "@aws-cdk/aws-cognito.BooleanAttribute", version: "1.151.0" };
/**
 * The DateTime custom attribute type.
 */
class DateTimeAttribute {
    constructor(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_cognito_CustomAttributeProps(props);
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
_d = JSII_RTTI_SYMBOL_1;
DateTimeAttribute[_d] = { fqn: "@aws-cdk/aws-cognito.DateTimeAttribute", version: "1.151.0" };
/**
 * A set of attributes, useful to set Read and Write attributes
 */
class ClientAttributes {
    /**
     * Creates a ClientAttributes with the specified attributes
     *
     * @default - a ClientAttributes object without any attributes
     */
    constructor() {
        this.attributesSet = new Set();
    }
    /**
     * Creates a custom ClientAttributes with the specified attributes
     * @param attributes a list of standard attributes to add to the set
     */
    withStandardAttributes(attributes) {
        jsiiDeprecationWarnings._aws_cdk_aws_cognito_StandardAttributesMask(attributes);
        let attributesSet = new Set(this.attributesSet);
        // iterate through key-values in the `StandardAttributeNames` constant
        // to get the value for all attributes
        for (const attributeKey in attr_names_1.StandardAttributeNames) {
            if (attributes[attributeKey] === true) {
                const attributeName = attr_names_1.StandardAttributeNames[attributeKey];
                attributesSet.add(attributeName);
            }
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * Creates a custom ClientAttributes with the specified attributes
     * @param attributes a list of custom attributes to add to the set
     */
    withCustomAttributes(...attributes) {
        let attributesSet = new Set(this.attributesSet);
        for (let attribute of attributes) {
            // custom attributes MUST begin with `custom:`, so add the string if not present
            if (!attribute.startsWith('custom:')) {
                attribute = 'custom:' + attribute;
            }
            attributesSet.add(attribute);
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * The list of attributes represented by this ClientAttributes
     */
    attributes() {
        // sorting is unnecessary but it simplify testing
        return Array.from(this.attributesSet).sort();
    }
}
exports.ClientAttributes = ClientAttributes;
_e = JSII_RTTI_SYMBOL_1;
ClientAttributes[_e] = { fqn: "@aws-cdk/aws-cognito.ClientAttributes", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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