# AUTOGENERATED! DO NOT EDIT! File to edit: ../01_deck.ipynb.

# %% auto 0
__all__ = ['Deck', 'draw_n']

# %% ../01_deck.ipynb 5
from .card import *
from fastcore.utils import *
import random


# %% ../01_deck.ipynb 6
class Deck:
    def __init__(self): self.cards = [Card(s, r) for s in range(4) for r in range(1, 14)]
    def __len__(self): return len(self.cards)
    def __str__(self): return '; '.join(map(str, self.cards))
    def __contains__(self, card): return card in self.cards
    __repr__ = __str__

# %% ../01_deck.ipynb 17
@patch
def pop(self:Deck,
        idx:int=-1): # 지우려는 카드의 인덱스. 기본값은 덱의 마지막 카드 인덱스
    "덱에서 인덱스에 해당되는 카드를 없애고 그 카드를 반환한다."
    return self.cards.pop(idx)

# %% ../01_deck.ipynb 22
@patch
def remove(self:Deck,
           card:Card): # 없애려는 카드
    "덱에서 `card`를 없애고, 그 카드가 덱에 없었다면 예외를 발생시킨다."
    self.cards.remove(card)

# %% ../01_deck.ipynb 25
@patch
def shuffle(self:Deck):
    "덱을 섞는다."
    random.shuffle(self.cards)
    
def draw_n(n:int, # 뽑으려는 카드의 개수
           replace:bool=True): # 복원 추출 여부
    "`n`개의 카드를 추출. `replace`가 `True`일 경우 복원 추출."
    d = Deck()
    d.shuffle()
    if replace: return [ d.cards[random.choice(range(len(d.cards)))] for _ in range(n)]
    else: return d.cards[:n]
