import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { IAMServiceException as __BaseException } from "./IAMServiceException";
export class KeyPairMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "KeyPairMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "KeyPairMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, KeyPairMismatchException.prototype);
    }
}
export class MalformedCertificateException extends __BaseException {
    constructor(opts) {
        super({
            name: "MalformedCertificateException",
            $fault: "client",
            ...opts,
        });
        this.name = "MalformedCertificateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MalformedCertificateException.prototype);
    }
}
export class DuplicateCertificateException extends __BaseException {
    constructor(opts) {
        super({
            name: "DuplicateCertificateException",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateCertificateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateCertificateException.prototype);
    }
}
export class InvalidCertificateException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidCertificateException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidCertificateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidCertificateException.prototype);
    }
}
export class DuplicateSSHPublicKeyException extends __BaseException {
    constructor(opts) {
        super({
            name: "DuplicateSSHPublicKeyException",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateSSHPublicKeyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateSSHPublicKeyException.prototype);
    }
}
export class InvalidPublicKeyException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPublicKeyException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPublicKeyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPublicKeyException.prototype);
    }
}
export const UntagPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagSAMLProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagServerCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateAccessKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateAccountPasswordPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateAssumeRolePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateLoginProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Password && { Password: SENSITIVE_STRING }),
});
export const UpdateOpenIDConnectProviderThumbprintRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateRoleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateRoleDescriptionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateRoleDescriptionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSAMLProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSAMLProviderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateServerCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateServiceSpecificCredentialRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSigningCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSSHPublicKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UploadServerCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PrivateKey && { PrivateKey: SENSITIVE_STRING }),
});
export const UploadServerCertificateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UploadSigningCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UploadSigningCertificateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UploadSSHPublicKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UploadSSHPublicKeyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
