import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { IAMServiceException as __BaseException } from "./IAMServiceException";
export var AccessAdvisorUsageGranularityType;
(function (AccessAdvisorUsageGranularityType) {
    AccessAdvisorUsageGranularityType["ACTION_LEVEL"] = "ACTION_LEVEL";
    AccessAdvisorUsageGranularityType["SERVICE_LEVEL"] = "SERVICE_LEVEL";
})(AccessAdvisorUsageGranularityType || (AccessAdvisorUsageGranularityType = {}));
export var StatusType;
(function (StatusType) {
    StatusType["Active"] = "Active";
    StatusType["Inactive"] = "Inactive";
})(StatusType || (StatusType = {}));
export class InvalidInputException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInputException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInputException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInputException.prototype);
    }
}
export class LimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
    }
}
export class NoSuchEntityException extends __BaseException {
    constructor(opts) {
        super({
            name: "NoSuchEntityException",
            $fault: "client",
            ...opts,
        });
        this.name = "NoSuchEntityException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NoSuchEntityException.prototype);
    }
}
export class ServiceFailureException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
    }
}
export class EntityAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "EntityAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "EntityAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, EntityAlreadyExistsException.prototype);
    }
}
export class UnmodifiableEntityException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnmodifiableEntityException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnmodifiableEntityException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnmodifiableEntityException.prototype);
    }
}
export var AssignmentStatusType;
(function (AssignmentStatusType) {
    AssignmentStatusType["Any"] = "Any";
    AssignmentStatusType["Assigned"] = "Assigned";
    AssignmentStatusType["Unassigned"] = "Unassigned";
})(AssignmentStatusType || (AssignmentStatusType = {}));
export var PermissionsBoundaryAttachmentType;
(function (PermissionsBoundaryAttachmentType) {
    PermissionsBoundaryAttachmentType["Policy"] = "PermissionsBoundaryPolicy";
})(PermissionsBoundaryAttachmentType || (PermissionsBoundaryAttachmentType = {}));
export class PolicyNotAttachableException extends __BaseException {
    constructor(opts) {
        super({
            name: "PolicyNotAttachableException",
            $fault: "client",
            ...opts,
        });
        this.name = "PolicyNotAttachableException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PolicyNotAttachableException.prototype);
    }
}
export class EntityTemporarilyUnmodifiableException extends __BaseException {
    constructor(opts) {
        super({
            name: "EntityTemporarilyUnmodifiableException",
            $fault: "client",
            ...opts,
        });
        this.name = "EntityTemporarilyUnmodifiableException";
        this.$fault = "client";
        Object.setPrototypeOf(this, EntityTemporarilyUnmodifiableException.prototype);
    }
}
export class InvalidUserTypeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidUserTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidUserTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidUserTypeException.prototype);
    }
}
export class PasswordPolicyViolationException extends __BaseException {
    constructor(opts) {
        super({
            name: "PasswordPolicyViolationException",
            $fault: "client",
            ...opts,
        });
        this.name = "PasswordPolicyViolationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PasswordPolicyViolationException.prototype);
    }
}
export class ConcurrentModificationException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConcurrentModificationException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConcurrentModificationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConcurrentModificationException.prototype);
    }
}
export class MalformedPolicyDocumentException extends __BaseException {
    constructor(opts) {
        super({
            name: "MalformedPolicyDocumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "MalformedPolicyDocumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MalformedPolicyDocumentException.prototype);
    }
}
export class ServiceNotSupportedException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceNotSupportedException",
            $fault: "client",
            ...opts,
        });
        this.name = "ServiceNotSupportedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ServiceNotSupportedException.prototype);
    }
}
export class DeleteConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "DeleteConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "DeleteConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DeleteConflictException.prototype);
    }
}
export class InvalidAuthenticationCodeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAuthenticationCodeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAuthenticationCodeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAuthenticationCodeException.prototype);
    }
}
export var ReportStateType;
(function (ReportStateType) {
    ReportStateType["COMPLETE"] = "COMPLETE";
    ReportStateType["INPROGRESS"] = "INPROGRESS";
    ReportStateType["STARTED"] = "STARTED";
})(ReportStateType || (ReportStateType = {}));
export class ReportGenerationLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ReportGenerationLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ReportGenerationLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ReportGenerationLimitExceededException.prototype);
    }
}
export var EntityType;
(function (EntityType) {
    EntityType["AWSManagedPolicy"] = "AWSManagedPolicy";
    EntityType["Group"] = "Group";
    EntityType["LocalManagedPolicy"] = "LocalManagedPolicy";
    EntityType["Role"] = "Role";
    EntityType["User"] = "User";
})(EntityType || (EntityType = {}));
export var SummaryKeyType;
(function (SummaryKeyType) {
    SummaryKeyType["AccessKeysPerUserQuota"] = "AccessKeysPerUserQuota";
    SummaryKeyType["AccountAccessKeysPresent"] = "AccountAccessKeysPresent";
    SummaryKeyType["AccountMFAEnabled"] = "AccountMFAEnabled";
    SummaryKeyType["AccountSigningCertificatesPresent"] = "AccountSigningCertificatesPresent";
    SummaryKeyType["AttachedPoliciesPerGroupQuota"] = "AttachedPoliciesPerGroupQuota";
    SummaryKeyType["AttachedPoliciesPerRoleQuota"] = "AttachedPoliciesPerRoleQuota";
    SummaryKeyType["AttachedPoliciesPerUserQuota"] = "AttachedPoliciesPerUserQuota";
    SummaryKeyType["GlobalEndpointTokenVersion"] = "GlobalEndpointTokenVersion";
    SummaryKeyType["GroupPolicySizeQuota"] = "GroupPolicySizeQuota";
    SummaryKeyType["Groups"] = "Groups";
    SummaryKeyType["GroupsPerUserQuota"] = "GroupsPerUserQuota";
    SummaryKeyType["GroupsQuota"] = "GroupsQuota";
    SummaryKeyType["MFADevices"] = "MFADevices";
    SummaryKeyType["MFADevicesInUse"] = "MFADevicesInUse";
    SummaryKeyType["Policies"] = "Policies";
    SummaryKeyType["PoliciesQuota"] = "PoliciesQuota";
    SummaryKeyType["PolicySizeQuota"] = "PolicySizeQuota";
    SummaryKeyType["PolicyVersionsInUse"] = "PolicyVersionsInUse";
    SummaryKeyType["PolicyVersionsInUseQuota"] = "PolicyVersionsInUseQuota";
    SummaryKeyType["ServerCertificates"] = "ServerCertificates";
    SummaryKeyType["ServerCertificatesQuota"] = "ServerCertificatesQuota";
    SummaryKeyType["SigningCertificatesPerUserQuota"] = "SigningCertificatesPerUserQuota";
    SummaryKeyType["UserPolicySizeQuota"] = "UserPolicySizeQuota";
    SummaryKeyType["Users"] = "Users";
    SummaryKeyType["UsersQuota"] = "UsersQuota";
    SummaryKeyType["VersionsPerPolicyQuota"] = "VersionsPerPolicyQuota";
})(SummaryKeyType || (SummaryKeyType = {}));
export class CredentialReportExpiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "CredentialReportExpiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "CredentialReportExpiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CredentialReportExpiredException.prototype);
    }
}
export class CredentialReportNotPresentException extends __BaseException {
    constructor(opts) {
        super({
            name: "CredentialReportNotPresentException",
            $fault: "client",
            ...opts,
        });
        this.name = "CredentialReportNotPresentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CredentialReportNotPresentException.prototype);
    }
}
export class CredentialReportNotReadyException extends __BaseException {
    constructor(opts) {
        super({
            name: "CredentialReportNotReadyException",
            $fault: "client",
            ...opts,
        });
        this.name = "CredentialReportNotReadyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CredentialReportNotReadyException.prototype);
    }
}
export var ReportFormatType;
(function (ReportFormatType) {
    ReportFormatType["text_csv"] = "text/csv";
})(ReportFormatType || (ReportFormatType = {}));
export var SortKeyType;
(function (SortKeyType) {
    SortKeyType["LAST_AUTHENTICATED_TIME_ASCENDING"] = "LAST_AUTHENTICATED_TIME_ASCENDING";
    SortKeyType["LAST_AUTHENTICATED_TIME_DESCENDING"] = "LAST_AUTHENTICATED_TIME_DESCENDING";
    SortKeyType["SERVICE_NAMESPACE_ASCENDING"] = "SERVICE_NAMESPACE_ASCENDING";
    SortKeyType["SERVICE_NAMESPACE_DESCENDING"] = "SERVICE_NAMESPACE_DESCENDING";
})(SortKeyType || (SortKeyType = {}));
export var JobStatusType;
(function (JobStatusType) {
    JobStatusType["COMPLETED"] = "COMPLETED";
    JobStatusType["FAILED"] = "FAILED";
    JobStatusType["IN_PROGRESS"] = "IN_PROGRESS";
})(JobStatusType || (JobStatusType = {}));
export var PolicyOwnerEntityType;
(function (PolicyOwnerEntityType) {
    PolicyOwnerEntityType["GROUP"] = "GROUP";
    PolicyOwnerEntityType["ROLE"] = "ROLE";
    PolicyOwnerEntityType["USER"] = "USER";
})(PolicyOwnerEntityType || (PolicyOwnerEntityType = {}));
export var DeletionTaskStatusType;
(function (DeletionTaskStatusType) {
    DeletionTaskStatusType["FAILED"] = "FAILED";
    DeletionTaskStatusType["IN_PROGRESS"] = "IN_PROGRESS";
    DeletionTaskStatusType["NOT_STARTED"] = "NOT_STARTED";
    DeletionTaskStatusType["SUCCEEDED"] = "SUCCEEDED";
})(DeletionTaskStatusType || (DeletionTaskStatusType = {}));
export var EncodingType;
(function (EncodingType) {
    EncodingType["PEM"] = "PEM";
    EncodingType["SSH"] = "SSH";
})(EncodingType || (EncodingType = {}));
export class UnrecognizedPublicKeyEncodingException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnrecognizedPublicKeyEncodingException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnrecognizedPublicKeyEncodingException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnrecognizedPublicKeyEncodingException.prototype);
    }
}
export var PolicyUsageType;
(function (PolicyUsageType) {
    PolicyUsageType["PermissionsBoundary"] = "PermissionsBoundary";
    PolicyUsageType["PermissionsPolicy"] = "PermissionsPolicy";
})(PolicyUsageType || (PolicyUsageType = {}));
export var PolicyScopeType;
(function (PolicyScopeType) {
    PolicyScopeType["AWS"] = "AWS";
    PolicyScopeType["All"] = "All";
    PolicyScopeType["Local"] = "Local";
})(PolicyScopeType || (PolicyScopeType = {}));
export var PolicyType;
(function (PolicyType) {
    PolicyType["INLINE"] = "INLINE";
    PolicyType["MANAGED"] = "MANAGED";
})(PolicyType || (PolicyType = {}));
export var GlobalEndpointTokenVersion;
(function (GlobalEndpointTokenVersion) {
    GlobalEndpointTokenVersion["v1Token"] = "v1Token";
    GlobalEndpointTokenVersion["v2Token"] = "v2Token";
})(GlobalEndpointTokenVersion || (GlobalEndpointTokenVersion = {}));
export class PolicyEvaluationException extends __BaseException {
    constructor(opts) {
        super({
            name: "PolicyEvaluationException",
            $fault: "server",
            ...opts,
        });
        this.name = "PolicyEvaluationException";
        this.$fault = "server";
        Object.setPrototypeOf(this, PolicyEvaluationException.prototype);
    }
}
export var ContextKeyTypeEnum;
(function (ContextKeyTypeEnum) {
    ContextKeyTypeEnum["BINARY"] = "binary";
    ContextKeyTypeEnum["BINARY_LIST"] = "binaryList";
    ContextKeyTypeEnum["BOOLEAN"] = "boolean";
    ContextKeyTypeEnum["BOOLEAN_LIST"] = "booleanList";
    ContextKeyTypeEnum["DATE"] = "date";
    ContextKeyTypeEnum["DATE_LIST"] = "dateList";
    ContextKeyTypeEnum["IP"] = "ip";
    ContextKeyTypeEnum["IP_LIST"] = "ipList";
    ContextKeyTypeEnum["NUMERIC"] = "numeric";
    ContextKeyTypeEnum["NUMERIC_LIST"] = "numericList";
    ContextKeyTypeEnum["STRING"] = "string";
    ContextKeyTypeEnum["STRING_LIST"] = "stringList";
})(ContextKeyTypeEnum || (ContextKeyTypeEnum = {}));
export var PolicyEvaluationDecisionType;
(function (PolicyEvaluationDecisionType) {
    PolicyEvaluationDecisionType["ALLOWED"] = "allowed";
    PolicyEvaluationDecisionType["EXPLICIT_DENY"] = "explicitDeny";
    PolicyEvaluationDecisionType["IMPLICIT_DENY"] = "implicitDeny";
})(PolicyEvaluationDecisionType || (PolicyEvaluationDecisionType = {}));
export var PolicySourceType;
(function (PolicySourceType) {
    PolicySourceType["AWS_MANAGED"] = "aws-managed";
    PolicySourceType["GROUP"] = "group";
    PolicySourceType["NONE"] = "none";
    PolicySourceType["RESOURCE"] = "resource";
    PolicySourceType["ROLE"] = "role";
    PolicySourceType["USER"] = "user";
    PolicySourceType["USER_MANAGED"] = "user-managed";
})(PolicySourceType || (PolicySourceType = {}));
export const AccessDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AccessKeyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SecretAccessKey && { SecretAccessKey: SENSITIVE_STRING }),
});
export const AccessKeyLastUsedFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AccessKeyMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AddClientIDToOpenIDConnectProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AddRoleToInstanceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AddUserToGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttachedPermissionsBoundaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttachedPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttachGroupPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttachRolePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttachUserPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ChangePasswordRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OldPassword && { OldPassword: SENSITIVE_STRING }),
    ...(obj.NewPassword && { NewPassword: SENSITIVE_STRING }),
});
export const CreateAccessKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAccessKeyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AccessKey && { AccessKey: AccessKeyFilterSensitiveLog(obj.AccessKey) }),
});
export const CreateAccountAliasRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateInstanceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RoleLastUsedFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RoleFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceProfileFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateInstanceProfileResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateLoginProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Password && { Password: SENSITIVE_STRING }),
});
export const LoginProfileFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateLoginProfileResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateOpenIDConnectProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateOpenIDConnectProviderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreatePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PolicyFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreatePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreatePolicyVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PolicyVersionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreatePolicyVersionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateRoleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSAMLProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSAMLProviderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateServiceLinkedRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateServiceLinkedRoleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateServiceSpecificCredentialRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ServiceSpecificCredentialFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ServicePassword && { ServicePassword: SENSITIVE_STRING }),
});
export const CreateServiceSpecificCredentialResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ServiceSpecificCredential && {
        ServiceSpecificCredential: ServiceSpecificCredentialFilterSensitiveLog(obj.ServiceSpecificCredential),
    }),
});
export const CreateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UserFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVirtualMFADeviceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VirtualMFADeviceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Base32StringSeed && { Base32StringSeed: SENSITIVE_STRING }),
    ...(obj.QRCodePNG && { QRCodePNG: SENSITIVE_STRING }),
});
export const CreateVirtualMFADeviceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VirtualMFADevice && { VirtualMFADevice: VirtualMFADeviceFilterSensitiveLog(obj.VirtualMFADevice) }),
});
export const DeactivateMFADeviceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAccessKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAccountAliasRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteGroupPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteInstanceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteLoginProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteOpenIDConnectProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeletePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeletePolicyVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteRolePermissionsBoundaryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteRolePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSAMLProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteServerCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteServiceLinkedRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteServiceLinkedRoleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteServiceSpecificCredentialRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSigningCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSSHPublicKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteUserPermissionsBoundaryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteUserPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVirtualMFADeviceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DetachGroupPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DetachRolePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DetachUserPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EnableMFADeviceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GenerateCredentialReportResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GenerateOrganizationsAccessReportRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GenerateOrganizationsAccessReportResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GenerateServiceLastAccessedDetailsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GenerateServiceLastAccessedDetailsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccessKeyLastUsedRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccessKeyLastUsedResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountAuthorizationDetailsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PolicyDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GroupDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ManagedPolicyDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RoleDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UserDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountAuthorizationDetailsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PasswordPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountPasswordPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountSummaryResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetContextKeysForCustomPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetContextKeysForPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetContextKeysForPrincipalPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetCredentialReportResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetGroupPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetGroupPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetInstanceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetInstanceProfileResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLoginProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetLoginProfileResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOpenIDConnectProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOpenIDConnectProviderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOrganizationsAccessReportRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ErrorDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOrganizationsAccessReportResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPolicyVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPolicyVersionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetRoleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetRolePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetRolePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSAMLProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSAMLProviderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServerCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ServerCertificateMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ServerCertificateFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServerCertificateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceLastAccessedDetailsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TrackedActionLastAccessedFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ServiceLastAccessedFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceLastAccessedDetailsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceLastAccessedDetailsWithEntitiesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EntityInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EntityDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceLastAccessedDetailsWithEntitiesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceLinkedRoleDeletionStatusRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RoleUsageTypeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeletionTaskFailureReasonTypeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceLinkedRoleDeletionStatusResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSSHPublicKeyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SSHPublicKeyFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSSHPublicKeyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetUserPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetUserPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAccessKeysRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAccessKeysResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAccountAliasesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAccountAliasesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAttachedGroupPoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAttachedGroupPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAttachedRolePoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAttachedRolePoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAttachedUserPoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAttachedUserPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListEntitiesForPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PolicyGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PolicyRoleFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PolicyUserFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListEntitiesForPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListGroupPoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListGroupPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListGroupsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListGroupsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListGroupsForUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListGroupsForUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInstanceProfilesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInstanceProfilesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInstanceProfilesForRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInstanceProfilesForRoleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInstanceProfileTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInstanceProfileTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListMFADevicesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MFADeviceFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListMFADevicesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListMFADeviceTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListMFADeviceTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpenIDConnectProvidersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpenIDConnectProviderListEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpenIDConnectProvidersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpenIDConnectProviderTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpenIDConnectProviderTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPoliciesGrantingServiceAccessRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PolicyGrantingServiceAccessFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPoliciesGrantingServiceAccessEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPoliciesGrantingServiceAccessResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPolicyTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPolicyTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPolicyVersionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPolicyVersionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListRolePoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListRolePoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListRolesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListRolesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListRoleTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListRoleTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSAMLProvidersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SAMLProviderListEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSAMLProvidersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSAMLProviderTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSAMLProviderTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListServerCertificatesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListServerCertificatesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListServerCertificateTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListServerCertificateTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListServiceSpecificCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ServiceSpecificCredentialMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListServiceSpecificCredentialsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSigningCertificatesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SigningCertificateFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSigningCertificatesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSSHPublicKeysRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SSHPublicKeyMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSSHPublicKeysResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListUserPoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListUserPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListUsersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListUsersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListUserTagsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListUserTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVirtualMFADevicesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVirtualMFADevicesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VirtualMFADevices && {
        VirtualMFADevices: obj.VirtualMFADevices.map((item) => VirtualMFADeviceFilterSensitiveLog(item)),
    }),
});
export const PutGroupPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutRolePermissionsBoundaryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutRolePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutUserPermissionsBoundaryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutUserPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RemoveClientIDFromOpenIDConnectProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RemoveRoleFromInstanceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RemoveUserFromGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResetServiceSpecificCredentialRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResetServiceSpecificCredentialResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ServiceSpecificCredential && {
        ServiceSpecificCredential: ServiceSpecificCredentialFilterSensitiveLog(obj.ServiceSpecificCredential),
    }),
});
export const ResyncMFADeviceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetDefaultPolicyVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SetSecurityTokenServicePreferencesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ContextEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SimulateCustomPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PositionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StatementFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OrganizationsDecisionDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PermissionsBoundaryDecisionDetailFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceSpecificResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EvaluationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SimulatePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SimulatePrincipalPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagInstanceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagMFADeviceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagOpenIDConnectProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagRoleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagSAMLProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagServerCertificateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagInstanceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagMFADeviceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagOpenIDConnectProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
