"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilRoleExists = exports.waitForRoleExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const GetRoleCommand_1 = require("../commands/GetRoleCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetRoleCommand_1.GetRoleCommand(input));
        reason = result;
        return { state: util_waiter_1.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NoSuchEntity") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForRoleExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForRoleExists = waitForRoleExists;
const waitUntilRoleExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilRoleExists = waitUntilRoleExists;
