import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  SearchTransitGatewayRoutesRequest,
  SearchTransitGatewayRoutesResult,
} from "../models/models_6";
export interface SearchTransitGatewayRoutesCommandInput
  extends SearchTransitGatewayRoutesRequest {}
export interface SearchTransitGatewayRoutesCommandOutput
  extends SearchTransitGatewayRoutesResult,
    __MetadataBearer {}
export declare class SearchTransitGatewayRoutesCommand extends $Command<
  SearchTransitGatewayRoutesCommandInput,
  SearchTransitGatewayRoutesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: SearchTransitGatewayRoutesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: SearchTransitGatewayRoutesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    SearchTransitGatewayRoutesCommandInput,
    SearchTransitGatewayRoutesCommandOutput
  >;
  private serialize;
  private deserialize;
}
