import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ModifyPrivateDnsNameOptionsRequest,
  ModifyPrivateDnsNameOptionsResult,
} from "../models/models_6";
export interface ModifyPrivateDnsNameOptionsCommandInput
  extends ModifyPrivateDnsNameOptionsRequest {}
export interface ModifyPrivateDnsNameOptionsCommandOutput
  extends ModifyPrivateDnsNameOptionsResult,
    __MetadataBearer {}
export declare class ModifyPrivateDnsNameOptionsCommand extends $Command<
  ModifyPrivateDnsNameOptionsCommandInput,
  ModifyPrivateDnsNameOptionsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ModifyPrivateDnsNameOptionsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ModifyPrivateDnsNameOptionsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ModifyPrivateDnsNameOptionsCommandInput,
    ModifyPrivateDnsNameOptionsCommandOutput
  >;
  private serialize;
  private deserialize;
}
