import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetVerifiedAccessEndpointPolicyRequest,
  GetVerifiedAccessEndpointPolicyResult,
} from "../models/models_5";
export interface GetVerifiedAccessEndpointPolicyCommandInput
  extends GetVerifiedAccessEndpointPolicyRequest {}
export interface GetVerifiedAccessEndpointPolicyCommandOutput
  extends GetVerifiedAccessEndpointPolicyResult,
    __MetadataBearer {}
export declare class GetVerifiedAccessEndpointPolicyCommand extends $Command<
  GetVerifiedAccessEndpointPolicyCommandInput,
  GetVerifiedAccessEndpointPolicyCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetVerifiedAccessEndpointPolicyCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetVerifiedAccessEndpointPolicyCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetVerifiedAccessEndpointPolicyCommandInput,
    GetVerifiedAccessEndpointPolicyCommandOutput
  >;
  private serialize;
  private deserialize;
}
