import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetSpotPlacementScoresRequest,
  GetSpotPlacementScoresResult,
} from "../models/models_5";
export interface GetSpotPlacementScoresCommandInput
  extends GetSpotPlacementScoresRequest {}
export interface GetSpotPlacementScoresCommandOutput
  extends GetSpotPlacementScoresResult,
    __MetadataBearer {}
export declare class GetSpotPlacementScoresCommand extends $Command<
  GetSpotPlacementScoresCommandInput,
  GetSpotPlacementScoresCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetSpotPlacementScoresCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetSpotPlacementScoresCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetSpotPlacementScoresCommandInput,
    GetSpotPlacementScoresCommandOutput
  >;
  private serialize;
  private deserialize;
}
