import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetEbsEncryptionByDefaultRequest,
  GetEbsEncryptionByDefaultResult,
} from "../models/models_5";
export interface GetEbsEncryptionByDefaultCommandInput
  extends GetEbsEncryptionByDefaultRequest {}
export interface GetEbsEncryptionByDefaultCommandOutput
  extends GetEbsEncryptionByDefaultResult,
    __MetadataBearer {}
export declare class GetEbsEncryptionByDefaultCommand extends $Command<
  GetEbsEncryptionByDefaultCommandInput,
  GetEbsEncryptionByDefaultCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetEbsEncryptionByDefaultCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetEbsEncryptionByDefaultCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetEbsEncryptionByDefaultCommandInput,
    GetEbsEncryptionByDefaultCommandOutput
  >;
  private serialize;
  private deserialize;
}
