import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetAssociatedIpv6PoolCidrsRequest,
  GetAssociatedIpv6PoolCidrsResult,
} from "../models/models_5";
export interface GetAssociatedIpv6PoolCidrsCommandInput
  extends GetAssociatedIpv6PoolCidrsRequest {}
export interface GetAssociatedIpv6PoolCidrsCommandOutput
  extends GetAssociatedIpv6PoolCidrsResult,
    __MetadataBearer {}
export declare class GetAssociatedIpv6PoolCidrsCommand extends $Command<
  GetAssociatedIpv6PoolCidrsCommandInput,
  GetAssociatedIpv6PoolCidrsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetAssociatedIpv6PoolCidrsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetAssociatedIpv6PoolCidrsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetAssociatedIpv6PoolCidrsCommandInput,
    GetAssociatedIpv6PoolCidrsCommandOutput
  >;
  private serialize;
  private deserialize;
}
