import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeVpcEndpointServicesRequest,
  DescribeVpcEndpointServicesResult,
} from "../models/models_5";
export interface DescribeVpcEndpointServicesCommandInput
  extends DescribeVpcEndpointServicesRequest {}
export interface DescribeVpcEndpointServicesCommandOutput
  extends DescribeVpcEndpointServicesResult,
    __MetadataBearer {}
export declare class DescribeVpcEndpointServicesCommand extends $Command<
  DescribeVpcEndpointServicesCommandInput,
  DescribeVpcEndpointServicesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeVpcEndpointServicesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeVpcEndpointServicesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeVpcEndpointServicesCommandInput,
    DescribeVpcEndpointServicesCommandOutput
  >;
  private serialize;
  private deserialize;
}
