import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeSecurityGroupsRequest,
  DescribeSecurityGroupsResult,
} from "../models/models_4";
export interface DescribeSecurityGroupsCommandInput
  extends DescribeSecurityGroupsRequest {}
export interface DescribeSecurityGroupsCommandOutput
  extends DescribeSecurityGroupsResult,
    __MetadataBearer {}
export declare class DescribeSecurityGroupsCommand extends $Command<
  DescribeSecurityGroupsCommandInput,
  DescribeSecurityGroupsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeSecurityGroupsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeSecurityGroupsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeSecurityGroupsCommandInput,
    DescribeSecurityGroupsCommandOutput
  >;
  private serialize;
  private deserialize;
}
