import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteManagedPrefixListRequest,
  DeleteManagedPrefixListResult,
} from "../models/models_2";
export interface DeleteManagedPrefixListCommandInput
  extends DeleteManagedPrefixListRequest {}
export interface DeleteManagedPrefixListCommandOutput
  extends DeleteManagedPrefixListResult,
    __MetadataBearer {}
export declare class DeleteManagedPrefixListCommand extends $Command<
  DeleteManagedPrefixListCommandInput,
  DeleteManagedPrefixListCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteManagedPrefixListCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteManagedPrefixListCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteManagedPrefixListCommandInput,
    DeleteManagedPrefixListCommandOutput
  >;
  private serialize;
  private deserialize;
}
