import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteLaunchTemplateRequest,
  DeleteLaunchTemplateResult,
} from "../models/models_2";
export interface DeleteLaunchTemplateCommandInput
  extends DeleteLaunchTemplateRequest {}
export interface DeleteLaunchTemplateCommandOutput
  extends DeleteLaunchTemplateResult,
    __MetadataBearer {}
export declare class DeleteLaunchTemplateCommand extends $Command<
  DeleteLaunchTemplateCommandInput,
  DeleteLaunchTemplateCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteLaunchTemplateCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteLaunchTemplateCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteLaunchTemplateCommandInput,
    DeleteLaunchTemplateCommandOutput
  >;
  private serialize;
  private deserialize;
}
