import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  AcceptAddressTransferRequest,
  AcceptAddressTransferResult,
} from "../models/models_0";
export interface AcceptAddressTransferCommandInput
  extends AcceptAddressTransferRequest {}
export interface AcceptAddressTransferCommandOutput
  extends AcceptAddressTransferResult,
    __MetadataBearer {}
export declare class AcceptAddressTransferCommand extends $Command<
  AcceptAddressTransferCommandInput,
  AcceptAddressTransferCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AcceptAddressTransferCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AcceptAddressTransferCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    AcceptAddressTransferCommandInput,
    AcceptAddressTransferCommandOutput
  >;
  private serialize;
  private deserialize;
}
