import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { StartNetworkInsightsAnalysisRequest, StartNetworkInsightsAnalysisResult } from "../models/models_6";
export interface StartNetworkInsightsAnalysisCommandInput extends StartNetworkInsightsAnalysisRequest {
}
export interface StartNetworkInsightsAnalysisCommandOutput extends StartNetworkInsightsAnalysisResult, __MetadataBearer {
}
/**
 * <p>Starts analyzing the specified path. If the path is reachable, the
 *          operation returns the shortest feasible path.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, StartNetworkInsightsAnalysisCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, StartNetworkInsightsAnalysisCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new StartNetworkInsightsAnalysisCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link StartNetworkInsightsAnalysisCommandInput} for command's `input` shape.
 * @see {@link StartNetworkInsightsAnalysisCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class StartNetworkInsightsAnalysisCommand extends $Command<StartNetworkInsightsAnalysisCommandInput, StartNetworkInsightsAnalysisCommandOutput, EC2ClientResolvedConfig> {
    readonly input: StartNetworkInsightsAnalysisCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: StartNetworkInsightsAnalysisCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<StartNetworkInsightsAnalysisCommandInput, StartNetworkInsightsAnalysisCommandOutput>;
    private serialize;
    private deserialize;
}
