import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RestoreImageFromRecycleBinRequest, RestoreImageFromRecycleBinResult } from "../models/models_6";
export interface RestoreImageFromRecycleBinCommandInput extends RestoreImageFromRecycleBinRequest {
}
export interface RestoreImageFromRecycleBinCommandOutput extends RestoreImageFromRecycleBinResult, __MetadataBearer {
}
/**
 * <p>Restores an AMI from the Recycle Bin. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, RestoreImageFromRecycleBinCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, RestoreImageFromRecycleBinCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new RestoreImageFromRecycleBinCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link RestoreImageFromRecycleBinCommandInput} for command's `input` shape.
 * @see {@link RestoreImageFromRecycleBinCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class RestoreImageFromRecycleBinCommand extends $Command<RestoreImageFromRecycleBinCommandInput, RestoreImageFromRecycleBinCommandOutput, EC2ClientResolvedConfig> {
    readonly input: RestoreImageFromRecycleBinCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: RestoreImageFromRecycleBinCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RestoreImageFromRecycleBinCommandInput, RestoreImageFromRecycleBinCommandOutput>;
    private serialize;
    private deserialize;
}
