import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RequestSpotInstancesRequest, RequestSpotInstancesResult } from "../models/models_6";
export interface RequestSpotInstancesCommandInput extends RequestSpotInstancesRequest {
}
export interface RequestSpotInstancesCommandOutput extends RequestSpotInstancesResult, __MetadataBearer {
}
/**
 * <p>Creates a Spot Instance request.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance requests</a> in
 *             the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
 *          <important>
 *             <p>We strongly discourage using the RequestSpotInstances API because it is a legacy
 *                 API with no planned investment. For options for requesting Spot Instances, see
 *                     <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use">Which
 *                     is the best Spot request method to use?</a> in the
 *                     <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
 *          </important>
 *          <note>
 *             <p>We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, RequestSpotInstancesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, RequestSpotInstancesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new RequestSpotInstancesCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link RequestSpotInstancesCommandInput} for command's `input` shape.
 * @see {@link RequestSpotInstancesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class RequestSpotInstancesCommand extends $Command<RequestSpotInstancesCommandInput, RequestSpotInstancesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: RequestSpotInstancesCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: RequestSpotInstancesCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RequestSpotInstancesCommandInput, RequestSpotInstancesCommandOutput>;
    private serialize;
    private deserialize;
}
