import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetVerifiedAccessGroupPolicyRequest, GetVerifiedAccessGroupPolicyResult } from "../models/models_5";
export interface GetVerifiedAccessGroupPolicyCommandInput extends GetVerifiedAccessGroupPolicyRequest {
}
export interface GetVerifiedAccessGroupPolicyCommandOutput extends GetVerifiedAccessGroupPolicyResult, __MetadataBearer {
}
/**
 * <p>Shows the contents of the Verified Access policy associated with the group.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetVerifiedAccessGroupPolicyCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetVerifiedAccessGroupPolicyCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new GetVerifiedAccessGroupPolicyCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetVerifiedAccessGroupPolicyCommandInput} for command's `input` shape.
 * @see {@link GetVerifiedAccessGroupPolicyCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class GetVerifiedAccessGroupPolicyCommand extends $Command<GetVerifiedAccessGroupPolicyCommandInput, GetVerifiedAccessGroupPolicyCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetVerifiedAccessGroupPolicyCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: GetVerifiedAccessGroupPolicyCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetVerifiedAccessGroupPolicyCommandInput, GetVerifiedAccessGroupPolicyCommandOutput>;
    private serialize;
    private deserialize;
}
