import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisassociateTransitGatewayPolicyTableRequest, DisassociateTransitGatewayPolicyTableResult } from "../models/models_5";
export interface DisassociateTransitGatewayPolicyTableCommandInput extends DisassociateTransitGatewayPolicyTableRequest {
}
export interface DisassociateTransitGatewayPolicyTableCommandOutput extends DisassociateTransitGatewayPolicyTableResult, __MetadataBearer {
}
/**
 * <p>Removes the association between an an attachment and a policy table.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisassociateTransitGatewayPolicyTableCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisassociateTransitGatewayPolicyTableCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DisassociateTransitGatewayPolicyTableCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DisassociateTransitGatewayPolicyTableCommandInput} for command's `input` shape.
 * @see {@link DisassociateTransitGatewayPolicyTableCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DisassociateTransitGatewayPolicyTableCommand extends $Command<DisassociateTransitGatewayPolicyTableCommandInput, DisassociateTransitGatewayPolicyTableCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DisassociateTransitGatewayPolicyTableCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DisassociateTransitGatewayPolicyTableCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DisassociateTransitGatewayPolicyTableCommandInput, DisassociateTransitGatewayPolicyTableCommandOutput>;
    private serialize;
    private deserialize;
}
