import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeVerifiedAccessGroupsRequest, DescribeVerifiedAccessGroupsResult } from "../models/models_4";
export interface DescribeVerifiedAccessGroupsCommandInput extends DescribeVerifiedAccessGroupsRequest {
}
export interface DescribeVerifiedAccessGroupsCommandOutput extends DescribeVerifiedAccessGroupsResult, __MetadataBearer {
}
/**
 * <p>Describe details of existing Verified Access groups.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeVerifiedAccessGroupsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeVerifiedAccessGroupsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DescribeVerifiedAccessGroupsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DescribeVerifiedAccessGroupsCommandInput} for command's `input` shape.
 * @see {@link DescribeVerifiedAccessGroupsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DescribeVerifiedAccessGroupsCommand extends $Command<DescribeVerifiedAccessGroupsCommandInput, DescribeVerifiedAccessGroupsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeVerifiedAccessGroupsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DescribeVerifiedAccessGroupsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeVerifiedAccessGroupsCommandInput, DescribeVerifiedAccessGroupsCommandOutput>;
    private serialize;
    private deserialize;
}
