import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeIpamsRequest, DescribeIpamsResult } from "../models/models_4";
export interface DescribeIpamsCommandInput extends DescribeIpamsRequest {
}
export interface DescribeIpamsCommandOutput extends DescribeIpamsResult, __MetadataBearer {
}
/**
 * <p>Get information about your IPAM pools.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeIpamsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeIpamsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DescribeIpamsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DescribeIpamsCommandInput} for command's `input` shape.
 * @see {@link DescribeIpamsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DescribeIpamsCommand extends $Command<DescribeIpamsCommandInput, DescribeIpamsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeIpamsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DescribeIpamsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeIpamsCommandInput, DescribeIpamsCommandOutput>;
    private serialize;
    private deserialize;
}
