import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteVpcEndpointsRequest, DeleteVpcEndpointsResult } from "../models/models_3";
export interface DeleteVpcEndpointsCommandInput extends DeleteVpcEndpointsRequest {
}
export interface DeleteVpcEndpointsCommandOutput extends DeleteVpcEndpointsResult, __MetadataBearer {
}
/**
 * <p>Deletes the specified VPC endpoints.</p>
 *          <p>When you delete a gateway endpoint, we delete the endpoint routes in the route tables for the endpoint.</p>
 *          <p>When you delete a Gateway Load Balancer endpoint, we delete its endpoint network interfaces.
 *           You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.</p>
 *          <p>When you delete an interface endpoint, we delete its endpoint network interfaces.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteVpcEndpointsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteVpcEndpointsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteVpcEndpointsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteVpcEndpointsCommandInput} for command's `input` shape.
 * @see {@link DeleteVpcEndpointsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteVpcEndpointsCommand extends $Command<DeleteVpcEndpointsCommandInput, DeleteVpcEndpointsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteVpcEndpointsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DeleteVpcEndpointsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteVpcEndpointsCommandInput, DeleteVpcEndpointsCommandOutput>;
    private serialize;
    private deserialize;
}
