import { GetTransitGatewayPolicyTableAssociationsCommand, } from "../commands/GetTransitGatewayPolicyTableAssociationsCommand";
import { EC2 } from "../EC2";
import { EC2Client } from "../EC2Client";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new GetTransitGatewayPolicyTableAssociationsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.getTransitGatewayPolicyTableAssociations(input, ...args);
};
export async function* paginateGetTransitGatewayPolicyTableAssociations(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof EC2) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof EC2Client) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected EC2 | EC2Client");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
