import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetFpgaImageAttributeRequestFilterSensitiveLog, ResetFpgaImageAttributeResultFilterSensitiveLog, } from "../models/models_6";
import { deserializeAws_ec2ResetFpgaImageAttributeCommand, serializeAws_ec2ResetFpgaImageAttributeCommand, } from "../protocols/Aws_ec2";
export class ResetFpgaImageAttributeCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, ResetFpgaImageAttributeCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "ResetFpgaImageAttributeCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: ResetFpgaImageAttributeRequestFilterSensitiveLog,
            outputFilterSensitiveLog: ResetFpgaImageAttributeResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2ResetFpgaImageAttributeCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2ResetFpgaImageAttributeCommand(output, context);
    }
}
