import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssignIpv6AddressesRequestFilterSensitiveLog, AssignIpv6AddressesResultFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_ec2AssignIpv6AddressesCommand, serializeAws_ec2AssignIpv6AddressesCommand, } from "../protocols/Aws_ec2";
export class AssignIpv6AddressesCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, AssignIpv6AddressesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "AssignIpv6AddressesCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: AssignIpv6AddressesRequestFilterSensitiveLog,
            outputFilterSensitiveLog: AssignIpv6AddressesResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2AssignIpv6AddressesCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2AssignIpv6AddressesCommand(output, context);
    }
}
