"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilVpcExists = exports.waitForVpcExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeVpcsCommand_1 = require("../commands/DescribeVpcsCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeVpcsCommand_1.DescribeVpcsCommand(input));
        reason = result;
        return { state: util_waiter_1.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidVpcID.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForVpcExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForVpcExists = waitForVpcExists;
const waitUntilVpcExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilVpcExists = waitUntilVpcExists;
