"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateDescribeVerifiedAccessGroups = void 0;
const DescribeVerifiedAccessGroupsCommand_1 = require("../commands/DescribeVerifiedAccessGroupsCommand");
const EC2_1 = require("../EC2");
const EC2Client_1 = require("../EC2Client");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new DescribeVerifiedAccessGroupsCommand_1.DescribeVerifiedAccessGroupsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.describeVerifiedAccessGroups(input, ...args);
};
async function* paginateDescribeVerifiedAccessGroups(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof EC2_1.EC2) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof EC2Client_1.EC2Client) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected EC2 | EC2Client");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateDescribeVerifiedAccessGroups = paginateDescribeVerifiedAccessGroups;
