"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateDescribeLaunchTemplateVersions = void 0;
const DescribeLaunchTemplateVersionsCommand_1 = require("../commands/DescribeLaunchTemplateVersionsCommand");
const EC2_1 = require("../EC2");
const EC2Client_1 = require("../EC2Client");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new DescribeLaunchTemplateVersionsCommand_1.DescribeLaunchTemplateVersionsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.describeLaunchTemplateVersions(input, ...args);
};
async function* paginateDescribeLaunchTemplateVersions(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof EC2_1.EC2) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof EC2Client_1.EC2Client) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected EC2 | EC2Client");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateDescribeLaunchTemplateVersions = paginateDescribeLaunchTemplateVersions;
