"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseReservedInstancesOfferingCommand = void 0;
const middleware_endpoint_1 = require("@aws-sdk/middleware-endpoint");
const middleware_serde_1 = require("@aws-sdk/middleware-serde");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_6_1 = require("../models/models_6");
const Aws_ec2_1 = require("../protocols/Aws_ec2");
class PurchaseReservedInstancesOfferingCommand extends smithy_client_1.Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, PurchaseReservedInstancesOfferingCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "PurchaseReservedInstancesOfferingCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: models_6_1.PurchaseReservedInstancesOfferingRequestFilterSensitiveLog,
            outputFilterSensitiveLog: models_6_1.PurchaseReservedInstancesOfferingResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return (0, Aws_ec2_1.serializeAws_ec2PurchaseReservedInstancesOfferingCommand)(input, context);
    }
    deserialize(output, context) {
        return (0, Aws_ec2_1.deserializeAws_ec2PurchaseReservedInstancesOfferingCommand)(output, context);
    }
}
exports.PurchaseReservedInstancesOfferingCommand = PurchaseReservedInstancesOfferingCommand;
