'''
# AWS::SystemsManagerSAP Construct Library

<!--BEGIN STABILITY BANNER-->---


![cfn-resources: Stable](https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge)

> All classes with the `Cfn` prefix in this module ([CFN Resources](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) are always stable and safe to use.

---
<!--END STABILITY BANNER-->

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_systemsmanagersap as systemsmanagersap
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for SystemsManagerSAP construct libraries](https://constructs.dev/search?q=systemsmanagersap)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::SystemsManagerSAP resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SystemsManagerSAP.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::SystemsManagerSAP](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SystemsManagerSAP.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/master/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import aws_cdk.core as _aws_cdk_core_f4b25747


@jsii.implements(_aws_cdk_core_f4b25747.IInspectable)
class CfnApplication(
    _aws_cdk_core_f4b25747.CfnResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@aws-cdk/aws-systemsmanagersap.CfnApplication",
):
    '''A CloudFormation ``AWS::SystemsManagerSAP::Application``.

    An SAP application registered with AWS Systems Manager for SAP.

    :cloudformationResource: AWS::SystemsManagerSAP::Application
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        import aws_cdk.aws_systemsmanagersap as systemsmanagersap
        
        cfn_application = systemsmanagersap.CfnApplication(self, "MyCfnApplication",
            application_id="applicationId",
            application_type="applicationType",
        
            # the properties below are optional
            credentials=[systemsmanagersap.CfnApplication.CredentialProperty(
                credential_type="credentialType",
                database_name="databaseName",
                secret_id="secretId"
            )],
            instances=["instances"],
            sap_instance_number="sapInstanceNumber",
            sid="sid",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _aws_cdk_core_f4b25747.Construct,
        id: builtins.str,
        *,
        application_id: builtins.str,
        application_type: builtins.str,
        credentials: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[typing.Union["CfnApplication.CredentialProperty", typing.Dict[builtins.str, typing.Any]], _aws_cdk_core_f4b25747.IResolvable]]]] = None,
        instances: typing.Optional[typing.Sequence[builtins.str]] = None,
        sap_instance_number: typing.Optional[builtins.str] = None,
        sid: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.CfnTag, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SystemsManagerSAP::Application``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param application_id: The ID of the application.
        :param application_type: The type of the application.
        :param credentials: The credentials of the SAP application.
        :param instances: The Amazon EC2 instances on which your SAP application is running.
        :param sap_instance_number: The SAP instance number of the application.
        :param sid: The System ID of the application.
        :param tags: The tags on the application.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__729b7443a11a0a8180e75c67a109cc34d03d21dedd91e684278faaae79865fd5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnApplicationProps(
            application_id=application_id,
            application_type=application_type,
            credentials=credentials,
            instances=instances,
            sap_instance_number=sap_instance_number,
            sid=sid,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _aws_cdk_core_f4b25747.TreeInspector) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d18197a5915204881788adffa24f40d0bc5d0c04caa830906f719da8446a4ffa)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__19658c9ec3ab5ff817fff7be055e02abec4e883e73924ee0dc5ad701b6cb334b)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name of the SAP application.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _aws_cdk_core_f4b25747.TagManager:
        '''The tags on the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-tags
        '''
        return typing.cast(_aws_cdk_core_f4b25747.TagManager, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="applicationId")
    def application_id(self) -> builtins.str:
        '''The ID of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationid
        '''
        return typing.cast(builtins.str, jsii.get(self, "applicationId"))

    @application_id.setter
    def application_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6ed51942a3a4eee1640d79e8f955ac2286de43538a09d85a646d26edb22494d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "applicationId", value)

    @builtins.property
    @jsii.member(jsii_name="applicationType")
    def application_type(self) -> builtins.str:
        '''The type of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationtype
        '''
        return typing.cast(builtins.str, jsii.get(self, "applicationType"))

    @application_type.setter
    def application_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a03d6b192d5aaf4777c9afc86d63c6b976ccdea8ec7eca346e259bc8194d287)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "applicationType", value)

    @builtins.property
    @jsii.member(jsii_name="credentials")
    def credentials(
        self,
    ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union["CfnApplication.CredentialProperty", _aws_cdk_core_f4b25747.IResolvable]]]]:
        '''The credentials of the SAP application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-credentials
        '''
        return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union["CfnApplication.CredentialProperty", _aws_cdk_core_f4b25747.IResolvable]]]], jsii.get(self, "credentials"))

    @credentials.setter
    def credentials(
        self,
        value: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union["CfnApplication.CredentialProperty", _aws_cdk_core_f4b25747.IResolvable]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a2fd3efbdf3d5a3b2f3629763af2bb9bfe6f70df99dd42b57365f50ddc38f97)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "credentials", value)

    @builtins.property
    @jsii.member(jsii_name="instances")
    def instances(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The Amazon EC2 instances on which your SAP application is running.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-instances
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "instances"))

    @instances.setter
    def instances(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__977edcc4aa91cdeca8abf5c8b0fc68bde861783a1a6df5f60157379f4dbf6a4c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "instances", value)

    @builtins.property
    @jsii.member(jsii_name="sapInstanceNumber")
    def sap_instance_number(self) -> typing.Optional[builtins.str]:
        '''The SAP instance number of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sapinstancenumber
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sapInstanceNumber"))

    @sap_instance_number.setter
    def sap_instance_number(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fa837e926d2050f453bc7aee2e986650c9d2b75473f25895610b781d9cb79108)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sapInstanceNumber", value)

    @builtins.property
    @jsii.member(jsii_name="sid")
    def sid(self) -> typing.Optional[builtins.str]:
        '''The System ID of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sid
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sid"))

    @sid.setter
    def sid(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c503dc495bb6439dc8ce343a6d5013fcd5c5b5350f8ea5134cc956620f40fef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sid", value)

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-systemsmanagersap.CfnApplication.CredentialProperty",
        jsii_struct_bases=[],
        name_mapping={
            "credential_type": "credentialType",
            "database_name": "databaseName",
            "secret_id": "secretId",
        },
    )
    class CredentialProperty:
        def __init__(
            self,
            *,
            credential_type: typing.Optional[builtins.str] = None,
            database_name: typing.Optional[builtins.str] = None,
            secret_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The credentials of your SAP application.

            :param credential_type: The type of the application credentials.
            :param database_name: The name of the SAP HANA database.
            :param secret_id: The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-systemsmanagersap-application-credential.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_systemsmanagersap as systemsmanagersap
                
                credential_property = systemsmanagersap.CfnApplication.CredentialProperty(
                    credential_type="credentialType",
                    database_name="databaseName",
                    secret_id="secretId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__881629cc02dd1e03a98cee2ffc6e2977940f5b23d20fc71074ae39defa98798f)
                check_type(argname="argument credential_type", value=credential_type, expected_type=type_hints["credential_type"])
                check_type(argname="argument database_name", value=database_name, expected_type=type_hints["database_name"])
                check_type(argname="argument secret_id", value=secret_id, expected_type=type_hints["secret_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if credential_type is not None:
                self._values["credential_type"] = credential_type
            if database_name is not None:
                self._values["database_name"] = database_name
            if secret_id is not None:
                self._values["secret_id"] = secret_id

        @builtins.property
        def credential_type(self) -> typing.Optional[builtins.str]:
            '''The type of the application credentials.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-systemsmanagersap-application-credential.html#cfn-systemsmanagersap-application-credential-credentialtype
            '''
            result = self._values.get("credential_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def database_name(self) -> typing.Optional[builtins.str]:
            '''The name of the SAP HANA database.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-systemsmanagersap-application-credential.html#cfn-systemsmanagersap-application-credential-databasename
            '''
            result = self._values.get("database_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def secret_id(self) -> typing.Optional[builtins.str]:
            '''The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-systemsmanagersap-application-credential.html#cfn-systemsmanagersap-application-credential-secretid
            '''
            result = self._values.get("secret_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CredentialProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="@aws-cdk/aws-systemsmanagersap.CfnApplicationProps",
    jsii_struct_bases=[],
    name_mapping={
        "application_id": "applicationId",
        "application_type": "applicationType",
        "credentials": "credentials",
        "instances": "instances",
        "sap_instance_number": "sapInstanceNumber",
        "sid": "sid",
        "tags": "tags",
    },
)
class CfnApplicationProps:
    def __init__(
        self,
        *,
        application_id: builtins.str,
        application_type: builtins.str,
        credentials: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[typing.Union[CfnApplication.CredentialProperty, typing.Dict[builtins.str, typing.Any]], _aws_cdk_core_f4b25747.IResolvable]]]] = None,
        instances: typing.Optional[typing.Sequence[builtins.str]] = None,
        sap_instance_number: typing.Optional[builtins.str] = None,
        sid: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.CfnTag, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnApplication``.

        :param application_id: The ID of the application.
        :param application_type: The type of the application.
        :param credentials: The credentials of the SAP application.
        :param instances: The Amazon EC2 instances on which your SAP application is running.
        :param sap_instance_number: The SAP instance number of the application.
        :param sid: The System ID of the application.
        :param tags: The tags on the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            import aws_cdk.aws_systemsmanagersap as systemsmanagersap
            
            cfn_application_props = systemsmanagersap.CfnApplicationProps(
                application_id="applicationId",
                application_type="applicationType",
            
                # the properties below are optional
                credentials=[systemsmanagersap.CfnApplication.CredentialProperty(
                    credential_type="credentialType",
                    database_name="databaseName",
                    secret_id="secretId"
                )],
                instances=["instances"],
                sap_instance_number="sapInstanceNumber",
                sid="sid",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe33778aeb7b16a9dba7d0189c5f5a048f470709348c0579706ae68a2f55077a)
            check_type(argname="argument application_id", value=application_id, expected_type=type_hints["application_id"])
            check_type(argname="argument application_type", value=application_type, expected_type=type_hints["application_type"])
            check_type(argname="argument credentials", value=credentials, expected_type=type_hints["credentials"])
            check_type(argname="argument instances", value=instances, expected_type=type_hints["instances"])
            check_type(argname="argument sap_instance_number", value=sap_instance_number, expected_type=type_hints["sap_instance_number"])
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "application_id": application_id,
            "application_type": application_type,
        }
        if credentials is not None:
            self._values["credentials"] = credentials
        if instances is not None:
            self._values["instances"] = instances
        if sap_instance_number is not None:
            self._values["sap_instance_number"] = sap_instance_number
        if sid is not None:
            self._values["sid"] = sid
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def application_id(self) -> builtins.str:
        '''The ID of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationid
        '''
        result = self._values.get("application_id")
        assert result is not None, "Required property 'application_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def application_type(self) -> builtins.str:
        '''The type of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationtype
        '''
        result = self._values.get("application_type")
        assert result is not None, "Required property 'application_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def credentials(
        self,
    ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[CfnApplication.CredentialProperty, _aws_cdk_core_f4b25747.IResolvable]]]]:
        '''The credentials of the SAP application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-credentials
        '''
        result = self._values.get("credentials")
        return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[CfnApplication.CredentialProperty, _aws_cdk_core_f4b25747.IResolvable]]]], result)

    @builtins.property
    def instances(self) -> typing.Optional[typing.List[builtins.str]]:
        '''The Amazon EC2 instances on which your SAP application is running.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-instances
        '''
        result = self._values.get("instances")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def sap_instance_number(self) -> typing.Optional[builtins.str]:
        '''The SAP instance number of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sapinstancenumber
        '''
        result = self._values.get("sap_instance_number")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sid(self) -> typing.Optional[builtins.str]:
        '''The System ID of the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sid
        '''
        result = self._values.get("sid")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_aws_cdk_core_f4b25747.CfnTag]]:
        '''The tags on the application.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_aws_cdk_core_f4b25747.CfnTag]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnApplicationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "CfnApplication",
    "CfnApplicationProps",
]

publication.publish()

def _typecheckingstub__729b7443a11a0a8180e75c67a109cc34d03d21dedd91e684278faaae79865fd5(
    scope: _aws_cdk_core_f4b25747.Construct,
    id: builtins.str,
    *,
    application_id: builtins.str,
    application_type: builtins.str,
    credentials: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[typing.Union[CfnApplication.CredentialProperty, typing.Dict[builtins.str, typing.Any]], _aws_cdk_core_f4b25747.IResolvable]]]] = None,
    instances: typing.Optional[typing.Sequence[builtins.str]] = None,
    sap_instance_number: typing.Optional[builtins.str] = None,
    sid: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.CfnTag, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d18197a5915204881788adffa24f40d0bc5d0c04caa830906f719da8446a4ffa(
    inspector: _aws_cdk_core_f4b25747.TreeInspector,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__19658c9ec3ab5ff817fff7be055e02abec4e883e73924ee0dc5ad701b6cb334b(
    props: typing.Mapping[builtins.str, typing.Any],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e6ed51942a3a4eee1640d79e8f955ac2286de43538a09d85a646d26edb22494d(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2a03d6b192d5aaf4777c9afc86d63c6b976ccdea8ec7eca346e259bc8194d287(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1a2fd3efbdf3d5a3b2f3629763af2bb9bfe6f70df99dd42b57365f50ddc38f97(
    value: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[CfnApplication.CredentialProperty, _aws_cdk_core_f4b25747.IResolvable]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__977edcc4aa91cdeca8abf5c8b0fc68bde861783a1a6df5f60157379f4dbf6a4c(
    value: typing.Optional[typing.List[builtins.str]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__fa837e926d2050f453bc7aee2e986650c9d2b75473f25895610b781d9cb79108(
    value: typing.Optional[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1c503dc495bb6439dc8ce343a6d5013fcd5c5b5350f8ea5134cc956620f40fef(
    value: typing.Optional[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__881629cc02dd1e03a98cee2ffc6e2977940f5b23d20fc71074ae39defa98798f(
    *,
    credential_type: typing.Optional[builtins.str] = None,
    database_name: typing.Optional[builtins.str] = None,
    secret_id: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__fe33778aeb7b16a9dba7d0189c5f5a048f470709348c0579706ae68a2f55077a(
    *,
    application_id: builtins.str,
    application_type: builtins.str,
    credentials: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[typing.Union[CfnApplication.CredentialProperty, typing.Dict[builtins.str, typing.Any]], _aws_cdk_core_f4b25747.IResolvable]]]] = None,
    instances: typing.Optional[typing.Sequence[builtins.str]] = None,
    sap_instance_number: typing.Optional[builtins.str] = None,
    sid: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.CfnTag, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass
