/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.exception.NotFoundException;
import com.cmayes.common.model.Atom;
import com.cmayes.common.util.ChemUtils;
import java.util.ArrayList;
import java.util.List;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlucoseBondLengthCalculation
implements Calculation {
    private static final int LAST_CARBON_IDX = 5;
    private static final int FULL_RING_SIZE = 6;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof CpCalculationSnapshot) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((CpCalculationSnapshot)rawInput);
            try {
                this.fillCarbons(cpSnap);
            }
            catch (NotFoundException e) {
                this.logger.warn("Could not find all carbon lengths for source " + cpSnap.getSourceName(), e);
            }
            catch (IllegalStateException e) {
                this.logger.warn("Could not find all carbon lengths for source " + cpSnap.getSourceName(), e);
            }
            try {
                this.fillOxygens(cpSnap);
            }
            catch (NotFoundException e) {
                this.logger.warn("Could not find all oxygen lengths for atoms " + cpSnap.getSourceName(), e);
            }
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    private void fillCarbons(CpCalculationSnapshot cpSnap) {
        List<Atom> glucoseRing = cpSnap.getGlucoseRing();
        if (glucoseRing == null) {
            throw new IllegalStateException("Glucose ring is null");
        }
        if (glucoseRing.size() < 6) {
            throw new IllegalStateException(String.format("Glucose ring has %d atoms, which is less than six", glucoseRing.size()));
        }
        ArrayList<Double> carbLens = new ArrayList<Double>(glucoseRing.size());
        for (int i = 0; i < glucoseRing.size(); ++i) {
            int nextIdx = i + 1;
            if (i == 5) {
                nextIdx = 0;
            }
            carbLens.add(ChemUtils.vectorForAtom(glucoseRing.get(i)).distance(ChemUtils.vectorForAtom(glucoseRing.get(nextIdx))));
        }
        cpSnap.setCarbonDistances(carbLens);
    }

    private void fillOxygens(CpCalculationSnapshot cpSnap) {
        List<Atom> glucoseRing = cpSnap.getGlucoseRing();
        ArrayList<Atom> otherAtoms = new ArrayList<Atom>(cpSnap.getAtoms());
        otherAtoms.removeAll(glucoseRing);
        ArrayList<Atom> oxyAtoms = new ArrayList<Atom>(6);
        ArrayList<Double> oxyLens = new ArrayList<Double>(5);
        for (int i = 1; i < glucoseRing.size() - 1; ++i) {
            Atom curCarb = glucoseRing.get(i);
            try {
                Atom bondAtom = ChemUtils.findSingleBondAtom(curCarb, otherAtoms, AtomicElement.OXYGEN);
                oxyAtoms.add(bondAtom);
                oxyLens.add(ChemUtils.findDistance(curCarb, bondAtom));
                continue;
            }
            catch (NotFoundException e) {
                this.logger.debug("Couldn't find oxygen for carbon {}; trying to find a nitrogen instead", (Object)curCarb);
                oxyLens.add(ChemUtils.findBond(curCarb, otherAtoms, AtomicElement.NITROGEN));
            }
        }
        while (oxyAtoms.size() < 5) {
            oxyAtoms.add(null);
        }
        oxyAtoms.set(4, glucoseRing.get(0));
        try {
            Atom hmArmCarbon = ChemUtils.findSingleBondAtom(glucoseRing.get(5), otherAtoms, AtomicElement.CARBON);
            Atom bondOxy = ChemUtils.findSingleBondAtom(hmArmCarbon, otherAtoms, AtomicElement.OXYGEN);
            oxyAtoms.add(bondOxy);
            oxyLens.add(ChemUtils.findDistance(hmArmCarbon, bondOxy));
        }
        catch (NotFoundException e) {
            this.logger.debug("No non-ring carbon found for input " + cpSnap.getSourceName(), e);
        }
        cpSnap.setOxygenAtoms(oxyAtoms);
        cpSnap.setOxygenDistances(oxyLens);
    }
}

