"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""


import requests as requests_http
from .utils import utils
from .utils.retries import RetryConfig
from dataclasses import dataclass
from ivycheck import models
from typing import Callable, Dict, Tuple, Union


SERVER_PROD = 'prod'
r"""Production server"""
SERVER_SANDBOX = 'sandbox'
r"""Local server"""
SERVERS = {
	SERVER_PROD: 'https://ivycheck-backend.onrender.com',
	SERVER_SANDBOX: 'http://localhost:8000',
}
"""Contains the list of servers available to the SDK"""


@dataclass
class SDKConfiguration:
    client: requests_http.Session
    security: Union[models.Security,Callable[[], models.Security]] = None
    server_url: str = ''
    server: str = ''
    language: str = 'python'
    openapi_doc_version: str = '0.0.1'
    sdk_version: str = '0.6.6'
    gen_version: str = '2.272.1'
    user_agent: str = 'speakeasy-sdk/python 0.6.6 2.272.1 0.0.1 ivycheck'
    retry_config: RetryConfig = None

    def get_server_details(self) -> Tuple[str, Dict[str, str]]:
        if self.server_url:
            return utils.remove_suffix(self.server_url, '/'), {}
        if not self.server:
            self.server = SERVER_PROD

        return SERVERS[self.server], {}
